#!/usr/bin/env perl
# This file should be a drop-in for chktex. It is designed to generate errors that are useful for LyX.
#
# BUGS: Only processes a single file at a time. ChkTeX allows you to pass in more than one filename at
# a time. However, this is not a big problem since LyX does not use this feature of ChkTeX.

use strict;
#use diagnostics; #Not availiable in Perl 5.6.1, and not really needed
use warnings;

my $lastblank=0;
while(<STDIN>) {
	my $line=$_;
		
	if ($lastblank) { if ($line =~ /^ *\\item (?:\\\w+|[ {])*(.)/) {

		#print '  \item \hspace{1in}{{\huge $\mathcal{Z}$}}'."\n";
		#print '  \item \hspace{1in}{{\huge '.uc($1).'$\mathcal{Z}$}}'."\n";
		my $heading_char=uc($1);
		if ( $heading_char =~ /$/ ) {
			$heading_char='\\$'
		}

		print '  \item \vspace{0.1cm}\hspace{1.2cm}{{\Large $\mathcal{'.uc($1).'}$}}'."\n";
		#print $1 
	}}
	print $line;
	if ($line =~ /^\s*$/) {
		$lastblank=1
	} else {
		$lastblank=0
	}
}
