unit VistaFuncs;

interface

uses Forms, Windows;

function IsWindowsVista: Boolean;  
procedure SetVistaFonts(const AForm: TCustomForm);

const
  VistaFont = 'Segoe UI';
  XPFont = 'Tahoma';

implementation

uses SysUtils;

procedure SetVistaFonts(const AForm: TCustomForm);
var
  Size: Integer;
begin
  if not SameText(AForm.Font.Name, VistaFont) then
  begin
    Size := AForm.Font.Size;
    if not SameText(AForm.Font.Name, VistaFont) then
      Inc(Size, 1);
    AForm.Font.Name := VistaFont;
    if not SameText(AForm.Font.Name, VistaFont) then
      AForm.Font.Name := XPFont
    else
      AForm.Font.Size := Size;
  end;
end;

function IsWindowsVista: Boolean;   
var
  VerInfo: TOSVersioninfo;
begin
  VerInfo.dwOSVersionInfoSize := SizeOf(TOSVersionInfo);
  GetVersionEx(VerInfo);        
  Result := VerInfo.dwMajorVersion >= 6;
end;

end.
