# How to Use AAMfP #
Copyright © 2017, 2018, 2019 Marco Bresciani.	

![Creative Commons
License](https://i.creativecommons.org/l/by-sa/4.0/80x15.png) *AAMfP: a
simple (Personal) Kanban metrics spreadsheet* by *Marco Bresciani* is
licensed under a [Creative Commons Attribution-ShareAlike 4.0
International License](http://creativecommons.org/licenses/by-sa/4.0/).

## Spreadsheet composition ##
The whole spreasheet, in LibreOffice Calc format, contains these sheets:

* [Notes](#Notes)
* [Activities](#Activities)
* [Metrics](#Metrics)
* [Scatterplot](#Scatterplot)
* [CFD](#CFD)
* [Distribution](#Distribution)
* [StackedLT](#StackedLT)
* [Charts](#Charts)
* [Data](#Data)

All sheets can be modified and used following the
[Attribution-ShareAlike 4.0 International (CC BY-SA
4.0)](https://creativecommons.org/licenses/by-sa/4.0/) license and
criteria.

For daily normal use, [Activities](#Activities) should be the only sheet
you need to work on, while all other sheets are needed to read, report
and visualize metrics. There are no hidden sheets nor password-protected
cells. The whole spreadsheet is completely available for you, following
the license terms.

Please note that [Activities](#Activities) sheet already contains some
data. Those are sample data to show you how to use and write them. Feel
free to remove them.

----

## Notes ##
The *Notes* sheet is just a sort of cover page for the whole spreadsheet
with licensing note and a minimal set of usage instructions, usually the
same you see in the README.md file associated to it, in this site. It
also contains the version number of the whole spreadsheet, for
reference.

----

## Activities ##
For daily usage purposes, *Activities* is the only sheet you need to
work on and modify, by adding your own activities tracking.

The whole *Activities* sheet is compatible with [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool (see [Format for Data
File](https://www.actionableagile.com/format-data-file/)): simply export
*Activities* sheet as CSV (select comma (**,**) as cell separator and
quotes (**"**) for fields) and then import it in the tool.

As described in the [Format for Data
File](https://www.actionableagile.com/format-data-file/) page, The first
row contains the column names for each of the data fields.

* The first column is an item **ID** field.
* The second column is optional, and it's the **Link** to the item
  location in your Agile tool, if any.
* The third column is optional (but I strongly suggest to use it), and
  it's the item **Name** (or title or description) field.

The next set of contiguous columns are the sequential steps of the
workflow. Currently, due to the basics of Personal Kanban concepts, they
have been set to **Backlog** (optional, as described above, but I
suggest to use it), **Next**, **In-progress** and **Done**. The contents
of these columns are the date the item entered each workflow step. For
standardization purposes, the dates are displayed formatted to ISO8601
date format (year, four digits-month, two digits-day, two digits:
yyyy-mm-dd) but can be entered in dd/mm/yyyy or your local format, as
configured in LibreOffice Calc.

These above are the main mandatory columns for metrics. There are also
optional columns that may help identifying work items and their
information:

* **CoS** is the Class of Service of the work item and it should help
  differentiate items based on their Cost of Delay. Each class of
  service has a specific execution policy that the team agrees to
  follow. Those following are the basic standard classes of service
  defined in [Kanban](https://leankanban.com/shop/kanban-book/) book and
  predefined as available in this sheet. If you need other classes of
  service, feel free to modify the sheet according to the license above.
  Classes of Service can be described as:

    * *Expedite* has an unacceptable cost of delay and therefore
      requires immediate attention. It can be pulled into development,
      even in violation of current WIP limits (even if it shouldn't
      be…). Typically, there can be only one expedite item in the system
      at a time, and teams may set a policy to swarm on that item to
      make sure it moves through the system rapidly.
    * *Fixed date* describes work items that must be delivered on or
      before a specific date. Typically, the cost of delay of these
      items is nonlinear and is highly sensitive to small changes in the
      delivery date; these must be actively managed to mitigate the
      schedule risk. Therefore, these items are pulled into development
      when necessary to be finished on time. Some items may require
      additional analysis to refine the expected lead time. Some need to
      be reclassified as expedite if the team falls behind.
    * *Standard*, represents the baseline class of service, applicable
      to work items that are neither expedited nor fixed date. Most
      backlog items should fall into this category. The cost of delay is
      linear for standard items, meaning that value cannot be achieved
      until delivery occurs, but there's no fixed-date requirement.
    * *Intangible* is used for work that goes through the system that
      doesn't directly deliver value to the customer. This is work that
      needs to be done - but for which it is hard to show a return on
      investment. It is a good idea to have some Intangible work going
      through the system. It is better to set this aside when an
      Expedite comes through then work with an associated due date or
      cycle time expectation.

* **WIT** is the Work Item Type of the work item and it should help
  categorize items based on your ideas, needs and concepts. Each work
  item type is specific for the person or team or group that define it
  and it has a specific meaning. Some examples can be: "work", "home",
  "children", "taxes" or whatever category or main argument you may want
  to use to aggregate items information and types. There are no
  pre-defined WITs in this sheet.

* **Deadline** is usually used for Fixed Date CoS only and it represents
  the date before which the item shall be completed. The column value is
  anyway optional, even for Fixed Date CoS. The content is automatically
  and conditionally formatted. Deadline is: today, red cell; this week,
  orange cell; this month, yellow cell; next month, green cell. Expired
  completed activity, red text.

* **Blocked Days** represents the total number of days when the work
  item was blocked due to external dependencies or events or any reason
  for which the item itself was not available to work on. In order to be
  properly evaluated, it shall be computed as the difference between two
  dates, plus one. That is: if a work item has been blocked today only,
  the Blocked Days column shall count 1 while if the work item has been
  blocked yesterday and today, the column shall count 2, etc.

* **Deleted** is the column that contains the date when a work item has
  been considered deleted and no more bringing value to the flow. *While
  bug #6 is open*, when an activity has to be dropped, cancelled,
  abandoned, … for any reason, you have to write such cancellation date
  in all remaining columns cells and also write the same date in the
  **Deleted** column. With this, the activity will be properly
  identified as deleted.

* The **Labels** column may contain a set of strings and text
  identifiers (labels) that can be used to further filter, categorize or
  tag the work items in order to better identify and collect their
  metrics. As shown in the example data of [Actionable Agile™
  Analytics](https://www.actionableagile.com/) tool, while a single
  label can be written as `A` while possible multiple labels can be
  represented as `[A|D|Y]`. The tool will take care of using them for
  filtering purposes.

All those columns above are managed by the [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool as attributes that can
be filtered and grouped.

> In order to have correct metrics, chart, and data *you* have to keep
the *Activities* sheet rows in the correct order. Specifically, select
the whole *Activities* sheet table and apply the following sorting
criteria (all crescent order): **Done**, **In-progress**, **Next**,
**Deadline**, **Backlog**, **ID**. Once the column are ordered in this
way, you can scroll all other sheets where you can find the metrics and
charts.

---

## Metrics ##
The *Metrics* sheet contains a set of metrics computed from the data
above. Mainly, together with a few duplication of information (activity
**ID**, **Name**, and **Done** date) for bettere reference and
readability, for each row there is an activity that has these metrics
and columns:

* **Backlog**, **Next** and **In-progress** columns that contain the
  number of days spent by the activity in each column. If the activity
  enters and exists a column on the same day, the count will show 0.
* the **95%**, **85%**, **70%**, **50%** columns that represent the
  moving percentile of the completed activities Lead Times. You can find
  a description of percentile in
  [Percentile](https://en.wikipedia.org/wiki/Percentile) page on
  Wikipedia. For more details, see [Actionable Agile Metrics for
  Predictability](https://leanpub.com/actionableagilemetrics) book.
* **LT** computes the Lead Time for each completed activity;
* **mLT** contains the moving average of all the Lead Times of the
  completed activities;
* **Age** contains, for all not-completed activities, the number of days
  since the activity is in progress (since in entered in **Next**);
* **Blocked Days** contains the total number of days the activity has
  been blocked;
* **Impact** is computed (as described in [Kanban Maturity
  Model](https://www.kanbanmaturitymodel.com/) book), for a completed
  activity, by summing the total of blocked days of all previously
  **Done** activities (current included), divided by the number of
  activities. It represents the average number of blocker days per
  activity;
* **Likelihood** is computed (as described in [Kanban Maturity
  Model](https://www.kanbanmaturitymodel.com/) book), for a completed
  activity, by counting the total number of blockers of all previously
  **Done** activities (current included), divided by the number of
  activities. It represents the average probability of having a blocker
  per activity;
* **Actual Effort** is computed, for a completed activity, considering,
  for each day of the progress life of the activity, the number of
  parallel activities ongoing in the system (that is, the daily WIP).
  e.g. While a single activity counts as 1 day of effort per day, if
  there are two parallel activities (WIP = 2), the actual effort, per
  activity, is 1/2 (or half) day. So, summing up all these daily actual
  efforts, this column contains the total number of days actually worked
  on the activities, blockers included;
* **Risk** is computed (as described in [Kanban Maturity
  Model](https://www.kanbanmaturitymodel.com/) book), for a completed
  activity, by multipling the Impact and the Likelihood. It represents
  the average number of blocker days that may appear in activities;
* **FE** (or Flow Efficiency) is computed, for each completed activity,
  as the total number of blocker days over the lead time. e.g. If an
  activity has been completed in 13 days but it has been blocked for 10
  days, its FE is 23,08%;
* **mFE** contains the moving average of all the Flow Efficiencies of
  the completed activities.

----

## Scatterplot ##
The *Scatterplot* sheet contains the "Lead Times Scatterplot", a scatter
plot chart of the Lead Times of completed and ongoing activities,
starting from the earliest to the current date. The scatter plot shows:

* a blue dot for each "Done" activity with the value of its
  corresponding *LT* (Lead Time);
* a black upward pointing triangle for each in progress activity with
  the value of its current *Age* (number of days since it entered "Next"
  state);
* a red dotted line representing the moving average of the *95th
  percentile* of the values;
* an orange dotted line representing the moving average of the *85th
  percentile* of the values;
* a yellow dotted line representing the moving average of the *70th
  percentile* of the values;
* a green dotted line representing the moving average of the *50th
  percentile* of the values;
* a gray thin dotted line representing the moving average of the values
  themselves (*mLT*).

The horizontal axis is a timeline and each activity is marked on the
completion ("Done") date. The vertical axis represents the number of
days: lead time of completed activities goes from the committment point
(when the activity enters the "Next" column) to the "Done" status
(either actual completion or discard); age of ongoing activities goes
from the committment point.

This chart is a representation of how long it takes to get things done
for individual activities on your Kanban board.

Possible uses for scatterplots are:

* visualize clearly the lead times of the activities, possibly filtering
  them according to CoS or WIT;
* compare different WITs lead times;
* forecast the lead time of future activities.

For a detailed description of the behaviours and ways to read a lead
time scatterplot, take a look at this article by
[Kanbanize](https://kanbanize.com/): [Using Scatter Plot to Measure and
Forecast Cycle
Time](https://kanbanize.com/kanban-resources/kanban-analytics/cycle-time-scatter-plot/)
with further details on [Meet the Cycle Time Scatterplot from Premium
Analytics](https://kanbanize.com/blog/premium-cycle-time-scatterplot/).

----

## CFD ##
The *CFD* sheet contains the "Cumulative Flow Diagram" of the whole
daily history of activities, starting from the earliest to the current
date. The CFD shows:

* a blue line showing the cumulative total number of activities that
  were created (*Backlog*);
* a red line showing the cumulative total number of activities that has
  been commited (moved to *Next* column);
* a yellow line showing the cumulative total number of activities that
  has been worked on (moved to *In-progress* column);
* a green line showing the cumulative total number of activities that
  has been completed or cancelled (moved to *Done* column).

The horizontal axis is a timeline and each activity is marked on the
date of status update. The vertical axis represents the number of
activities for such status on the reference date. This chart is a
representation of the ongoing status of the service flow.

For a detailed description of the behaviours and issues you can find
with a CFD, take a look at this relevant and interesting article by
Pawel Brodzinski on his blog: [Cumulative Flow
Diagram](http://brodzinski.com/2013/07/cumulative-flow-diagram.html).

----

## Distribution ##
The *Distribution* sheet contains a set of data and mini charts related
to the distribution of the lead times.

* The **F(LT)** column contains the frequency related to lead times, the
  number of completed activities that had a lead time less than or equal
  to the *A* colum in the same sheet. This table column is also plotted
  as histogram ("Lead Times Distribution" bar chart) showing the actual
  distribution of lead time frequencies;

* The **Weibull** column contains the computed values of the Weibull
  distribution that mostly resemble the current actual distribution of
  lead time values described by the **F(LT)** column. This table column
  is also plotted as the dotted red line overlapped to the "Lead Times
  Distribution" bar chart. The Weibull distribution has been computed
  from the values of   **Shape** and **Scale** that have been calculated
  from the
  **Percentile(LT)** values.

> DRAFT
> **Shape** is computed from the 35% and 70% percentile values in the
**Percentile(LT)** column with the formula [TBD: I know I've found it
somewhere, but can't remember].
> **Scale** is computed from **Shape** with the formula [TBD: I know
I've found it somewhere, but can't remember].

* The "Flow Efficiency" is the run chart for **FE** (Flow Efficiency)
with its moving average **mFE** from the FE and mFE columns in
[Metrics](#Metrics) sheet;

* **Percentile(LT)** and **Percentile(Backlog)** columns represents the
current percentile values for Lead Time and Backlog age, the latter
being the number of days an activity remains in the Backlog (since it
has been created) before being took in charge and worked on;

* The **Daily Run Chart** is the run chart for the daily values of
Backlog (number of activities waiting), Throughput (number of daily
completed activities) and WIP (number of ongoing activities).

* **CoS Ratio** pie chart shos the CoS ratio with respect to the total
number of activities. Being using the four standard classes of services,
the colours are those defined as examples in
[Kanban](https://leankanban.com/shop/kanban-book/) book. 

----

## StackedLT ##
This sheet contains the "Lead Times Detail", a stacked bar chart
representing the Lead Time split according to time spent in each status.
For example: if a completed activity has spent 2 days in Backlog, 3 days
in Next and 12 days in In-progress, then the bar for such activity will
be 17 days long, split in three differently coloured sections: a green
part, 2 days long, for Backlog; a yellow part, 3 days long, for Next and
a read part, 12 days long, for In-progress. Keeping the same conventions
as in the [CFD](#CFD) chart, thhis chart shows:

* a blue vertical bar showing the total number of days a completed
  activity has spent in the *Backlog* column;
* a red vertical bart showing the total number of days a completed
  activity has spent in the *Next* column;
* a yellow vertical bar showing the total number of days a completed
  activity has spent in the *In-progress* column.
 
These are actual days: if an activity has been moved from *Backlog* to
*Done* in the same day, all column will be 0 (zero), but the
corresponding Lead Time for such activity will be 1 (one) day.

----

## Charts ##
This sheet contains a set of mini charts that may help in better
understanding the process status and activities situation. In order to
simplify readability and usability, charts have been protected in terms
of both position and size. To unprotect a chart, simply right click on
it, select "position and size..." menu entry and in the "position and
size" tab you can fine the "Protect" checkboxes that you can disable to
resize and move the charts.

* *Little's Law*, is the *LT = WIP / Thr* chart that represents the
  three terms of Little's Law. Running average of WIP, computed on
  actual data; running average of Throughput, computed on actual data;
  Running average of Lead Time, computed as ratio between those two
  values;
* *Little's Law (7 days)*, is the *LT = WIP / Thr* chart that represents
  the three terms of Little's Law. Running average of WIP, computed only
  on the latest seven days of actual data; running average of
  Throughput, computed only on the latest seven days of actual data;
  Running average of Lead Time, computed as ratio between those two
  values.
* *I/O speed*, is the chart that represents the speed of incoming and
  outgoing activities, in term of average number of activities per day.
* *WIP Run Chart*, is the chart that shows the ongoing daily WIP values
  together with the moving average and the weekly moving average (moving
  average computed only on the latest seven days of actual data);
* *Blockers*, is the chart that represents the average likelihood
  (probability) that a blocker might happen during an activity life and
  the impact blockers may have in an activity, that is the average
  number of blockers that may happen during an activity lifetime.
* *Approximate Average Lead Time*, is the chart that shows the trend of
  the approximate average lead time, as shown by the CFD chart. The
  approximate average lead time is described in chapter 9 of the
  [Actionable Agile Metrics for
  Predictability](https://leanpub.com/actionableagilemetrics) book and a
  practical example is show in [Actionable Agile Metrics for
  Predictability by Daniel S. Vacanti, Re-read Saturday Week 10: Flow
  Debt](https://tcagley.wordpress.com/2017/12/23/actionable-agile-metrics-for-predictability-by-daniel-s-vacanti-re-read-saturday-week-10-flow-debt/#more-9151)
  while reviewing and commenting the book itself.

Since the same data are sometimes shown in different charts, in order to
improve readability, the data always use the same colouring throughout
the charts in this sheet. So, for example, mLT is alway a blue line,
both in "Little's Law" and in "Approximate Average Lead Time" charts;
mWIP(7) is always a dotted red line, etc.

----

## Data ##
The *Data* sheet is the daily representation of the whole board, with
reference metrics needed for each day (*Date* column). Together with the
daily number of activities for each column (*Backlog*, *Next*,
*In-progress*, *Done*), the sheet contains:

* the daily throughput (*Thr*), the number of completed activities for
  the day, that is the number of activities moved to *Done* column;
* the moving average throughput since the initial period (*mThr*);
* the moving average throughput of the latest seven days (*mThr(7)*);
* the daily *WIP*, the number of currently ongoing activities (*Next*,
  *In-progress*);
* the moving average WIP since the initial period (*mWIP*);
* the moving average WIP of the latest seven days (*mWIP(7)*);
* the average lead time (*mLT*) computed as mWIP / mThr;
* the average lead time (*mLT(7)*) computed as mWIP(7) / mThr(7);
* the actual *Daily Effort* per activity, as the multiplicative inverse
  of *WIP* (1 / *WIP*);
* the daily *Incoming* and *Outgoing* rates for activities as described
  in [Actionable Agile Metrics for
  Predictability](https://leanpub.com/actionableagilemetrics) book;
* the set of actually cumulative daily data of activities for each
  column (*Backlog*, *Next*, *In-progress*, *Done*);
* the Approximate Average Lead Time (*AALT*), computed as described in
  [Actionable Agile Metrics for
  Predictability](https://leanpub.com/actionableagilemetrics) book.
