<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** Interface to write log */
interface ILogger {

	/** Log an error.
	 * @param String $sSource The source tag.
	 * @param String $sMessage The message to log.
	 * @param Exception $exception An eventual exception that caused the error.
	 * Can be NULL.
	 */
	public function logError($sSource, $sMessage, $exception);

	/** Log a warning that should be gracefully handled by server.
	 * @param String $sSource The source tag.
	 * @param String $sMessage The message to log.
	 * @param Exception $exception An eventual exception that caused the error.
	 * Can be NULL.
	 */
	public function logWarning($sSource, $sMessage, $exception);

	/** Log debug information.
	 * @param String $sSource The source tag.
	 * @param String $sMessage The message to log.
	 * @param Exception $exception An eventual exception that caused the error.
	 * Can be NULL.
	 */
	public function logDebug($sSource, $sMessage);
}

?>
