<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// this function is used to return multiple entries as an item array
// the core uses this to obtain a row and return it in a feed format it
// can understand (default is RSS 2.0)

function moduleFeed_blg($blog_id = null) {
	
	global $db, $lang, $core_config;
	
	$feed_source = array();
	
	if (isset($blog_id)) {
		$query = "
			SELECT e.blog_id, e.entry_id, e.entry_title, e.entry_synopsis, 
			e.entry_create_datetime, i.identity_nic, b.blog_title, b.blog_synopsis 
			FROM " . $db->prefix . "_blog_entry e, " . $db->prefix . "_user_identity i, " . $db->prefix . "_participation p, " . $db->prefix . "_blog b 
			WHERE 
			p.module_id=" . $core_config['module_id']['blog'] . " AND 
			p.item_id=" . $blog_id . " AND 
			e.user_id=p.user_id AND 
			p.identity_id=i.identity_id AND 
			b.blog_id=e.blog_id AND 
			e.blog_id=" . $blog_id . "
			order by e.entry_create_datetime desc"
		;
		
		$result = $db->Execute($query);

		if (isset($result->fields)) {
			
			$lang['txt_title'] = $result->fields[0]['blog_title'];
			$lang['txt_description'] = $result->fields[0]['blog_synopsis'];
			
			while (!$result->EOF) {
				$item = array();
				
				$item['item_title'] = $result->fields['entry_title'];
				$item['item_synopsis'] = $result->fields['entry_synopsis'];
				$item['item_url'] = "index.php?amn=blg_item&entry_id=" . $result->fields['entry_id'];
				$item['item_create_datetime'] = $result->fields['entry_create_datetime'];
				$item['item_author'] = $result->fields['identity_nic'];
				
				array_push($feed_source, $item);
				$result->MoveNext();
			}

			$result->Close();
		}
		
	}
	
	return $feed_source;
}

?>