<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// this include file is used in the core and in the event
// if it receives either a item_id or a event_id it gets the event
// if it returns the event it checks your participation in that

$menu_section = "blog";

// SETUP blog ---------------------------------------------------------
$blog_config['module_id'] = $core_config['module_id']['blog'];

require_once('components/blg/class/Blog.class.php');
$blog = new blog($db, $blog_config);

if (empty($_SESSION['md5'])) {
	$blog->level_id = $blog_config['level']['public'];
	$blog->membership_type_id = 0;
}
else {
	$blog->membership_type_id = $_SESSION['membership_type_id'];
}

require_once('components/core/class/Participation.class.php');
$participation = new Participation($db, $core_config);
$participation->module_id = $core_config['module_id']['blog'];


if (!empty($_REQUEST['entry_id'])) {
	$output_entry = $blog->selEntry($_REQUEST['entry_id']);
	$output_blog = $blog->selBlog($output_entry['blog_id']);
}
elseif (!empty($_REQUEST['blog_id'])) {

	$output_blog = $blog->selBlog($_REQUEST['blog_id']);
	$output_entry = $blog->selEntry(null, $output_blog['blog_id']);
}
elseif (!empty($_REQUEST['item_id'])) {
	$output_blog = $blog->selBlog($_REQUEST['item_id']);
	$output_entry = $blog->selEntry(null, $output_blog['blog_id']);
}

if (isset($output_blog)) {
	// a participant is a contributor; someone who has edited a page revision
	$participation->item_id = $output_blog['blog_id'];
	
	if (isset($_SESSION['user_id'])) {
		$output_participation = $participation->selParticipation($_SESSION['user_id']);
	}
	else { // we are not logged in
		if ($output_blog['level_id'] == $blog_config['level']['public']) {
			$output_participation = array();
		}
		else {
			header("Location: index.php?amn=blg_overview&" . strip_tags(SID));
			exit;
		}
	}
	
	if (!empty($output_participation)) {
		$tpl->set('participation', $output_participation);
		$body->set('participation', $output_participation);
	}
	else {
		unset($output_participation);
	}
	
	$tpl->set('blog', $output_blog);
	$body->set('blog', $output_blog);
}



// we authenticate the user
if (isset($output_blog['blog_id']) && $script_name != "participation_edit") {
	//check status	
	if (isset($output_participation['status_id']) && $output_participation['status_id'] == $blog_config['user']['status']['barred']) {
		header("Location: index.php?amn=lbr_participate&" . strip_tags(SID));
		exit;
	}
	elseif ($output_blog['level_id'] < $blog_config['level']['public'] && $output_blog['blog_type'] == $blog_config['type']['membership_type'] && $output_blog['user_id'] != $_SESSION['user_id']) {
		// we need to check that my membership_type corresponds to those that can access the set
		if (!$participation->checkSetMembershipTypeAccess($_SESSION['membership_type_id'])) {
			header("Location: index.php?amn=blg_overview&" . strip_tags(SID));
			exit;
		}
	}
}

$tpl->set("blog_config", $blog_config);
$body->set("blog_config", $blog_config);


// FULLSCREEN MODE ------------------------------------------
// there is no full screen mode for the blog
unset ($_SESSION['fullscreen']);

?>
