<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more detailb.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Blog {



	// Blog --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 18th May 2004
	//
	function Blog($db, $blog_config) {
		$this->db = $db;
		$this->blog_config = $blog_config;
	}//EO Blog
	
	
	
	// selBlogs --------------------------------------------------------------------
	// Return a list of Blogs
	// tom calthrop - 20th June 2006
	//
	function selBlogs() {

	    $query = "
			SELECT DISTINCT b.blog_id, b.blog_title, b.blog_synopsis, 
			b.user_id, b.file_id, b.blog_type, 
			b.blog_create_datetime, b.blog_permission, b.status_id, 
			b.level_id 
			FROM " . $this->db->prefix . "_blog b 

			LEFT JOIN " . $this->db->prefix . "_mem_type_access mt ON b.blog_id=mt.item_id and mt.module_id=" . $this->blog_config['module_id'] . " 
			WHERE "
		;
		
		if (isset($this->status_id)) {
		    $query .= "b.status_id=" . $this->status_id . " AND ";
		}
		
		if (isset($this->level_id)) {
		    $query .= "b.level_id=" . $this->level_id . " AND ";
		}
		
		if (isset($this->user_id)) {
		    $query .= "b.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->blog_ids)) {
			$query .="b.blog_id in (" . implode(",", $this->blog_ids) . ") AND ";
		}
		
		$query .= "(b.blog_type!=" . $this->blog_config['type']['membership_type'] . " OR ";
		$query .= "(b.blog_type=" . $this->blog_config['type']['membership_type'] . " AND mt.membership_type_id=". $this->membership_type_id . ")) AND ";
		
		$query .= "1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by b.blog_title";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				if (isset($this->file)) {
					
					if (isset($temp1['file_id'])) {
	 					$temp1['image'] = $this->file->selFile($temp1['file_id'], $this->file->thumb);
	 				}
	 				else {
	 					$temp1['image']['file_title'] = "";
	 					$temp1['image']['file_md5_name_view'] = "0-" . $this->file->no_image;
	 				}
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selBlogs class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selBlogs();



	// selEntry --------------------------------------------------------------------
	// select a Blog entry
	// tom calthrop - 21st June 2006
	//
	function selEntry($entry_id = null, $blog_id = null) {

		$query = "
			SELECT entry_id, entry_title, entry_synopsis, blog_id, 
			entry_create_datetime, entry_edit_datetime, user_id, 
			entry_body 
			FROM " . $this->db->prefix . "_blog_entry 
			WHERE "
		;
		
		if (isset($entry_id)) {
			$query .= "entry_id=" . $entry_id . " AND ";
		}
		
		if (isset($blog_id)) {
			$query .= "blog_id=" . $blog_id . " AND ";
		}
		
		$query .="1=1 ";
		
		$result = $this->db->SelectLimit($query, 1);

		if (isset($result->fields)) {
			$temp = $result->fields;
			return $temp;
		}
		else {
			$error_info = "method=selEntry class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}

	}//EO selEntry
	
	
	
	// selEntries --------------------------------------------------------------------
	// used to list the entry_names held in this Blog against a blog
	// tom calthrop - 21st June 2006
	//
	function selEntries($blog_id = null) {
		$query = "
			SELECT entry_id, entry_title, entry_synopsis, 
			entry_create_datetime 
			FROM " . $this->db->prefix . "_blog_entry  
			WHERE " 
		;
		
		if (isset($blog_id)) {
			$query .= "blog_id=" . $blog_id . " AND ";
		}
		
		if (isset($this->entry_ids)) {
			$query .="entry_id in (" . implode(",", $this->entry_ids) . ") AND ";
		}
		
		$query .= "1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by entry_create_datetime desc";
		}
				
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selEntries class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selEntries();
	
	
	
	// selBlog --------------------------------------------------------------------
	// Return a list of blog bets
	// tom calthrop - 20th June 2006
	//
	function selBlog($blog_id) {

	    $query = "
			SELECT blog_id, blog_title, blog_synopsis, blog_type, 
			user_id, file_id, language_id, blog_create_datetime, 
			blog_permission, status_id, 
			default_user_permission, level_id 
			FROM " . $this->db->prefix . "_blog 
			WHERE 
			blog_id=" . $blog_id
		;
		
		$result = $this->db->SelectLimit($query, 1);

		if (isset($result->fields)) {
			return $result->fields;
		}
		else {
			$error_info = "method=selBlog class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selBlog();
	
	
	
	// selBlogRoll --------------------------------------------------------------------
	// used to list the blogs linked to a blog
	// tom calthrop - 21st June 2006
	//
	function selBlogRoll($blog_id) {
		$query = "
			SELECT br.blog_id, br.related_blog_id, br.user_id, 
			b.blog_title 
			FROM " . $this->db->prefix . "_blog_roll br, " . $this->db->prefix . "_blog b 
			WHERE 
			br.blog_id=" . $blog_id . " AND 
			br.related_blog_id=b.blog_id "
		;
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by blog_create_datetime desc";
		}
				
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selBlogRoll class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selBlogRoll();
}
?>
