<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


$menu_section= "group";

$output_group['item_id'] = $output_group['group_id'];
$body->set('item', $output_group);



// SETUP COMMENTS --------------------------------------------------------
require_once('components/core/class/Comment.class.php');
$comment = new Comment($db, $core_config['module_id']['group'], $output_group['group_id']);
$comment->item_id = $output_group['group_id'];


// GET FAVOURITES --------------------------------------------------------
require_once('components/core/class/Bookmark.class.php');
$bookmark = new Bookmark($db, $core_config['module_id']['group'], $output_group['group_id']);
// get my bookmarked favourites
$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
$bookmark->user_id = $output_identity_relation['user_id'];

$output_bookmarks = $bookmark->selBookmarks(1);


if (!empty($output_bookmarks)) {
	foreach ($output_bookmarks as $key => $i):
		$group->subject_ids[] = $i['inner_item_id'];
	endforeach;
	
	if (!empty($group->subject_ids)) {
		$output_bookmarks = $group->selSubjects();
	}
	
	if (!empty($output_bookmarks)) {
		$body->set('recommendations', $output_bookmarks);
	}
}


// GET USER STATISTICS ---------------------------------------------------
require_once('components/core/class/Statistic.class.php');
$statistic = new Statistic($db, $group_config['statistic']);
$statistic->module_id = $core_config['module_id']['group'];
$statistic->item_id = $output_group['group_id'];
$statistic->user_id = $output_identity_relation['user_id'];

$output_statistics['group'] = $statistic->selStatistics();

if (!empty($output_statistics)) {
	$body->set('statistics', $output_statistics);
}



// SETUP FILE -------------------------------------------------
$group->file = new File($db, $core_config['file']);
$group->file->module_id = $core_config['module_id']['group'];
$group->file->core_config_module = $core_config['module'];
$group->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$group->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];



// GET LATEST SUBJECTS ----------------------------------------------------
$group->limit = 6;
$group->user_id = $output_identity_relation['user_id'];

$output_subjects = $group->selSubjects();

if (!empty($output_subjects)) {
	$comment->limit = 1;
	$comment->order_by = "c.comment_create_datetime desc";
	
	foreach ($output_subjects as $key => $i):
		$comment->inner_item_id = $i['subject_id'];
		
		// get comment count
		$output_subjects[$key]['total_comments'] = $comment->countComments();
		
		// get latest comment for each subject
		$output_subjects[$key]['latest_comment'] = $comment->selComments($i['subject_id']);
		
		// get user
		$output_subjects[$key]['identity'] = $user->selUserIdentity($i['user_id']);
	endforeach;
	
	$body->set('subjects', $output_subjects);
}


// GET LATEST COMMENTS ----------------------------------------------
$comment->limit = 6;
$comment->user_id = $output_identity_relation['user_id'];
$comment->order_by = "c.comment_create_datetime desc";
$output_comments = $comment->selComments();

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}




if (!empty($_SESSION['md5'])) {
	// GET AND SET RELATIONSHIP -----------------------------------------------
	if (isset($output_participation)) {
		require_once ("components/core/class/Tie.class.php");
		$tie = new Tie($db, $core_config);
		$tie->module_id = $core_config['module_id']['group'];
		$tie->item_id = $output_group['group_id'];
		
		$output_relationship = $tie->selRelation($output_participation['identity_id'], $output_identity['identity_id']);
		
		if (empty($output_relationship) && !empty($_REQUEST['respect'])) {
			
			$tie->user_id = $_SESSION['user_id'];
			
			$data['identity_id'] = $output_participation['identity_id'];
			$data['identity_id_relation'] = $output_identity_relation['identity_id'];
		
			if (!empty($_REQUEST['portable'])) {
				$data['relation_portable'] = 1;
			}
			
			$tie->insertRelation($data);
			
			$output_relationship = $tie->selRelation($output_participation['identity_id'], $output_identity_relation['identity_id']);
		}		
		
		
		if (!empty($output_relationship)) {
			if ($tie->isMutual($output_identity['identity_id'], $output_participation['identity_id'])) {
				$output_relationship['mutual'] = 1;
			}
			
			$body->set('relationship', $output_relationship);
		}
	}
}


?>
