<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "group";

include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");


require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->module_id = $core_config['module_id']['group'];
$file->core_config_module = $core_config['module'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
$group->file = $file;

/*
// SETUP WIKI -----------------------------------------------------------
require_once('components/core/class/Wiki/Wiki.php');
require_once ('components/core/class/Wiki/Wiki/Parse.php');
require_once ('components/core/class/Wiki/Wiki/Render.php');
$wiki = new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
*/

// SETUP COMMENTS --------------------------------------------------------
require_once('components/core/class/Comment.class.php');
$comment = new Comment($db, $core_config['module_id']['group']);
//$comment->wiki = $wiki;


// GET LATEST SUBJECTS ----------------------------------------------------
$group->limit = 16;

$output_subjects = $group->selSubjects();

if (!empty($output_subjects)) {
	$comment->limit = 1;
	$comment->order_by = "c.comment_create_datetime desc";
	
	foreach ($output_subjects as $key => $i):
		$comment->inner_item_id = $i['subject_id'];
		
		// get comment count
		$output_subjects[$key]['total_comments'] = $comment->countComments();
		
		// get latest comment for each subject
		$output_subjects[$key]['latest_comment'] = $comment->selComments($i['subject_id']);
		
		// get user
		$output_subjects[$key]['identity'] = $user->selUserIdentity($i['user_id']);
	endforeach;
	
	$body->set('subjects', $output_subjects);
}


// GET LATEST GROUPS
$group->limit = 4;
$group->order_by = "group_create_datetime desc";
$output_groups = $group->selGroups();

if (!empty($output_groups)) {
	$body->set('groups', $output_groups);
}

unset ($group->order_by, $group->limit);


// participation in wiki sets
if (isset($_SESSION['user_id'])) {
	require_once('components/core/class/Participation.class.php');
	$participation = new Participation($db, $core_config);
	$participation->module_id = $core_config['module_id']['group'];
	$participation->status_id = $group_config['user']['status']['active'];
	
	$output_participation = $participation->selParticipants(null, null, $_SESSION['user_id']);
	
	if (!empty($output_participation)) {
		// we get item_id's and we get the sets from that
		foreach ($output_participation as $key => $i):
			$group->group_ids[] = $i['item_id'];
		endforeach;
		
		
		if (!empty($group->group_ids)) {
			$output_my_groups = $group->selGroups();
			
			$body->set('my_groups', $output_my_groups);
		}
	}

	// FAVOURITES -----------------------------------------
	require_once('components/core/class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $core_config['module_id']['group']);
	
	// get my bookmarked favourites
	$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
	$output_bookmarks = $bookmark->selBookmarks(1);
	
	if (!empty($output_bookmarks)) {
		// we get item_id's and we get the sets from that
		foreach ($output_bookmarks as $key => $i):
			$group->page_ids[] = $i['inner_item_id'];
		endforeach;
		
		unset ($group->file);
		
		if (!empty($group->page_ids)) {
			$output_my_bookmarks = $group->selSubjects(null, 1);
			
			if (!empty($output_my_bookmarks)) {
				$body->set('my_bookmarks', $output_my_bookmarks);
			}
		}
		
	}
	
	// REVISIONS FROM RESPECTED NETWORK
	unset($participation->item_id);
	
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$file->directory = "core";
	$user->file = $file;
	$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];

	$output_respected_network = $participation->selRelations();
	
	if (!empty($output_respected_network)) {
		// add their identities
		foreach ($output_respected_network as $key => $i):
			$user->identity_ids[] = $i['identity_id'];
		endforeach;
		
		$user->identity_ids = array_unique($user->identity_ids);
		
		if (!empty($user->identity_ids)) {
			$output_identities = $user->selUserIdentities();
			
			// we place the identities against the participants
			if (!empty($output_identities)) {
				foreach ($output_respected_network as $keyp => $p):
					foreach ($output_identities as $keyi => $i):
						
						if ($p['identity_id'] == $i['identity_id']) {
							$output_respected_network[$keyp]['identity'] = $i;
							break;
						}
					endforeach;
				endforeach;
			}
		}
		
		
		// get their latest subjects
		foreach ($output_respected_network as $key => $i):
		
			$query = "
				SELECT s.subject_id, s.subject_title, 
				s.subject_create_datetime 
				FROM " . $db->prefix . "_group_forum_subject s, " . $db->prefix . "_participation p 
				WHERE 
				s.user_id=" . $i['identity']['user_id'] . " AND 
				p.module_id=" .$core_config['module_id']['group'] . " AND
				p.identity_id=" . $i['identity']['identity_id'] . " AND 
				p.user_id=r.user_id 
				order by s.subject_create_datetime desc"
			;
			
			$result = $db->SelectLimit($query, 1);
	
			if (isset($result->fields)) {
				$output_respected_network[$key]['subject'] = $result->fields;
			}
		endforeach;
		
		$body->set('tied_subjects', $output_respected_network);
		
		// get latest comments from respected network
		require_once('components/core/class/Comment.class.php');
		$comment = new Comment($db, $core_config['module_id']['group']);
		$comment->module_id = $core_config['module_id']['group'];
		
		foreach ($output_respected_network as $key => $i):
			$comment->user_ids[] = $i['identity']['user_id'];
		endforeach;
		
		$comment->user_ids = array_unique($comment->user_ids);
		
		if (!empty($comment->user_ids)) {
			$comment->order_by = "c.comment_create_datetime desc";
			$comment->limit = 10;
			
			$output_tied_comments = $comment->selComments();
			
			// cut down comment body and apply identities
			if (!empty($output_identities)) {
				foreach ($output_tied_comments as $keyp => $p):
					foreach ($output_identities as $keyi => $i):
						if ($p['identity_id'] == $i['identity_id']) {
							$output_tied_comments[$keyp]['identity'] = $i;
							break;
						}
					endforeach;
				endforeach;
			}
			
			$body->set('tied_comments', $output_tied_comments);
		}
	}
}

?>
