<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "group";

include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");


if (isset($_REQUEST['topic_id'])) {
	$output_topic = $group->selTopic($_REQUEST['topic_id']);
}

if (!empty($output_topic)) {
	$body->set('topic', $output_topic);
	
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->core_config_module = $core_config['module'];


	$group->file = $file;
	$group->file->module_id = $core_config['module_id']['group'];
	$group->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$group->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
	
	
	// SETUP COMMENTS --------------------------------------------------------
	require_once('components/core/class/Comment.class.php');
	$comment = new Comment($db, $core_config['module_id']['group'], $output_group['group_id']);
	$comment->item_id = $output_group['group_id'];
	
	
	if (isset($_POST['search'])) {
		$group->search_items[] = $_POST['search_text'];
	}
	
	$group->order_by = "s.subject_sticky desc, s.subject_create_datetime desc";
	$output_subjects = $group->selSubjects($output_topic['topic_id']);
	
	if (!empty($output_subjects)) {
		$comment->limit = 1;
		$comment->order_by = "c.comment_create_datetime desc";
		
		foreach ($output_subjects as $key => $i):
			$comment->inner_item_id = $i['subject_id'];
			
			// get comment count
			$output_subjects[$key]['total_comments'] = $comment->countComments();
			
			// get latest comment for each subject
			$output_subjects[$key]['latest_comment'] = $comment->selComments($i['subject_id']);
			
			// get user
			$output_subjects[$key]['identity'] = $user->selUserIdentity($i['user_id']);
		endforeach;
		
		$body->set('subjects', $output_subjects);
	}
	
	// get coordinator
	$output_coordinator = $participation->selParticipation($output_topic['user_id']);
	
	if (!empty($output_coordinator)) {
		$output_coordinator = $user->selUserIdentity(null, $output_coordinator['identity_id']);
		
		$body->set('coordinator', $output_coordinator);
	}
	
}
else {
	header("Location: grp_item.php?group_id=" . $output_group['group_id'] . "&" . strip_tags(SID));
	exit;
}

//get topics
unset($group->order_by);
$output_topics = $group->selTopics(1);
$body->set('topics', $output_topics);

?>
