<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "group";

include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");

$body->set('group_config', $group_config);

$output_group['team']['coordinator'] = $participation->selParticipants(null, $group_config['role']['coordinator']);
$output_group['team']['arbiter'] = $participation->selParticipation($output_group['user_id']);

	
if (!empty($output_group['team']['coordinator'])) {
	foreach ($output_group['team']['coordinator'] as $key => $i):
		// we remove owner from coordinator listing
		if ($i['user_id'] == $output_group['user_id']) {
			unset($output_group['team']['coordinator'][$key]);
		}
		else {
			$user->identity_ids[] = $i['identity_id'];
		}
	endforeach;
}

if (!empty($output_group['team']['arbiter']['identity_id'])) {
	$user->identity_ids[] = $output_group['team']['arbiter']['identity_id'];
}

require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->module_id = 0; // core
$file->directory = "core";
$file->thumbs = $core_config['file']['image']['thumb'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$user->file = $file;

// get identities
if (!empty($user->identity_ids)) {
	$user->identity_ids = array_unique($user->identity_ids);

	$output_identities = $user->selUserIdentities();

	if (!empty($output_identities)) {
		$body->set('identities', $output_identities);
	}
}

if ($core_config['xhtml_markup']['format']['nl2br'] == 1) {
	$output_group['group_policy'] = renderHTML($output_group['group_policy']);
}

$tpl->set('group', $output_group);
$body->set('group', $output_group);

?>
