<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "group";

include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");

if (isset($_POST['update_poll']) || isset($_POST['update_poll_go'])) {
	// save poll
	$rec = array();
	$rec['poll_question'] = strip_tags($_POST['poll_question']);
	
	if (!empty($_POST['poll_anon'])) {
		$rec['poll_anon'] = 1;
	}
	else {
		$rec['poll_anon'] = "null";
	}
	
	if (!empty($_POST['poll_id'])) { // we update
		
		$query = "
			SELECT * 
			FROM " . $db->prefix . "_group_poll 
			WHERE 
			poll_id=" . $_POST['poll_id']
		;
		
		$result = $db->Execute($query);

		if (isset($result->fields)) {
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
			
		$poll_id = $_POST['poll_id'];
			
	}
	else { // we insert
		$rec['poll_create_datetime'] = time();
		$rec['user_id'] = $_SESSION['user_id'];
		$rec['group_id'] = $output_group['group_id'];
		
		$table = $db->prefix . "_group_poll";
		
		$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $db->Execute($query);
			
		if (isset($result)) {
			$poll_id = $db->Insert_ID();
		}
	}
	
	if (isset($poll_id)) {
		// we delete and insert options
		$query = "
			DELETE FROM " . $db->prefix . "_group_poll_option 
			WHERE 
			poll_id=" . $poll_id
		;
		
		$result = $db->Execute($query);
		
		// insert options
		if (!empty($_POST['poll_options'])) {
				
			$table = $db->prefix . "_group_poll_option";
			
			foreach($_POST['poll_options'] as $key => $i):
				if (!is_numeric($i['order'])) {				
					$i['order'] = 0;
				}
				
				$rec = array();
				$rec['poll_id']	= $poll_id;
				$rec['option_body']	= strip_tags($i['body']);
				$rec['option_order']	= $i['order'];
				
				if (!empty($rec['option_body'])) {
					$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
					$result = $db->Execute($query);
				}
			endforeach;
		}
	}
	
	if (isset($_POST['update_poll'])) {
		header("Location: index.php?amn=grp_poll_edit&group_id=" . $output_group['group_id'] . "&poll_id=" . $poll_id . "&" . strip_tags(SID));
		exit;
	}
	else {
		header("Location: index.php?amn=grp_poll_list&group_id=" . $output_group['group_id'] . "&" . strip_tags(SID));
		exit;
	}
}

if (!empty($_REQUEST['poll_id'])) {
	$output_poll = $group->selPoll($_REQUEST['poll_id']);
}

if (!empty($output_poll['poll_id'])) {
	// we add one record to the options
	$output_poll['options'][] = "";
}
else {
	// we add 3 empty options for display
	$output_poll['options'][] = "";
	$output_poll['options'][] = "";
	$output_poll['options'][] = "";
}
	
$body->set('poll', $output_poll);

// get recent subjects
$group->user_id = $_SESSION['user_id'];
$output_subjects = $group->selSubjects();

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

?>
