<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "library";

include_once ("config/lbr.config.php");
include_once ("inc/lbr_initiate.inc.php");		

						
if (!empty($_POST['send_invite'])) {
	//create URL
	$url = "http://" . $_SERVER['HTTP_HOST'];
	$url .= dirname ($_SERVER['PHP_SELF']);
	//sometimes the server adds / as the last character - we need to check.
	if (substr($url, -1, 1) != "/") {
		$url .= "/";
	}
	
	if (!empty($_POST['identity_id']) && $_POST['identity_id'] > 0) {
		// we insert into the participate table with a status of "invite"
		$output_identity = $user->selUserIdentity(null, $_POST['identity_id']);
		
		if (!empty($output_identity)) {
			$data['user_id'] = $output_identity['user_id'];
			$data['status_id'] = $library_config['user']['status']['invite'];
			$data['identity_id'] = $output_identity['identity_id'];
			$data['invitee_user_id'] = $_SESSION['user_id'];
			$data['participation_permission'] = $output_set['default_user_permission'];
			
			$participation->module_id = $core_config['module_id']['library'];
			$participation->item_id = $output_set['set_id'];
			$participation->insertParticipant($data);
			
			// append url to message (wiki formatted)
			$data['message_body'] = $_POST['message_body'] . "\n\n<a href=\"" . $url . "index.php?amn=lbr_participation&set_id=" . $output_set['set_id'] . " \">" . $lang['txt_join'] . "</a>"; 
			
			// we send them a message	
			$data['from_identity_id'] = $output_participation['identity_id'];
			$data['to_identity_id'] = $output_identity['identity_id'];
			$data['message_subject'] = $_POST['message_subject'];
			
			$im->sendMessage($data);
			
			header("Location: index.php?amn=lbr_page&set_id=" .  $output_set['set_id'] . "&" . strip_tags(SID));
			exit;
		}
	}
	elseif (isset($_POST['to_email'])) {
		// get from email address
		$from_user = $user->selUser($_SESSION['user_id']);
		
		//setup email
		require_once('components/core/class/Mail/class.phpmailer.php');
		$mail = new PHPMailer($core_config['mail']);
		
		if (!empty($from_user['user_email'])) {
			//$mail->AddReplyTo($from_user['user_email'], $_POST['message_subject']);
			$mail->From = $from_user['user_email'];
			$mail->FromName = $from_user['user_firstname'];
		}
		else {
			$mail->AddReplyTo($core_config['mail']['no_reply_address'], $lang['subject_noreply']);
		}
		
		$mail->Subject = $_POST['message_subject'];
		
		if (empty($_POST['to_email'])) {
			$GLOBALS['am_error_log'][] = array('error_no_email');
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			// check email
			$to_email = trim($_POST['to_email']);
			
			if(!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $to_email)) {
				$GLOBALS['am_error_log'][] = array('error_email_invalid');
			}
			else {
				// we check if they are not in the database already
				$query = "
					SELECT DISTINCT user_id 
					FROM " . $db->prefix . "_user  
					WHERE 
					user_email=" . $db->qstr($to_email, get_magic_quotes_gpc())
				;
				
				$result = $db->Execute($query);
				
				if(isset($result->fields) && isset($result->fields['user_id'])) {
				
					// we check that they are not me
					if($result->fields['user_id'] == $_SESSION['user_id']) {
						$GLOBALS['am_error_log'][] = array('error_email_is_me'); //i've invited myself
					}
					
					if (empty($GLOBALS['am_error_log'])) {
						// we send them a message
						$user->identity_type = $core_config['user']['identity']['type']['registered'];
						$output_identity = $user->selUserIdentity($result->fields['user_id']);
						
						if (!empty($output_identity)) {
							$data['user_id'] = $output_identity['user_id'];
							$data['status_id'] = $library_config['user']['status']['invite'];
							$data['identity_id'] = $output_identity['identity_id'];
							$data['invitee_user_id'] = $_SESSION['user_id'];
							$data['participation_permission'] = $output_set['default_user_permission'];
							
							$participation->module_id = $core_config['module_id']['library'];
							$participation->item_id = $output_set['set_id'];
							$participation->insertParticipant($data);
							
							// append url to message (wiki formatted)
							$data['message_body'] = $_POST['message_body'] . "<a href=\"" . $url . "index.php?amn=lbr_participation&set_id=" . $output_set['set_id'] . " \">" .$lang['txt_join'] . "</a>"; 
							
							// we send them a message	
							$data['from_identity_id'] = $output_participation['identity_id'];
							$data['to_identity_id'] = $output_identity['identity_id'];
							$data['message_subject'] = $_POST['message_subject'];
							
							$im->sendMessage($data);
							
							header("Location: index.php?amn=lbr_page&set_id=" .  $output_set['set_id'] . "&" . strip_tags(SID));
							exit;
						}
					}
				}
				else { // we send the email
					// insert into invite table
					$rec = array();					
					$rec['invited_email'] = $to_email;
					$rec['user_id'] = $_SESSION['user_id'];
					$rec['module_id'] = $core_config['module_id']['library'];
					$rec['item_id'] = $output_set['set_id'];
					$rec['invite_create_datetime'] = time();
					$rec['identity_id'] = $output_participation['identity_id'];
					$rec['invite_url'] = "lbr_participation&set_id=" . $output_set['set_id'];
					$rec['default_status_id'] = $library_config['user']['status']['invite'];
					$rec['default_participation_permission'] = $output_set['default_user_permission'];
					
					$table = $db->prefix . "_user_invite";
				
					$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
					$result = $db->Execute($query);
					
					
							
					$url .= "index.php?amn=core_register&mod=" . $core_config['module_id']['library'] . "&invitee=" . $_SESSION['user_id'] . "&email=" . htmlspecialchars($to_email) . "&language_id=" . $_SESSION['language_id'];
					
					$url_html = "<a href=\"" . $url . "\">" . $url . "</a>";
					
					$message_body_email_html = $_POST['message_body'] . "\n\n" .$url_html;
					$message_body_email = $_POST['message_body'] . "\n\n" .$url;
					
					//send email to email address
					$mail->Subject = $_POST['message_subject'];
							
					// HTML-version of the mail
					$html  = "<HTML><HEAD><TITLE></TITLE></HEAD>";
					$html .= "<BODY>";
					$html .= utf8_decode($message_body_email_html);
					$html .= "</BODY></HTML>";
					
					$alt_body = strip_tags($message_body_email);
					
					//send email
					$mail->Body = nl2br($html);
					$mail->AltBody = utf8_decode($alt_body);
					
					$mail->ClearAddresses();
					$mail->AddAddress($to_email, '');
					
					if(!$mail->Send()) {
						$GLOBALS['am_error_log'][] = array('mail_error', $mail->ErrorInfo);
					}
				
				}
			}
		}
	}
}




// select portable relations not in this item
$query = "
	SELECT * 
	FROM " . $db->prefix . "_relation  
	WHERE 
	relation_portable=1 AND 
	user_id=" . $_SESSION['user_id']
;
		
$result = $db->Execute($query);

if (isset($result->fields)) {
	while(!$result->EOF) {
		$user->identity_ids[] = $result->fields['identity_id_relation'];
		
		$result->moveNext();
	}
	$result->Close();
	
	if (!empty($user->identity_ids)) {
		$output_identities = $user->selUserIdentities();
		$body->set("portable_relations", $output_identities);
	}
}

// update texts files
$lang['txt_invite'] = str_replace("SYS_KEYWORD_SET_TITLE", $output_set['set_title'], $lang['txt_invite']);
$lang['txt_invite_message'] = str_replace("SYS_KEYWORD_SET_SYNOPSIS", $output_set['set_synopsis'], $lang['txt_invite_message']);


// get pending email invites
$query = "
	SELECT invited_email, module_id, item_id 
	FROM " . $db->prefix . "_user_invite  
	WHERE 
	module_id=" . $core_config['module_id']['library'] . " AND 
	user_id=" . $_SESSION['user_id'];
;
		
$result = $db->Execute($query);

if (isset($result->fields)) {
	while(!$result->EOF) {
		$invite_emails[] = $result->fields;
		
		$result->moveNext();
	}
	
	if (!empty($invite_emails)) {
		$body->set("invite_emails", $invite_emails);
	}
}


// get invited participants				
$query = "
	SELECT identity_id, module_id, item_id 
	FROM " . $db->prefix . "_participation   
	WHERE 
	invitee_user_id=" . $_SESSION['user_id'] . " AND 
	status_id=" . $library_config['user']['status']['invite'];
;
		
$result = $db->Execute($query);

if (isset($result->fields)) {
	while(!$result->EOF) {
		$invite_identities[] = $result->fields;
		
		$result->moveNext();
	}
	
	if (!empty($invite_identities)) {
		foreach ($invite_identities as $key => $i):
			$user->identity_ids[] = $i['identity_id'];
		endforeach;
		
		$output_identities = $user->selUserIdentities();
		
		// we place the identities against the invites
		if (!empty($output_identities)) {
			foreach ($invite_identities as $keyp => $p):
				foreach ($output_identities as $keyi => $i):
					if ($p['identity_id'] == $i['identity_id']) {
						$invite_identities[$keyp]['identity'] = $i;
						break;
					}
				endforeach;
			endforeach;
		}
	
		$body->set("invite_identities", $invite_identities);
	}
}

?>