<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_sn.inc.php";
require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');
require_once($c_node['dir']['class_path'] . 'Poll.class.php');
require_once($c_node['dir']['class_path'] . 'Forum.class.php');
require_once($c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['class_path'] . 'Activity.class.php');
require_once($c_node['dir']['class_path'] . 'Blog.class.php');


//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');


//setup bookmark items
$bookmark = new Bookmark($db, null, $date, $user_id);


//get recommended item ids
$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
$bookmark->cms_item_type_id = $c_node['cms']['item_type']['group_blog'];
if (isset($_POST['rec_blog_delete_id']) && $_POST['rec_blog_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['rec_blog_delete_id']);
}
$recommended_blog_ids = $bookmark->getBookmarks();
$bookmark->cms_item_type_id = $c_node['cms']['item_type']['group_activity'];
if (isset($_POST['rec_activity_delete_id']) && $_POST['rec_activity_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['rec_activity_delete_id']);
}
$recommended_activity_ids = $bookmark->getBookmarks();
$bookmark->cms_item_type_id = $c_node['cms']['item_type']['group_library'];
if (isset($_POST['rec_library_delete_name']) && $_POST['rec_library_delete_name'] > 0) {
	$bookmark->deleteBookmark($_POST['rec_library_delete_name']);
}
$recommended_group_library_ids = $bookmark->getBookmarks();
$bookmark->cms_item_type_id = $c_node['cms']['item_type']['group_forum_subject'];
if (isset($_POST['rec_subject_delete_id']) && $_POST['rec_subject_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['rec_subject_delete_id']);
}
$recommended_subject_ids = $bookmark->getBookmarks();
$bookmark->cms_item_type_id = $c_node['cms']['item_type']['group_poll'];
if (isset($_POST['rec_poll_delete_id']) && $_POST['rec_poll_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['rec_poll_delete_id']);
}
$recommended_poll_ids = $bookmark->getBookmarks();

//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


//setup forum
$forum = new Forum($db, $c_acs['arr_section']['group'], $date, $file);
$forum->include_hidden = 1;



//setup blog
$blog = new Blog($db, $c_acs['arr_section']['group'], $date, $file);
$blog->section_item_id = $user_id;

//library setup
$library = new Library($db, $c_acs['arr_section']['group'], $date, $file);
$library->section_item_id = $user_id;


//event setup
$activity = new Activity($db, $c_acs['arr_section']['group'], $date, $file);
$activity->section_item_id = $user_id;


// poll setup
$poll = new Poll($db, $c_acs['arr_section']['group'], $date);
$poll->section_item_id = $user_id;


//get recommended user blogs
if (!empty($recommended_blog_ids)) {
	$blog->blog_ids = $recommended_blog_ids;
	$output_recommended_blogs = $blog->getBlogs();
}
//get recommended subjects
if (!empty($recommended_subject_ids)) {
	$forum->subject_ids = $recommended_subject_ids;
	$output_recommended_subjects = $forum->getSubjects();
}
//get recommended group library items
if (!empty($recommended_group_library_ids)) {
	$library->module = "group";
	$library->library_item_ids = $recommended_group_library_ids;
	$output_recommended_group_library_items = $library->getLibraryItems();
}
//get recommended events
if (!empty($recommended_activity_ids)) {
	$activity->activity_ids = $recommended_activity_ids;
	$output_recommended_activities = $activity->getActivities();
}
//get recommended polls
if (!empty($recommended_poll_ids)) {
	$poll->poll_ids = $recommended_poll_ids;
	$output_recommended_polls = $poll->getPolls();
}


//move to template
if (isset($output_recommended_subjects)) {
	$body->set('recommended_subjects', $output_recommended_subjects);
}

if (isset($output_recommended_group_library_items)) {
	$body->set('recommended_group_library', $output_recommended_group_library_items);
}

if (isset($output_recommended_activities)) {
	$body->set('recommended_activities', $output_recommended_activities);
}

if (isset($output_recommended_blogs)) {
	$body->set('recommended_blogs', $output_recommended_blogs);
}

if (isset($output_recommended_polls)) {
	$body->set('recommended_polls', $output_recommended_polls);
}

if (!empty($output_profile)) {
   $body->set('profile', $output_profile);
}

if (!empty($output_relationship)) {
    $body->set('relationship', $output_relationship);
}

$template_pageLink =  $lang['txt_recommended'];
$template_pageLinkNote = $lang['txt_recommended'] . ": " . $output_profile['profile_nic'];

include "inc/footer.inc.php";

?>
