<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Library {

	var $library_id, $user_id, $query, $result, $temp, $db, $image, $type;

	function Library () {

	}


	/*
	* getPages
	* used to list the page_names held in this library
	* tom calthrop
	* 18th May 2004
	*/
	function getPages () {
		if ($this->type == "group") {
		    $query = "
				SELECT DISTINCT library_page_name
				FROM " . $this->db->prefix . "_group_library
				where
				group_id=" . $this->group_id . "
				order by library_page_name"
			;
		}
		else { //this->type==user
		    $query = "
				SELECT DISTINCT library_page_name
				FROM " . $this->db->prefix . "_user_library
				where
				library_publish<=" . $this->library_publish . " and
				user_id=" . $this->user_id . "
				order by library_page_name"
			;
		}

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields['library_page_name'];
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}//EO getPages();



	/*
	* getPageName
	* will get the newest page for $library_page_name
	* tom calthrop
	* 18th May 2004
	*/
	function getPageName ($library_page_name) {
		if ($this->type == "group") {
			$query = "
				SELECT *
				FROM " . $this->db->prefix . "_group_library
				where
				group_id=" . $this->group_id . " and
				library_page_name='" . $library_page_name . "'
				order by library_create_datetime desc limit 1"
			;
		}
		else { //this->type==user
			$query = "
				SELECT *
				FROM " . $this->db->prefix . "_user_library
				where
				user_id=" . $this->user_id . " and
				library_page_name='" . $library_page_name . "'
				order by library_create_datetime desc limit 1"
			;
		}


		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {

			$result->Close();
			$temp = $result->fields;
			return $temp;
		}

	}//EO getPageName();


	/*
	* getPageID
	* will get the newest page for $library_page_name
	* tom calthrop
	* 18th May 2004
	*/
	function getPageID ($library_id) {
		if ($this->type == "group") {
			$query = "
				SELECT *
				FROM " . $this->db->prefix . "_group_library
				where
				library_id=" . $library_id
			;
		}
		else { //this->type==user
			$query = "
				SELECT *
				FROM " . $this->db->prefix . "_user_library
				where
				library_id=" . $library_id
			;
		}

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {

			$result->Close();
			$temp = $result->fields;
			return $temp;
		}

	}//EO getPageID();



	/*
	* getPageDefault
	* will get the default page for the library
	* tom calthrop
	* 18th May 2004
	*/
	function getPageDefault () {
		if ($this->type == "group") {
			$query = "
				SELECT *
				FROM " . $this->db->prefix . "_group_library
				where
				group_id=" . $this->group_id . " and
				library_default > 0
				order by library_create_datetime limit 1"
			;
		}
		else { //this->type==user
			$query = "
				SELECT *
				FROM " . $this->db->prefix . "_user_library
				where
				user_id=" . $this->user_id . " and
				library_publish<=" . $this->library_publish . " and
				library_default > 0
				order by library_create_datetime limit 1"
			;
		}
		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {

			$result->Close();
			$temp = $result->fields;
			return $temp;
		}

	}//EO getPageDefault();




	/*
	* getHistory
	* used to list the pages in the library item history
	* tom calthrop
	* 18th May 2004
	*/
	function getHistory ($history_library_id) {

		//we retrieve the pagename
		$temp = $this->getPageID($history_library_id);
		$pagename = $temp['library_page_name'];

		if (isset($pagename)) {
			if ($this->type == "group") {
				$query = "
					SELECT l.library_id, l.library_title, l.library_create_datetime, l.user_id,
					u.user_nic
					FROM " . $this->db->prefix . "_group_library l
					RIGHT JOIN " . $this->db->prefix . "_user u ON l.user_id=u.user_id
					where
					l.group_id=" . $this->group_id . " and
					l.library_page_name='" . $pagename . "'
					order by l.library_create_datetime desc"
				;
			}
			else { //this->type==user
				$query = "
					SELECT l.library_id, l.library_title, l.library_create_datetime
					FROM " . $this->db->prefix . "_user_library l
					where
					l.user_id=" . $this->user_id . " and
					l.library_page_name='" . $pagename . "'
					order by l.library_create_datetime desc"
				;
			}

			$result = $this->db->Execute($query);

			if (!$result) {
				$state[]  = array('error', 1, $this->db->ErrorMsg());
			}
			else {
				$temp = array();

				while (!$result->EOF) {
					$temp1 = $result->fields;
					$temp1['display_library_create_datetime'] = $this->date->formatDate($temp1['library_create_datetime'], 1);
					array_push($temp, $temp1);
					$result->MoveNext();
				}

				$result->Close();
				return $temp;
			}
		}
	}//EO getHistory();



	/*
	* getContents
	* used to list the library contents
	* tom calthrop
	* 18th May 2004
	*/
	function getContents () {
		//first we need to get the newest library_page_name id for each library_page_name
		if ($this->type == "group") {
			$query = "
				SELECT library_page_name, library_id, library_create_datetime
				FROM " . $this->db->prefix . "_group_library
				where
				group_id=" . $this->group_id . "
				order by library_page_name, library_create_datetime desc"
			;
		}
		else { //this->type==user
			$query = "
				SELECT library_page_name, library_id, library_create_datetime
				FROM " . $this->db->prefix . "_user_library
				where
				library_publish<=" . $this->library_publish . " and
				user_id=" . $this->user_id . "
				order by library_page_name, library_create_datetime desc"
			;
		}

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$ids = 0;
			$old_library_page_name = "";

			while (!$result->EOF) {

				if ($old_library_page_name <> $result->fields['library_page_name']) {
				    $ids .= "," . $result->fields['library_id'];
					$old_library_page_name = $result->fields['library_page_name'];
				}
				$result->MoveNext();
			}
			$result->Close();
		}

		//now we get the contents for the selected ids
		if ($this->type == "group") {
			$query = "
				SELECT l.library_id, l.library_title, l.library_create_datetime, l.user_id,
				u.user_nic, l.library_default, l.library_synopsis, l.level_id,
				l.library_default, l.library_total_views
				FROM " . $this->db->prefix . "_group_library l
				RIGHT JOIN " . $this->db->prefix . "_user u ON l.user_id=u.user_id
				where
				l.library_id in (" . $ids . ")
				order by l.library_default, l.library_title"
			;
		}
		else { //this->type==user
			$query = "
				SELECT l.library_id, l.library_title, l.library_create_datetime,
				l.library_default, l.library_synopsis, l.library_publish,
				l.library_default, l.library_total_views
				FROM " . $this->db->prefix . "_user_library l
				where
				l.library_id in (" . $ids . ")
				order by l.library_default, l.library_title"
			;
		}

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				$temp1['display_library_create_datetime'] = $this->date->formatDate($temp1['library_create_datetime'], 1);

				if (empty($temp1['library_total_views'])) {
				    $temp1['library_total_views'] = "0";
				}

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}//EO getContents();




	/*
	* searchLibrary
	* This function is only used for group libraries (no user library search query required)
	* tom calthrop
	* 18th May 2004
	*/
	function searchLibrary ($search) {

		$query = "
			SELECT l.library_title, l.library_id, l.library_synopsis, l.library_create_datetime,
			l.user_id, u.user_nic
			FROM " . $this->db->prefix . "_group_library l
			RIGHT JOIN " . $this->db->prefix . "_user u ON l.user_id=u.user_id
			where
			(
			l.library_title like '%" . $search . "%' or
			l.library_synopsis like '%" . $search . "%' or
			l.library_body like '%" . $search . "%'
			) and
			l.group_id=" . $this->group_id . "
			order by l.library_page_name, l.library_create_datetime desc, l.library_title"
		;

		//echo $query . "<br><br>";
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				if (isset($temp1['library_image_id'])) {
					$temp1['image'] = $this->image->getImage($temp1['library_image_id']);
				}

				//format search results
				$temp1['library_synopsis'] = searchTextFormat($search, $temp1['library_synopsis']);
				$temp1['library_title'] = searchTextFormat($search, $temp1['library_title']);

				$temp1['display_library_create_datetime'] = $this->date->formatDate($temp1['library_create_datetime'], 1);

				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	} //EO searchLibrary();




	/*
	* insertLibrary
	* tom calthrop
	* 18th May 2004
	*/
	function insertLibrary ($data) {

		if(empty($data['library_title'])) {
			$state[] =  array('error', 11);
		}

		if(empty($data['library_body'])) {
			$state[] =  array('error', 12);
		}

		if(empty($data['library_synopsis'])) {
			$state[] =  array('error', 13);
		}

		if (!isset($state)) {

			$datetime = date("Y-m-d H:i:s");
			$datetime = $this->db->DBDate($datetime);

			if (!isset($data['forum_subject_id']) || $data['forum_subject_id'] < 1) {
			    $data['forum_subject_id'] = "null";
			}

			if (!isset($data['library_image_id']) || $data['library_image_id'] < 1) {
			    $data['library_image_id'] = "null";
			}

			if (!isset($data['level_id']) || $data['level_id'] < 1) {
			    $data['level_id'] = "null";
			}

			if (!isset($data['library_publish']) || $data['library_publish'] < 1) {
			    $data['library_publish'] = "null";
			}

			if (isset($data['library_default']) && $data['library_default'] > 0) {
			    //we clear out all old default pages
				if ($this->type == "group") {
					$query = "
						UPDATE " . $this->db->prefix . "_group_library SET
						library_default = null
						WHERE
						group_id=" . $this->group_id
					;
				}
				else { //this->type==user
					$query = "
						UPDATE " . $this->db->prefix . "_user_library SET
						library_default = null
						WHERE
						user_id=" . $this->user_id
					;
				}

				$result = $this->db->Execute($query);

			}
			else {
				$data['library_default'] = "null";
			}


			//stops sql errors when backslashes are removed - \"
			$data['library_title'] = str_replace("'", "\'", $data['library_title']);
			$data['library_synopsis'] = str_replace("'", "\'", $data['library_synopsis']);
			$data['library_body'] = str_replace("'", "\'", $data['library_body']);

			if ($this->type == "group") {
				$query = "
					INSERT INTO " . $this->db->prefix . "_group_library (
					library_title, library_synopsis, library_body, forum_subject_id, library_image_id,
					level_id, library_page_name, user_id, group_id, library_create_datetime, library_default
					) VALUES (
					'" . $data['library_title'] . "',
					'" . $data['library_synopsis'] . "',
					'" . $data['library_body'] . "',
					" . $data['forum_subject_id'] . ",
					" . $data['library_image_id'] . ",
					" . $data['level_id'] . ",
					'" . $data['library_page_name'] . "',
					" . $this->user_id . ",
					" . $this->group_id . ",
					" . $datetime . ",
					" . $data['library_default'] . "
					)"
				;
			}
			else { //this->type==user
				$query = "
					INSERT INTO " . $this->db->prefix . "_user_library (
					library_title, library_synopsis, library_body, library_image_id, library_publish,
					library_page_name, user_id, library_create_datetime, language_id, library_default
					) VALUES (
					'" . $data['library_title'] . "',
					'" . $data['library_synopsis'] . "',
					'" . $data['library_body'] . "',
					" . $data['library_image_id'] . ",
					" . $data['library_publish'] . ",
					'" . $data['library_page_name'] . "',
					" . $this->user_id . ",
					" . $datetime . ", 
					" . $data['language_id'] . ", 
					" . $data['library_default'] . "
					)"
				;
				//echo $query;
			}

			$result = $this->db->Execute($query);


			if (!$result) {
				$state[] =  array('error', 1, $this->db->ErrorMsg());
			}

			if (!isset($state)) {
			    $state[]  = array('success', 3);
			}
		}

		return $state;

	} //EO insertLibrary();
	
	
	/*
	* updateBookmark
	* bookmark this item or recommend this item (GROUP LIBRARY ONLY)
	* Tom Calthrop 23rd Nov 2004
	*/
	function updateBookmark($bookmark_type) {
	
		if ($bookmark_type == "watch") {
		    $query = "
				INSERT INTO " . $this->db->prefix . "_group_library_bookmark 
				(user_id, library_page_name, group_id, node_id, bookmark_type) VALUES (
				" . $this->user_id . ", 
				'" . $this->library_page_name . "', 
				" . $this->group_id . ",  
				" . $this->node_id . ", 
				1)"
			;
		}
		elseif ($bookmark_type == "recommend") {
		    $query = "
				INSERT INTO " . $this->db->prefix . "_group_library_bookmark 
				(user_id, library_page_name, group_id, node_id, bookmark_type) VALUES (
				" . $this->user_id . ", 
				'" . $this->library_page_name . "', 
				" . $this->group_id . ", 
				" . $this->node_id . ", 
				2)"
			;
		}
		elseif ($bookmark_type == "unwatch") {
		    $query = "
				DELETE FROM " . $this->db->prefix . "_group_library_bookmark 
				WHERE 
				user_id=" . $this->user_id . " and 
				library_page_name='" . $this->library_page_name . "' and 
				group_id=" . $this->group_id . " and 
				node_id=" . $this->node_id . " and 
				bookmark_type=1"
			;
		}
		elseif ($bookmark_type == "unrecommend") {
		    $query = "
				DELETE FROM " . $this->db->prefix . "_group_library_bookmark 
				WHERE 
				user_id=" . $this->user_id . " and 
				library_page_name='" . $this->library_page_name . "' and 
				group_id=" . $this->group_id . " and 
				node_id=" . $this->node_id . " and 
				bookmark_type=2"
			;
		}
		
		$result = $this->db->Execute($query);
			
		if (isset($result->fields)) {
			$result->Close();
		}
	} //EO updateBookmark();
	
	
	/*
	* GET BOOKMARKS
	* Tom Calthrop 23rd Nov 2004
	*/
	function getBookmarks () {
	
		$query = "
			SELECT bookmark_type  
			FROM " . $this->db->prefix . "_group_library_bookmark 
			WHERE
			library_page_name='" . $this->library_page_name . "' and
			user_id=" . $this->user_id . " and 
			group_id=" . $this->group_id . " and 
			node_id=" . $this->node_id
		;
		
		$result = $this->db->Execute($query);
			
		if (isset($result->fields)) {
			while (!$result->EOF) {
				if ($result->fields['bookmark_type'] == 1) {
				    $temp['watch'] = 1;
				}
				
				if ($result->fields['bookmark_type'] == 2) {
				    $temp['recommend'] = 1;
				}

				$result->MoveNext();
			}
		
			$result->Close();
			
			if (isset($temp)) {
			    return $temp;
			}
			
		}
	} //EO getBookmarks();
	
}
?>
