<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "event";
include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'Event/Event.class.php');


//append language setup
require_once($languageArrayPath . 'arr_event_type.lang.php');
require_once($languageArrayPath . 'arr_level.php');
require_once($languageArrayPath . 'arr_event_publish.lang.php');
require_once($languageArrayPath . 'arr_activity_user_status.lang.php');


//event
$event->thumb = 't1';


if (isset($_REQUEST['withdraw_confirmation'])) {
	$set_activity_user = $event->updateActivityUserStatus($_REQUEST['activity_user_id'], $me['user_id'], $c_node['activity_user_status']['withdrawn']);
}
elseif (isset($_REQUEST['activity_apply_update'])) {
	$set_activity_user = $event->updateActivityUserStatus($_REQUEST['activity_user_id'], $me['user_id'], $c_node['activity_user_status']['pending']);
}
elseif (isset($_REQUEST['activity_apply'])) {
	$set_activity_user = $event->insertActivityUserStatus($_REQUEST['activity_id'], $me['user_id'], $c_node['activity_user_status']['pending']);
}

$output_event = $event->getEvent();

if (isset($output_event['forum_subject_id'])) {
	$output_subject = getSubject($output_event['forum_subject_id']);
}

$output_activities = $event->getActivities();

if (isset($activity_id)) {
	$output_activity = $event->getActivity($activity_id);
	$output_activity['status'] = $event->getUserActivity($activity_id, $me['user_id']);
}



//update bookmarks
if (isset($_REQUEST['watch'])) {
	$event->updateBookmark('watch');
}
elseif (isset($_REQUEST['recommend'])) {
	$event->updateBookmark('recommend');
}
elseif (isset($_REQUEST['unwatch'])) {
	$event->updateBookmark('unwatch');
}
elseif (isset($_REQUEST['unrecommend'])) {
	$event->updateBookmark('unrecommend');
}

//movement
$output_event['bookmarks'] = $event->getBookmarks();



//move to template
if (isset($watching)) {
	$body->set('watching', $watching);
}

if (isset($recommended)) {
	$body->set('recommended', $recommended);
}

if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($output_event)) {
	$body->set('event', $output_event);
}

if (isset($output_activities)) {
	$body->set('activities', $output_activities);
}

if (isset($output_activity)) {
	$body->set('activity', $output_activity);
}

if (isset($c_node['activity_user_status'])) {
	$body->set('activity_status_ids', $c_node['activity_user_status']);
}

if (isset($output_subject)) {
	$body->set('subject', $output_subject);
}


if (isset($output_event['event_title'])) {
	$template_pageLink = $lang['txt_event'];
	$template_pageLinkNote = $output_event['event_title'];
}


include "inc/footer.inc.php";


/*
* addWatch
* bookmark this item or recommend this item
* Tom Calthrop 12th April 2004
*/
function addWatch ($event_id, $type) {

	global $db, $me, $log;

	$query = "
		INSERT INTO " . $db->prefix . "_event_bookmark (
		event_id, user_id, node_id, bookmark_type
		) values (
		" . $event_id . ",
		" . $me['user_id'] . ",
		" . $me['node_id'] . ",
		" . $type . "
		)"
	;
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {

		return 1;
	}
} //EO addWatch();


/*
* removeWatch
* remove bookmark for this item
* Tom Calthrop 12th April 2004
*/
function removeWatch ($event_id, $type) {

	global $db, $me, $log;

	$query = "
		DELETE FROM " . $db->prefix . "_event_bookmark
		WHERE
		event_id=" . $event_id . " and
		user_id=" . $me['user_id'] . " and
		node_id=" . $me['node_id'] . " and
		bookmark_type=" . $type
	;
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
} //EO removeWatch();


/*
* getWatch
* check to see if item is bookmarked or recommended
* Tom Calthrop 12th April 2004
*/
function getWatch ($event_id, $type) {

	global $db, $me, $log;

	$query = "
		SELECT * FROM " . $db->prefix . "_event_bookmark
		WHERE
		event_id=" . $event_id . " and
		user_id=" . $me['user_id'] . " and
		node_id=" . $me['node_id'] . " and
		bookmark_type=" . $type . "
		order by user_id limit 1"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {

		if ($result->fields['user_id']) {
		    return 1;
		}
	}
} //EO getWatch();



/*
* getSubject
* tom calthrop
* 15th May 2004
*/
function getSubject ($subject_id) {

	global $db, $log;

	$query = "
		SELECT s.subject_title, s.subject_id, s.topic_id
		FROM " . $db->prefix . "_forum_subject s
		where
		s.subject_id=" . $subject_id
	;

	//echo $query;

	$result = $db->Execute($query);

	if (!$result) {
		$state[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {

		$temp = $result->fields;
		$result->Close();
		return $temp;
	}
}//EO getSubject();
?>
