<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "group";
include "inc/header.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_user_online_status.lang.php');
require_once($languageArrayPath . 'arr_group_member_statistics.lang.php');
require_once($languageArrayPath . 'arr_user_priv.lang.php');


if (isset($_REQUEST['user_id'])) {
	$user_id = $_REQUEST['user_id'];
}
else {
	$user_id = $me['user_id'];
}


//group member details
$output_member = memberDetails($user_id, $group_id);

if (isset($_POST['delete_membership_confirm'])) {
	$delete = deleteMembership($group_id);
	header("Location: g_groups.php?my_groups=1&amp;".SID);
	exit;


}
elseif (isset($output_member['user_id'])) {

	if (isset($_POST['delete_membership'])) {
	    $display_confirmation_delete = 1;
	}

	//get Library Items
	$output_library = getLibraryItems($user_id, $group_id);

	//get Forum topics
	$output_topics = getTopics($user_id, $group_id);

	//get Forum subjects
	$output_subjects = getSubjects($user_id, $group_id);

	//get Forum replies
	$output_replies = getReplies($user_id, $group_id);

	//get Statistics
	$output_statistics = groupMemberStatistics($user_id, $group_id);

	//display if this person is blocked
	require_once($c_node['class_dir'] . 'User/Socialnetwork.class.php');
	$sn = new Socialnetwork($me['user_id'], $db, $me['node_id']);

	if ($sn->getBlockStatus($user_id)) {
		$display = "blocked";
	}

}



//move to template
if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($display_confirmation_delete)) {
	$body->set('display_confirmation_delete', $display_confirmation_delete);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($output_member)) {
	$body->set('member', $output_member);
}

if (isset($output_library)) {
	$body->set('library', $output_library);
}

if (isset($output_topics)) {
	$body->set('topics', $output_topics);
}

if (isset($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (isset($output_replies)) {
	$body->set('replies', $output_replies);
}

if (isset($output_statistics)) {
	$body->set('gm_statistics', $output_statistics);
}

if (isset($output_statistic)) {
	$body->set('group_statistic', $output_statistic);
}

if (isset($display)) {
	$body->set('display', $display);
}


if (isset($output_member['user_nic'])) {
	$template_pageLink = $lang['txt_member_profile'];
	$template_pageLinkNote = $output_member['user_nic'];
}

include "inc/footer.inc.php";



/*
* getLibraryItems
* Tom Calthrop 21st April 2004
*/
function getLibraryItems($user_id, $group_id) {

	global $db, $me, $image, $log;

	$query = "
		SELECT l.library_title, l.library_synopsis, l.library_id, l.library_total_views,
		l.group_id, l.library_image_id
		FROM " . $db->prefix . "_group_library l
		where
		l.user_id=" . $user_id . " and
		l.group_id=" . $group_id . "
		order by l.library_create_datetime desc limit 5"
	;

	$result = $db->Execute($query);

	if (!isset($result)) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	elseif (isset($result)) {

		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;

			if ($temp1['library_image_id']) {
			    $temp1['image'] = $image->getImage($temp1['library_image_id'], 't2', 'group');
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getLibraryItems();


/*
* getTopics
* Tom Calthrop 21st April 2004
*/
function getTopics($user_id, $group_id) {

	global $db, $me, $image, $log;

	$query = "
		SELECT t.topic_id, t.topic_title, t.topic_body,
		se.group_id, t.topic_id, t.topic_image_id
		FROM " . $db->prefix . "_forum_topic t
		LEFT JOIN " . $db->prefix . "_forum_section se ON t.section_id=se.section_id
		where
		t.user_id=" . $user_id . " and
		se.group_id=" . $group_id . "
		order by t.topic_create_datetime desc limit 5"
	;

	$result = $db->Execute($query);

	if (!isset($result)) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if (isset($result)) {

		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;

			if ($temp1['topic_image_id']) {
			    $temp1['image'] = $image->getImage($temp1['topic_image_id'], 't2', 'group');
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getTopics();


/*
* getSubjects
* Tom Calthrop 21st April 2004
*/
function getSubjects($user_id, $group_id) {

	global $db, $me, $image, $log;

	$query = "
		SELECT s.subject_id, s.subject_title, s.subject_body,
		se.group_id, t.topic_id, s.subject_image_id
		FROM " . $db->prefix . "_forum_subject s
		LEFT JOIN " . $db->prefix . "_forum_topic t ON s.topic_id=t.topic_id
		LEFT JOIN " . $db->prefix . "_forum_section se ON t.section_id=se.section_id
		where
		s.user_id=" . $user_id . " and
		se.group_id=" . $group_id . "
		order by s.subject_create_datetime desc limit 5"
	;

	$result = $db->Execute($query);

	if (!isset($result)) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if (isset($result)) {

		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;

			if ($temp1['subject_image_id']) {
			    $temp1['image'] = $image->getImage($temp1['subject_image_id'], 't2', 'group');
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getSubjects();


/*
* getReplies
* Tom Calthrop 21st April 2004
*/
function getReplies($user_id, $group_id) {

	global $db, $me, $image, $log;

	$query = "
		SELECT r.subject_id, r.reply_body, r.reply_create_datetime, t.topic_id
		FROM " . $db->prefix . "_forum_reply r
		LEFT JOIN " . $db->prefix . "_forum_subject s ON r.subject_id=s.subject_id
		LEFT JOIN " . $db->prefix . "_forum_topic t ON s.topic_id=t.topic_id
		LEFT JOIN " . $db->prefix . "_forum_section se ON t.section_id=se.section_id
		where
		s.user_id=" . $user_id . " and
		se.group_id=" . $group_id . "
		order by s.subject_create_datetime desc limit 5"
	;

	$result = $db->Execute($query);

	if (!isset($result)) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if (isset($result)) {

		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;
			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getReplies();


/*
* groupStatistics
* Tom Calthrop 21st April 2004
*/
function groupMemberStatistics($user_id, $group_id) {

	global $db, $log;

	$query = "
		SELECT gms.statistic_type_id, gms.total
		FROM " . $db->prefix . "_group_member_statistic gms
		where
		gms.group_id=" . $group_id . " and
		gms.user_id=" . $user_id . "
		order by gms.statistic_type_id"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();
		$output =  $temp;
	}

	return $output;
}//EO groupStatistics();


/*
* memberDetails
* Tom Calthrop 21st April 2004
*/
function memberDetails($user_id, $group_id) {

	global $db, $date, $log, $me;

	$query = "
		SELECT gm.level_id, gm.member_create_datetime, gm.user_id , u.user_nic,
		u.user_summary, u.user_create_datetime, u.user_hometown, u.active_time
		FROM " . $db->prefix . "_group_member gm
		LEFT JOIN " . $db->prefix . "_user u ON gm.user_id=u.user_id
		where
		gm.group_id=" . $group_id . " and
		gm.user_id=" . $user_id
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[] = array('error', 1, $db->ErrorMsg());
	}
	else {

		$temp = $result->fields;

		if (isset($temp['user_id'])) {
		   	$temp['user_create_datetime'] = $date->formatDate($temp['user_create_datetime']);
			$temp['member_create_datetime'] = $date->formatDate($temp['member_create_datetime']);

			if ($me['user_id'] == $temp['user_id']) {
			    $temp['online_status'] = 1;
			}
			else {
				//new instance of User
				$group_user = new User();
				$group_user->user_id = $user_id;
				$group_user->db = $db;

				$temp['online_status'] = $group_user->getStatus($temp['active_time']);
			}

			return $temp;
		}

		$result->Close();
	}
}//EO memberDetails();




/*
* deleteMembership
* Tom Calthrop 1st June 2004
*/
function deleteMembership($group_id) {

	global $db, $log, $me;

	$query = "
		DELETE FROM " . $db->prefix . "_group_member
		where
		group_id=" . $group_id . " and
		user_id=" . $me['user_id']
	;

	$result = $db->Execute($query);

	if (!$result) {
		$state = array('error', 1, $db->ErrorMsg());
	}
	else {
		$state = array('success', 1);
		$result->Close();
	}

	return $state;
}//EO deleteMembership();

?>
