<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "user";
include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'User/Blog.class.php');
require_once($c_node['class_dir'] . 'Wiki/Wiki.php');
require_once($languageArrayPath . 'arr_genre.lang.php');


//append language setup
require_once($languageArrayPath . 'arr_user_online_status.lang.php');
require_once($languageArrayPath . 'arr_user_relation.lang.php');


//get blogs
$blog = new Blog($user_id, $db, $date, $c_node['node_id']);
$blog->limit = 10;


//wiki setup
$wiki =& new Text_Wiki();
$wiki->rulePath = $c_node['class_dir'] . "Wiki/Rule/";
$wiki->setRuleConf('image', 'base', $c_node['base_path'] . "user/" . $user_id . "/");

//stop WIKI style links in the Blog
$wiki->disableRule('wikilink');


//if in social network we show all blogs, else we only blogs published to all
if ((isset($output_relationship) && $output_relationship['type'] > 0)) {
	$blog->blog_publish = $c_node['user_publish']['friends'];
}
else {
	$blog->blog_publish = $c_node['user_publish']['all'];
}


if (isset($_REQUEST['blog_id'])) {
	$blog->blog_id = $_REQUEST['blog_id'];
}


$output_blog = $blog->getBlog();
$output_blogs = $blog->getMyBlogs();

if (isset($output_blog['genre_id'])) {
    $blog->genre_id = $output_blog['genre_id'];
	$output_related_blogs = $blog->getBlogs();
}


//update bookmarks
if (isset($_REQUEST['watch'])) {
	$blog->updateBookmark('watch');
}
elseif (isset($_REQUEST['recommend'])) {
	$blog->updateBookmark('recommend');
}
elseif (isset($_REQUEST['unwatch'])) {
	$blog->updateBookmark('unwatch');
}
elseif (isset($_REQUEST['unrecommend'])) {
	$blog->updateBookmark('unrecommend');
}

//movement
$output_blog['bookmarks'] = $blog->getBookmarks();


//update total view if use is not me
//just set a temporary session to stop people hitting the refresh button to up the total hits score
if (($me['user_id'] != $output_blog['user_id']) && (!isset($_SESSION['tmp']) || $_SESSION['tmp'] != "blog_id_" . $output_blog['blog_id'])) {
	$blog->updateTotalViews($output_blog['blog_total_views']);
	$_SESSION['tmp'] = "blog_id_" . $output_blog['blog_id'];
}


//move vars to template
if (isset($output_blog)) {
	$body->set('blog', $output_blog);
}

if (isset($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (isset($output_related_blogs)) {
	$body->set('related_blogs', $output_related_blogs);
}

if (isset($output_user)) {
	$body->set('user', $output_user);
}

if (isset($output_relationship)) {
	$body->set('relationship', $output_relationship);
}


if (isset($output_blog['blog_title'])) {
    $template_pageLink = $lang['txt_blog'];
	$template_pageLinkNote = $output_blog['blog_title'];
}

include "inc/footer.inc.php";

?>
