<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "inc/header.inc.php";
include $c_node['aroundme_dir'] . "inc/functions.inc.php";
include $c_node['aroundme_dir'] . "config/config_aroundme.inc.php";

//include error handling files from aroundme
$languagePath = $c_node['aroundme_dir'] . "language/" . $language_id . "/" . $c_node['template_default_name'];
$languageArrayPath = $languagePath . "/arrays/";
$languageTextPath = $languagePath . "/texts/";
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_error_success.lang.php');
require_once($languageTextPath . 'message.lang.php');


//database setup and connect
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$db = NewADOConnection('mysql');
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


//Date
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'Date.class.php');
$date = new Date();


//set up user
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'User/User.class.php');
$user = new User();
$user->date = $date;
$user->db= $db;
$user->aroundme_dir = $c_node['aroundme_dir'];
$user->language_dir = $c_node['template_default_name'];
//$user->www_path = $c_node['www_path'];

//form actions
if (isset($_POST['register'])) {
	// Checks the email and the password
	$data = $_POST['data'];

	if (isset($_POST['language_ids'])) {
	    $data['language_ids'] = $_POST['language_ids'];
	}
	
	$register = $user->checkRegister($data);

	// Handles the result if errors found
	if (isset($register) && $register[0][0] == "success") {

		//setup email
		require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . '/Mail/class.phpmailer.php');
		$mail = new PHPMailer();
		$mail->Host = 		$c_node['mail']['host'];
		$mail->Mailer = 	$c_node['mail']['mailer'];
		$mail->From = 		$c_node['mail']['no_reply_address'];
		$mail->FromName = 	$c_node['mail']['from_name'];
		$mail->WordWrap = 	$c_node['mail']['wordwrap'];
		$mail->Subject = 	$lang['subject_welcome_br'];
		$mail->AddReplyTo($c_node['mail']['no_reply_address'], $lang['subject_noreply']);

		$user->mail = $mail;


		if (isset($data['invitee_id'])) {
			$user->invitee_id = $data['invitee_id'];
		}


		$user->template_id = $c_node['template_default_id'];
		$data['user_dob'] = $_REQUEST['year']."-".$_REQUEST['month']."-".$_REQUEST['day'];
		$user->registerUser($data);

		//check if we need to add invitee into social network
		if (isset($data) && $data['invitee_id']) {
			$user->node_id = $c_node['node_id'];
			$relation = $user->insertRelation($data['invitee_id'], $c_node['relation_type']['approved']);
		}

		$display = "registration_complete";
	}
	else {
	    $error = $register;
	}

}


//if someone has invited someone here
if (isset($_REQUEST['invitee']) && $_REQUEST['invitee'] > 0) {

	$invitee = $_REQUEST['invitee'];

	if ($invitee > 0) {
		$_SESSION['s_user_id'] = "x";
	    $output_invite = $user->userDetails($invitee);
		if ($output_invite['user_image_id']) {

			require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'Presentation/Image.class.php');
			$image = new Image();
			$image->db = $db;
			$output_invite['image'] = $image->getImage($output_invite['user_image_id'], 't1', 'user', $output_invite['user_id']);
		}
	}
}


//TEMPLATE
if (isset($c_node['language_available'])) {
    $body->set('language_available', $c_node['language_available']);
}

if (isset($error)) {
    $tpl->set('error', $error);
}
elseif (isset($success)) {
    $body->set('success', $success);
}

if (isset($output_invite)) {
    $body->set('invite', $output_invite);
}

if (isset($display)) {
    $body->set('display', $display);
}

if (isset($data)) {
    $body->set('data', $data);

	$user_dob = $_REQUEST['year']."-".$_REQUEST['month']."-".$_REQUEST['day'];
	$body->set('datedropdown', $date->dateDropdown($user_dob));
}
else {
	$data = array("language_id" => $language_id);

	if (isset($_REQUEST['email'])) {
	    $data['user_email'] = $_REQUEST['email'];
	}

	$body->set('data', $data);

	$body->set('datedropdown', $date->dateDropdown());
}


$body->set('aroundme_dir', $c_node['aroundme_dir']);

$pagename = "register";

include "inc/footer.inc.php";
?>
