<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_blog'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $group_id . "&" . SID);
	exit;
}


require_once($c_node['dir']['class_path'] . 'Blog.class.php');
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');


//append language setup
require_once($languageArrayPath . 'arr_group.lang.php');


if (isset($_REQUEST['blog_id'])) {
	$blog_id = $_REQUEST['blog_id'];
}


//setup blog
$blog = new Blog($db, $c_acs['arr_section']['group'], $date, $file);
$blog->section_item_id = $group_id;
$blog->user_id = $me['user_id'];

//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif


//wiki setup
$wiki =& new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', 'g_library.php?group_id=' . $group_id . '&page=');
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', 'g_library_edit.php?group_id=' . $group_id . '&page=');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'group/');



if (isset($_POST['edit_blog']) || isset($_REQUEST['add_blog'])) {
    $output_images = $file->getFiles();
}


if (isset($data)) {

	$data['blog_body'] = stripslashes($data['blog_body']);
	$data['blog_body_display'] = $wiki->transform($data['blog_body'], 'Xhtml');

	$data['blog_synopsis'] = stripslashes(htmlspecialchars($data['blog_synopsis']));

	$data['blog_title'] = stripslashes(htmlspecialchars($data['blog_title']));

	if (isset($_POST['preview_blog'])) {
		$data['blog_body'] = htmlspecialchars($data['blog_body']);

		$output_blog = $data;

		$display = "preview_blog";
	}
	elseif (isset($_POST['edit_blog_again'])) {
		$output_blog = $data;

		$display = "add_blog";

	}
	elseif (isset($_POST['insert_blog'])) {
		if (!empty($data['cms_public'])) {
			$data['level_id'] = $c_node['cms']['cms_level']['public'];
		}
		elseif (!empty($data['cms_node'])) {
			$data['level_id'] = $c_node['cms']['cms_level']['node'];
		}
		elseif (!empty($data['cms_group'])) {
			$data['level_id'] = $c_node['cms']['cms_level']['group']['home'];
		}
		else {
			$data['level_id'] = null;
		}
		
		$blog->insertBlog($data);

		if (empty($GLOBALS['am_error_log'])) {
			//setup cms
			require_once($c_node['dir']['class_path'] . 'Cms.class.php');
			$cms = new Cms($db, $c_acs['arr_section']['group']);
			$cms->section_item_id = $group_id;
			$cms->cms_item_type_id = $c_node['cms']['item_type']['group_blog'];
			$cms->user_id = $user_id;
			$temp['language_id'] = $output_group['language_id'];
			$temp['genre_id'] = $output_group['genre_id'];
			$temp['item_id'] = $blog->blog_id;
			
			//insert node cms entry
		  	if($c_node['cms']['node']['auto_publish'] == 1) {
				$temp['status_id'] = $c_node['cms']['status']['live'];
			}
			else {
				$temp['status_id'] = $c_node['cms']['status']['pending'];
			}
				
			if (isset($data['cms_node'])) {
				$temp['level_id'] = $c_node['cms']['cms_level']['node'];
				$cms->insertCmsItem($temp);
			}
			
			if (isset($data['cms_public'])) {
				$temp['level_id'] = $c_node['cms']['cms_level']['public'];
				$cms->insertCmsItem($temp);
			}
			
			//insert group cms entry
			if (isset($data['cms_group'])) {
				$temp['level_id'] = $c_node['cms']['cms_level']['group']['home'];
				$cms->insertCmsItem($temp);
			}
			
			//setup statistics
			require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
			$statistic = new Statistic($db, $c_acs['arr_section']['user'], $date);
			
			//update stats
			$statistic->section_item_id = $user_id;
			$statistic->statistic_type_id = $c_node['statistic']['user']['total_blogs'];
			$blog->user_id = $user_id;
			$statistic->setStatistic($blog->getBlogCount());
			
			return header("Location: g_blog.php?group_id=". $group_id . "&blog_id=". $blog->blog_id . "&" . SID);
			exit;
		}
		else {
			$output_blog = $data;

			$display = "add_blog";
		}
	}
}
elseif (isset($_REQUEST['add_blog'])) {

		$display = "add_blog";

}
elseif (isset($blog_id)) {//if we have a blog id we retrieve it
    $blog->blog_id = $blog_id;
	$output_blog = $blog->getBlog();
	$output_blog['blog_body_display'] = $wiki->transform($output_blog['blog_body'], 'Xhtml');

}


//get images
$output_images = $file->getFiles();


//move vars to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_blog)) {
	$body->set('blog', $output_blog);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

$body->set('cms_node_auto_publish', $c_node['cms']['node']['auto_publish']);

include "inc/footer.inc.php";

?>
