<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";


//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['s_homepage'] . "?" . SID);
	exit;
}

unset($status_id); // this is temporary - somehow status_id is set somewhere - bug / tom
if (isset($_REQUEST['status_id']) && $_REQUEST['status_id'] > 0) {
    $status_id = $_REQUEST['status_id'];
	unset($data);
}

require_once($c_node['dir']['class_path'] . 'Cms.class.php');
require_once($c_node['dir']['class_path'] . 'Poll.class.php');
require_once($c_node['dir']['class_path'] . 'Forum.class.php');
require_once($c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['class_path'] . 'Activity.class.php');
require_once($c_node['dir']['class_path'] . 'Blog.class.php');


//append language setup
require_once($languageArrayPath . 'arr_cms.lang.php');


//setup cms
require_once($c_node['dir']['class_path'] . 'Cms.class.php');
$cms = new Cms($db, null);
if (isset($status_id)) {
    $cms->cms_status_id = $status_id;
}

if (isset($_REQUEST['level_id']) && $_REQUEST['level_id'] == $c_node['cms']['cms_level']['public']) {
	$level_id = $c_node['cms']['cms_level']['public'];
	$cms->level_id = $c_node['cms']['cms_level']['public'];
}
else {
	$level_id = $c_node['cms']['cms_level']['node'];
	$cms->level_id = $c_node['cms']['cms_level']['node'];
}


//get subject ids -----------------------------------------------------------
$cms->section_id = $c_acs['arr_section']['group'];
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_forum_subject'];
if (isset($data['subject_status'])) {
	foreach($data['subject_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_subject_delete[] = $key;
		}
		else {
			$cms->item_id = $key;
			
			if (isset($data['subject_sticky'][$key])) {
			    $cms->updateCmsItem($i, 1);
			}
			else {
				$cms->updateCmsItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_subject_delete)) {
	    $cms->deleteCmsItem($arr_subject_delete);
	}
}
$output_cms_subjects = $cms->getCmsItems();
foreach($output_cms_subjects as $key => $i):
	$cms_subject_ids[] = $i['item_id'];
endforeach;

//get group blog ids -----------------------------------------------------
$cms->section_id = $c_acs['arr_section']['group'];
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_blog'];
if (isset($data['blog_group_status'])) {
	foreach($data['blog_group_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_blog_delete[] = $key;
		}
		else {
			$cms->item_id = $key;
			
			if (isset($data['blog_group_sticky'][$key])) {
			    $cms->updateCmsItem($i, 1);
			}
			else {
				$cms->updateCmsItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_blog_delete)) {
	    $cms->deleteCmsItem($arr_blog_delete);
	}
	
}
$output_cms_group_blogs = $cms->getCmsItems();
foreach($output_cms_group_blogs as $key => $i):
	$cms_blog_group_ids[] = $i['item_id'];
endforeach;

//get user blog ids -----------------------------------------------------
$cms->section_id = $c_acs['arr_section']['user'];
$cms->cms_item_type_id = $c_node['cms']['item_type']['user_blog'];
if (isset($data['blog_user_status'])) {
	foreach($data['blog_user_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_blog_delete[] = $key;
		}
		else {
			$cms->item_id = $key;
			
			if (isset($data['blog_user_sticky'][$key])) {
			    $cms->updateCmsItem($i, 1);
			}
			else {
				$cms->updateCmsItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_blog_delete)) {
	    $cms->deleteCmsItem($arr_blog_delete);
	}
	
}
$output_cms_user_blogs = $cms->getCmsItems();
foreach($output_cms_user_blogs as $key => $i):
	$cms_blog_user_ids[] = $i['item_id'];
endforeach;

//get group library item ids --------------------------------------------------
$cms->section_id = $c_acs['arr_section']['group'];
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_library'];
if (isset($data['group_library_item_status'])) {
	foreach($data['group_library_item_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_library_item_delete[] = $key;
		}
		else {
			$cms->item_id = $key;
			
			if (isset($data['group_library_item_sticky'][$key])) {
			    $cms->updateCmsItem($i, 1);
			}
			else {
				$cms->updateCmsItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_library_item_delete)) {
	    $cms->deleteCmsItem($arr_library_item_delete);
	}
	
}
$output_cms_group_library_items = $cms->getCmsItems();
foreach($output_cms_group_library_items as $key => $i):
	$cms_group_library_ids[] = $i['item_id'];
endforeach;
//get user library item ids --------------------------------------------------
$cms->section_id = $c_acs['arr_section']['user'];
$cms->cms_item_type_id = $c_node['cms']['item_type']['user_library'];
if (isset($data['user_library_item_status'])) {
	foreach($data['user_library_item_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_library_item_delete[] = $key;
		}
		else {
			$cms->item_id = $key;
			
			if (isset($data['user_library_item_sticky'][$key])) {
			    $cms->updateCmsItem($i, 1);
			}
			else {
				$cms->updateCmsItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_library_item_delete)) {
	    $cms->deleteCmsItem($arr_library_item_delete);
	}
	
}
$output_cms_user_library_items = $cms->getCmsItems();
foreach($output_cms_user_library_items as $key => $i):
	$cms_user_library_ids[] = $i['item_id'];
endforeach;
//get file ids --------------------------------------------------------
$cms->section_id = $c_acs['arr_section']['group'];
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_files'];
if (isset($data['file_status'])) {
	foreach($data['file_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_file_delete[] = $key;
		}
		else {
			$cms->item_id = $key;
			
			if (isset($data['file_sticky'][$key])) {
			    $cms->updateCmsItem($i, 1);
			}
			else {
				$cms->updateCmsItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_file_delete)) {
	    $cms->deleteCmsItem($arr_file_delete);
	}
}
$output_cms_files = $cms->getCmsItems();
foreach($output_cms_files as $key => $i):
	$cms_file_ids[] = $i['item_id'];
endforeach;

//get poll ids ---------------------------------------------------
$cms->section_id = $c_acs['arr_section']['group'];
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_poll'];
if (isset($data['poll_status'])) {
	foreach($data['poll_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_poll_delete[] = $key;
		}
		else {
			$cms->item_id = $key;
			
			if (isset($data['poll_sticky'][$key])) {
			    $cms->updateCmsItem($i, 1);
			}
			else {
				$cms->updateCmsItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_poll_delete)) {
	    $cms->deleteCmsItem($arr_poll_delete);
	}
}
$output_cms_polls = $cms->getCmsItems();
if (!empty($output_cms_polls)) {
	foreach($output_cms_polls as $key => $i):
		$cms_poll_ids[] = $i['item_id'];
	endforeach;
}

//get activity ids ---------------------------------------------------
$cms->section_id = $c_acs['arr_section']['group'];
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_activity'];
if (isset($data['activity_status'])) {
	foreach($data['activity_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_activity_delete[] = $key;
		}
		else {
			$cms->item_id = $key;
			
			if (isset($data['activity_sticky'][$key])) {
			    $cms->updateCmsItem($i, 1);
			}
			else {
				$cms->updateCmsItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_activity_delete)) {
	    $cms->deleteCmsItem($arr_activity_delete);
	}
}
$output_cms_activities = $cms->getCmsItems();
foreach($output_cms_activities as $key => $i):
	$cms_activity_ids[] = $i['item_id'];
endforeach;
//get task ids ---------------------------------------------------
$cms->section_id = $c_acs['arr_section']['group'];
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_task'];
if (isset($data['task_status'])) {
	foreach($data['task_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_task_delete[] = $key;
		}
		else {
			$cms->item_id = $key;
			
			if (isset($data['task_sticky'][$key])) {
			    $cms->updateCmsItem($i, 1);
			}
			else {
				$cms->updateCmsItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_task_delete)) {
	    $cms->deleteCmsItem($arr_task_delete);
	}
}
$output_cms_tasks = $cms->getCmsItems();
if (!empty($output_cms_tasks)) {
	foreach($output_cms_tasks as $key => $i):
		$cms_task_ids[] = $i['item_id'];
	endforeach;
}


//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


//setup forum
$forum = new Forum($db, $c_acs['arr_section']['group'], $date, $file);


//setup blog
$blog = new Blog($db, null, $date, $file);


//library setup
$library = new Library($db, null, $date, $file);


//activity setup
$activity = new Activity($db, $c_acs['arr_section']['group'], $date, $file);
$activity->task_user_status_ids = $c_node['activity']['task_user_status'];


// poll setup
$poll = new Poll($db, $c_acs['arr_section']['group'], $date);



//get group_blog items
if (!empty($cms_blog_group_ids)) {
	$blog->section_id = $c_acs['arr_section']['group'];
	$blog->blog_ids = $cms_blog_group_ids;
	$output_group_blogs = $blog->getBlogs();
}
//get user_blog items
if (!empty($cms_blog_user_ids)) {
	$blog->section_id = $c_acs['arr_section']['user'];
	$blog->blog_ids = $cms_blog_user_ids;
	$output_user_blogs = $blog->getBlogs();
}
//get subjects
if (!empty($cms_subject_ids)) {
	$forum->subject_ids = $cms_subject_ids;
	$output_subjects = $forum->getSubjects();
}
//get group library items
if (!empty($cms_group_library_ids)) {
	$library->section_id = $c_acs['arr_section']['group'];
	$library->library_item_ids = $cms_group_library_ids;
	$output_group_library_items = $library->getLibraryItems();
}
//get user library items
if (!empty($cms_user_library_ids)) {
	$library->section_id = $c_acs['arr_section']['user'];
	$library->library_item_ids = $cms_user_library_ids;
	$output_user_library_items = $library->getLibraryItems();
}
//get activities
if (!empty($cms_activity_ids)) {
	$activity->activity_ids = $cms_activity_ids;
	$output_activities = $activity->getActivities();
}
//get files
if (!empty($cms_file_ids)) {
	$file->file_ids = $cms_file_ids;
	$output_files = $file->getFiles();
}
//get polls
if (!empty($cms_poll_ids)) {
	$poll->poll_ids = $cms_poll_ids;
	$output_polls = $poll->getPolls();
}
//get tasks
if (!empty($cms_task_ids)) {
	$activity->task_ids = $cms_task_ids;
	$output_tasks = $activity->getTasks();
}


//move to template
if (!empty($output_group_blogs)) {
	$body->set('group_blogs', $output_group_blogs);
	$body->set('cms_group_blogs', $output_cms_group_blogs);
	
}

if (!empty($output_user_blogs)) {
	$body->set('user_blogs', $output_user_blogs);
	$body->set('cms_user_blogs', $output_cms_user_blogs);
	
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
	$body->set('cms_subjects', $output_cms_subjects);
}

if (!empty($output_user_library_items)) {
	$body->set('user_library_items', $output_user_library_items);
	$body->set('cms_user_library_items', $output_cms_user_library_items);
}

if (!empty($output_group_library_items)) {
	$body->set('group_library_items', $output_group_library_items);
	$body->set('cms_group_library_items', $output_cms_group_library_items);
}

if (!empty($output_activities)) {
	$body->set('activities', $output_activities);
	$body->set('cms_activities', $output_cms_activities);
}

if (!empty($output_tasks)) {
	$body->set('tasks', $output_tasks);
	$body->set('cms_tasks', $output_cms_tasks);
}

if (!empty($output_files)) {
	$body->set('files', $output_files);
	$body->set('cms_files', $output_cms_files);
}

if (!empty($output_polls)) {
	$body->set('polls', $output_polls);
	$body->set('cms_polls', $output_cms_polls);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (isset($status_id)) {
    $body->set('status_id', $status_id);
}

if (isset($level_id)) {
    $body->set('level_id', $level_id);
}

$body->set('level_node', $c_node['cms']['cms_level']['node']);
$body->set('level_public', $c_node['cms']['cms_level']['public']);

include "inc/footer.inc.php";
?>
