<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Forum {
	// CLASS FUNCTIONS
	// Forum
	// getTopics
	// getSubjects
	// getSubjectMovement
	// getSubject
	// insertSubject
	// updateSubject
	// insertTopic
	// getTopic
	// updateTopic
	// getSubjectCount
	// deleteSubject
	
	
	
	// Forum --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 21st Feb 2004
	//
	function Forum($db, $section_id, $date, $file = null) {
		$this->db = $db;
		$this->section_id = $section_id;
		$this->date = $date;
		
		if (isset($file)) {
		    $this->file = $file;
		}
	}//EO Forum

	
	
	// getSectionTopics --------------------------------------------------------------------
	// returns one section row and associated topis from the Db
	// tom calthrop - 21st Feb 2004
	//
	function getTopics($include_subjects = null, $search = null) {
		$query = "
			SELECT topic_id, topic_title, topic_synopsis, topic_hidden 
			FROM " . $this->db->prefix . "_forum_topic
			where
			section_id=" . $this->section_id . " and 
			section_item_id=" . $this->section_item_id . " and "
		;
		
		if (!isset($this->include_hidden)) {
		    $query .= "topic_hidden is null and ";
		}
		
		$query .= "1=1 order by topic_title";

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				if (isset($include_subjects)) {
				    $this->topic_id = $temp1['topic_id'];
					$temp1['subjects'] = $this->getSubjects($search);
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getSectionTopics class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getSectionTopics
	
	
	
	// getSubjects --------------------------------------------------------------------
	// returns multiple rows from DB
	// tom calthrop - 21st Feb 2004
	//
	function getSubjects($search = null) {
		$query = "
			SELECT s.subject_id, s.topic_id, s.subject_title, s.file_id,
			s.user_id, s.subject_hidden, s.subject_body, s.subject_create_datetime, 
			s.subject_locked, s.subject_sticky "
		;
		
		if (isset($this->section_item_id)) {//we need to get group from DB
			$query .= "
				, t.section_item_id as group_id  
				FROM " . $this->db->prefix . "_forum_subject s, " . $this->db->prefix . "_forum_topic t 
				WHERE 
				s.topic_id=t.topic_id and 
				t.section_item_id=" . $this->section_item_id . " AND "
			;
		}
		else {
		    $query .= "
				FROM " . $this->db->prefix . "_forum_subject s 
				WHERE "
			;
		}
		
		if (!isset($this->include_hidden)) {
		    $query .= "subject_hidden is null and ";
		}
		
		if (isset($this->user_id)) {
			$query .= "s.user_id=" . $this->user_id . " and ";
		}
		
		if (isset($search)) {
		    $query .= "
				(s.subject_title like '%" . $search . "%' or
				s.subject_body like '%" . $search . "%') and "
			;
		}
		
		if (isset($this->topic_id)) {
		    $query .= "s.topic_id=" . $this->topic_id . " and ";
		}
		
		if (isset($this->subject_ids)) {
			$subject_ids = "";
			foreach($this->subject_ids as $key => $i):
				$subject_ids .= $i;
				if (count($this->subject_ids) > $key+1) {
				    $subject_ids .=",";
				}
			endforeach;
			$query .="s.subject_id in (" . $subject_ids . ") and ";
		}
		
		$query .="1=1 ";
		
		$query .= "order by s.subject_sticky desc, s.subject_create_datetime desc";
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				if (isset($search)) { //format search results
					$temp1['subject_title'] = searchTextFormat($search, $temp1['subject_title']);
					$temp1['subject_body'] = searchTextFormat($search, $temp1['subject_body']);
				}
				
				if (isset($this->file)) {
					if (isset($temp1['file_id'])) {
						$this->file->file_id = $temp1['file_id'];
						$temp1['image'] = $this->file->getFileRecord();
					}
					else {
						$temp1['image']['file_title'] = "";
						$temp1['image']['file'] = $this->file->noimage;
					}
				}
				
				$temp1['subject_create_datetime'] = $this->date->formatDate($temp1['subject_create_datetime']);

				$temp1['subject_body'] = nl2br($temp1['subject_body']);

				//get the bookmarks and last view datetime
				if (isset($this->bookmark)) {
					$temp1['movement'] = $this->getSubjectMovement($temp1['subject_id']);
				}
				
				if (isset($this->comment)) {
					$temp1['comment_total'] = $this->comment->getCommentCount($temp1['subject_id']);
					$this->comment->limit = 1;
					$temp1['last_comment'] = $this->comment->getComment($temp1['subject_id'], 1);
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getSubjects class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getSubjects
	
	
	
	// getSubjectMovement --------------------------------------------------------------------
	// We get the movement of the subject from when we last looked to now.
	// tom calthrop - 23rd November 2004
	//
	function getSubjectMovement($subject_id) {
		//get the last view date
		$this->bookmark->bookmark_item_id = $subject_id;
		$lastviewdate = $this->bookmark->getBookmarkLastViewDate($subject_id);
		
		//select the movement
		if (!empty($lastviewdate)) {
			$temp = array();
			$temp['lastview_datetime'] = $this->date->formatDate($lastviewdate);
			
			$temp['movement'] = $this->comment->getCommentCount(null, $lastviewdate);
			
			if ($temp['movement'] < 1) {
				$temp['movement'] = 0;
			}
			return $temp;
		}
	}//EO getSubjectMovement
	
	
	
	// getSubject --------------------------------------------------------------------
	// returns a row from DB
	// tom calthrop - 21st Feb 2004
	//
	function getSubject() {
		$query = "
			SELECT subject_id, topic_id, subject_title, file_id, user_id, subject_hidden, 
			subject_body, subject_create_datetime, subject_locked, subject_sticky 
			FROM " . $this->db->prefix . "_forum_subject s
			where
			s.subject_id=" . $this->subject_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = $result->fields;
			$temp['subject_create_datetime'] = $this->date->formatDate($temp['subject_create_datetime']);
			
			$temp['display_subject_body'] = nl2br($temp['subject_body']);
			
			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=getSubject class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getSubject
	
	
	
	// insertSubject --------------------------------------------------------------------
	// updates a total number of replies into subject row into DB
	// tom calthrop - 8th Jan 2004
	//
	function insertSubject($data) {
		if (empty($data['subject_title'])) {
		    $GLOBALS['am_error_log'][] = array(11, null, null);
		}
			
		if (empty($data['subject_body'])) {
			$GLOBALS['am_error_log'][] = array(12, null, null);
		}
			
		if (empty($GLOBALS['am_error_log'])) {
			$datetime = date("Y-m-d H:i:s");
			$datetime = $this->db->DBDate($datetime);
	
			if (empty($data['subject_hidden'])) {
			    $data['subject_hidden'] = "null";
			}
	
			if (empty($data['file_id'])) {
			    $data['file_id'] = "null";
			}
	
			if (empty($data['subject_sticky'])) {
			    $data['subject_sticky'] = "null";
			}
	
			if (empty($data['subject_locked'])) {
			    $data['subject_locked'] = "null";
			}
	
			$query = "
				INSERT INTO " . $this->db->prefix . "_forum_subject (
				topic_id, 
				subject_title, 
				subject_body, 
				subject_create_datetime, 
				user_id, 
				file_id, 
				subject_sticky, 
				subject_locked, 
				subject_hidden
				) values (
				" . $data['topic_id'] . ",
				'" . $data['subject_title'] . "',
				'" . $data['subject_body'] . "',
				" . $datetime . ",
				" . $this->user_id . ",
				" . $data['file_id'] . ",
				" . $data['subject_sticky'] . ",
				" . $data['subject_locked'] . ",
				" . $data['subject_hidden'] . ")"
			;
	
			$result = $this->db->Execute($query);
	
			if (isset($result->fields)) {
				$query = "
					SELECT subject_id  
					FROM " . $this->db->prefix . "_forum_subject 
					where
					topic_id=" . $data['topic_id'] . " and 
					subject_create_datetime=" . $datetime 
				;
		
				$result = $this->db->SelectLimit($query, 1);
				
				if (isset($result->fields['subject_id'])) {
					$this->subject_id = $result->fields['subject_id'];
				}
				else {
					$error_info = "function=insertSubject class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
				}
			}
			else {
				$error_info = "function=insertSubject class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	}//EO insertSubject

	
	
	// updateSubject --------------------------------------------------------------------
	// updates subject row into DB
	// tom calthrop - 8th Jan 2004
	//
	function updateSubject($data) {
		
		if (empty($data['subject_hidden'])) {
		    $data['subject_hidden'] = "null";
		}

		if (empty($data['subject_sticky'])) {
	    	$data['subject_sticky'] = "null";
		}

		if (empty($data['subject_locked'])) {
		    $data['subject_locked'] = "null";
		}

		$query = "
			UPDATE " . $this->db->prefix . "_forum_subject SET
			topic_id = '" . $data['topic_id'] . "',
			subject_sticky = " . $data['subject_sticky'] . ",
			subject_locked = " . $data['subject_locked'] . ",
			subject_hidden = " . $data['subject_hidden'] . "
			WHERE
			subject_id =" . $this->subject_id;
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			return true;
		}
		else {
			$error_info = "function=updateSubject class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO updateSubject
	
	
	
	// insertTopic --------------------------------------------------------------------
	// inserts a topic
	// tom calthrop - 8th Jan 2004
	//
	function insertTopic($data) {
		if (empty($data['topic_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			$datetime = date("Y-m-d H:i:s");
			$datetime = $this->db->DBDate($datetime);
	
			if (empty($data['topic_synopsis'])) {
			    $data['topic_synopsis'] = "null";
			}
			
			if (empty($data['topic_hidden'])) {
			    $data['topic_hidden'] = "null";
			}
	
			$query = "
				INSERT INTO " . $this->db->prefix . "_forum_topic (
				section_id, 
				section_item_id, 
				topic_title, 
				topic_synopsis, 
				topic_hidden, 
				topic_create_datetime, 
				user_id
				) values (
				" . $this->section_id . ",
				" . $this->section_item_id . ",
				'" . $data['topic_title'] . "',
				'" . $data['topic_synopsis'] . "',
				" . $data['topic_hidden'] . ",
				" . $datetime . ",
				" . $this->user_id . ")"
			;
			
			$result = $this->db->Execute($query);
	
			if (empty($result)) {
				$error_info = "function=insertTopic class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	}//EO insertTopic
	
	
	
	// getTopic --------------------------------------------------------------------
	// returns a row from DB
	// tom calthrop - 21st December 2004
	//
	function getTopic() {
		$query = "
			SELECT topic_id, section_id, section_item_id, topic_title, 
			topic_synopsis, topic_create_datetime, user_id, topic_hidden 
			FROM " . $this->db->prefix . "_forum_topic 
			where
			topic_id=" . $this->topic_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = $result->fields;
			$temp['topic_create_datetime'] = $this->date->formatDate($temp['topic_create_datetime']);
			
			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=getTopic class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getTopic

	
	
	// updateTopic --------------------------------------------------------------------
	// updates a row from DB
	// tom calthrop - 21st December 2004
	//
	function updateTopic($data) {

		if (empty($data['topic_synopsis'])) {
		    $data['topic_synopsis'] = "null";
		}
		
		if (empty($data['topic_hidden'])) {
		    $data['topic_hidden'] = "null";
		}
		
		$query = "
			UPDATE " . $this->db->prefix . "_forum_topic SET
			topic_title='" . $data['topic_title'] . "',
			topic_synopsis='" . $data['topic_synopsis'] . "',
			topic_hidden=" . $data['topic_hidden'] . ",
			user_id=" . $this->user_id . "
			WHERE
			topic_id=" . $data['topic_id'];
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=updateTopic class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO updateTopic
	
	
	
	// getSubjectCount --------------------------------------------------------------------
	// get the total subjects
	// tom calthrop - 23rd November 2004
	//
	function getSubjectCount() {
		
		$query = "
			SELECT count(s.subject_id) as total 
			FROM " . $this->db->prefix . "_forum_subject s"
		;
		
		if (isset($this->section_item_id)) {
		    $query .= "
				LEFT JOIN " . $this->db->prefix . "_forum_topic t ON s.topic_id=t.topic_id 
				WHERE
				t.section_id=" . $this->section_id . " AND 
				t.section_item_id=" . $this->section_item_id . " AND "
			;
		}
		else {
			$query .= "WHERE ";
		}
		
		if (isset($this->user_id)) {
			$query .= "s.user_id=" . $this->user_id . " AND ";
		}
		
		$query .= "1=1 ";
			
		$result = $this->db->Execute($query);
			
		if (isset($result->fields['total'])) {
			return $result->fields['total'];
		}
		else {
			$error_info = "function=getSubjectCount class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getSubjectCount

	
	
	// deleteSubject --------------------------------------------------------------------
	// deletes subject row from DB
	// tom calthrop - 28th December 2004
	//
	function deleteSubject($subject_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_forum_subject 
			WHERE
			subject_id =" . $subject_id;
		;

		$result = $this->db->Execute($query);

		if (empty($result->fields)) {
			$error_info = "function=updateSubject class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO deleteSubject

}
?>
