<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_my.inc.php";
require_once($c_node['dir']['class_path'] . 'Poll.class.php');
require_once($c_node['dir']['class_path'] . 'Forum.class.php');
require_once($c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['class_path'] . 'Schedule.class.php');
require_once($c_node['dir']['class_path'] . 'Blog.class.php');
require_once($c_node['dir']['class_path'] . 'Shout.class.php');
require_once($c_node['dir']['class_path'] . 'Comment.class.php');


//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_rsp.lang.php');


//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


//setup forum
$forum = new Forum($db, null, $date, $file);


//setup blog
$blog = new Blog($db, null, $date, $file);
$blog->user_id = $user_id;


//setup shout
$shout = new Shout($db, $date);
$shout->user_id = $me['user_id'];


//library setup
$library = new Library($db, null, $date, $file);
$library->user_id = $me['user_id'];


//event setup
$poll = new Poll($db, null, $date);
$poll->user_id = $me['user_id'];


//schedule setup
$schedule = new Schedule($db, null, $date, $file);
$schedule->user_id = $me['user_id'];


//get published items
$output_publish_library = $library->selLibraryItems();
$output_publish_forum = $forum->selSubjects();
$output_blogs = $blog->selBlogs();
$output_shouts = $shout->getShouts();

//get total replies for subjects
if (!empty($output_publish_forum)) {
    foreach($output_publish_forum as $key => $i):
		$forum->subject_id = $i['subject_id'];
		//$output_publish_forum[$key]['total_replies'] = $forum->getReplyCount();
		$output_publish_forum[$key]['total_replies'] = 0;
	endforeach;
}

	
	
//setup comment
$comment = new Comment($db, null, $date);
$comment->user_id = $user_id;
$comment->limit = 10;
$output_comments = $comment->selComments();
	
	

//get poll participation
$output_poll_participation = $poll->getUserPollParticipation();

//move to template
if (!empty($output_publish_library)) {
    $body->set('publish_library', $output_publish_library);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_blogs)) {
    $body->set('blogs', $output_blogs);
}

if (!empty($output_publish_forum)) {
    $body->set('publish_forum', $output_publish_forum);
}

if (!empty($output_shouts)) {
    $body->set('publish_shouts', $output_shouts);
}

if (!empty($output_user)) {
    $body->set('user', $output_user);
}

if (!empty($output_relationship)) {
    $body->set('relationship', $output_relationship);
}

if (!empty($output_poll_participation)) {
    $body->set('poll_participation', $output_poll_participation);
}

$body->set('rsp_item_type_ids', $c_node['rsp']['item_type']);

$template_pageLink = $lang['txt_publishing'];
include "inc/footer.inc.php";

?>
