<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_schedule.inc.php";

if (!empty($_REQUEST['group_id'])) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_schedule'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $_REQUEST['group_id']."&".SID);
		exit;
	}
}


// SETUP WIKI
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
$wiki =& new Text_Wiki();
$wiki->disableRule('wikilink');


// SETUP COMMENTS
require_once($c_node['dir']['class_path'] . 'Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['schedule'], $date);
$comment->user_id = $me['user_id'];
$comment->wiki = $wiki;
if (isset($group_id)) {
    $comment->group_id = $group_id;
}


// SETUP TAGS
require_once($c_node['dir']['class_path'] . 'Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['schedule']);
$tag->user_id = $me['user_id'];
if (isset($group_id)) {
    $tag->group_id = $group_id;
}


if (isset($_POST['update_tag'])) {
	$tag->deleteTags($frmdata);
	$tag->insertTags($frmdata);
}	
elseif (isset($_POST['preview'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
	$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');

	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $schedule->schedule_id;
	$comment->insertComment($frmdata);

	if (empty($GLOBALS['am_error_log'])) {
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, $date);
		//update stats
		if (!empty($group_id)) { // page under group section
			//group member comments
			$comment->group_id = $group_id;
			unset($comment->rsp_item_type_id, $comment->item_id);
			$comment->user_id = $me['user_id'];
			$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_comments'];
			$statistic->user_id = $me['user_id'];
			$statistic->setStatistic($comment->getCommentCount());
			//group stats
			unset($comment->user_id, $statistic->user_id);
			$statistic->statistic_type_id = $c_node['statistic']['group']['total_comments'];
			$statistic->setStatistic($comment->getCommentCount());
		}

		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$comment->user_id = $me['user_id'];
		unset($comment->item_id, $comment->rsp_item_type_id, $comment->section_id, $comment->section_item_id);
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());

		if (!empty($group_id)) { // page under group section
			return header("Location: sch_item.php?group_id=". $group_id . "&schedule_id=". $schedule->schedule_id . "&" . SID);
		}
		else {
			return header("Location: sch_item.php?schedule_id=". $schedule->schedule_id . "&" . SID);
		}
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
}
elseif (isset($_REQUEST['withdraw_confirmation'])) {
	$schedule->updateScheduleAllocation($_REQUEST['schedule_id'], $me['user_id'], $c_node['schedule']['allocation_status']['withdrawn']);
	if (!empty($group_id)) { // page under group section
		header("Location: sch_item.php?group_id=" . $group_id . "&schedule_id=" . $_REQUEST['schedule_id'] . "&" . SID);
	}
	else {
		header("Location: sch_item.php?schedule_id=" . $_REQUEST['schedule_id'] . "&" . SID);
	}
	exit;
}
elseif (isset($_REQUEST['schedule_apply_update'])) {
	$schedule->updateScheduleAllocation($_REQUEST['schedule_id'], $me['user_id'], $c_node['schedule']['allocation_status']['pending']);
	if (!empty($group_id)) { // page under group section
		header("Location: sch_item.php?group_id=" . $group_id . "&schedule_id=" . $_REQUEST['schedule_id'] . "&" . SID);
	}
	else {
		header("Location: sch_item.php?schedule_id=" . $_REQUEST['schedule_id'] . "&" . SID);
	}
	exit;
}
elseif (isset($_REQUEST['schedule_apply'])) {
	$schedule->insertScheduleAllocation($_REQUEST['schedule_id'], $me['user_id'], $c_node['schedule']['allocation_status']['pending']);
	if (!empty($group_id)) { // page under group section
		header("Location: sch_item.php?group_id=" . $group_id . "&schedule_id=" . $_REQUEST['schedule_id'] . "&" . SID);
	}
	else {
		header("Location: sch_item.php?schedule_id=" . $_REQUEST['schedule_id'] . "&" . SID);
	}
	exit;
}

if (isset($schedule->schedule_id)) {
	$schedule->user_id = $me['user_id']; // gets my allocation
    $output_schedule = $schedule->selScheduleItem();
	
	if (isset($output_schedule['schedule_id'])) {
	
		//wikify body
		if (isset($group_id)) {
		    $wiki_path = "lib_item.php?group_id=" . $group_id . "&page=";
			$wiki_new_path = "lib_edit.php?group_id=" . $group_id . "&page=";
			$wiki_image_base = $c_node['dir']['asset_path'] . "group/";
		}
		else {
		    $wiki_path = "lib_item.php?page=";
			$wiki_new_path = "lib_edit.php?page=";
			$wiki_image_base = $c_node['dir']['asset_path'] . "user/";
		}
		require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
		$wiki =& new Text_Wiki();
		$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
		$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
		$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . $wiki_image_base);
		$output_schedule['schedule_body'] = $wiki->transform($output_schedule['schedule_body'], 'Xhtml');
		
		
		
		//get the group and/or the author
		if (!empty($output_group['group_id'])) {
			$output_author = $output_group;
		}
		elseif (!empty($output_schedule['group_id'])) {
			require_once($c_node['dir']['class_path'] . 'Group.class.php');
			$group = new Group($db, $date, $file);
			$group->group_id = $output_schedule['group_id'];
			$output_author = $group->getGroup();
		}
		else {
			$user->user_id = $output_schedule['user_id'];
			$output_author = $user->getProfile();
		}
		
		//get schedule image
		$schedule->file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
		$schedule->file->thumb = $c_node['file']['image']['thumb'][1]['name'];
		
		if (isset($output_schedule['file_id'])) {
			$schedule->file->file_id = $output_schedule['file_id'];
			$output_schedule['image'] = $schedule->file->getFileRecord();
		}
		else {
			$output_schedule['image']['file_title'] = "";
			$output_schedule['image']['file'] = $schedule->file->noimage;
		}
		
		
		//setup bookmarks --------------------------------------------------
		require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');
		$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['schedule'], $date, $me['user_id']);
		$bookmark->item_id = $schedule->schedule_id;
		
		//watching
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		//set or unset bookmarks
		if (isset($_REQUEST['watch'])) {
			$bookmark->insertBookmark();
		}
		elseif (isset($_REQUEST['unwatch'])) {
			$bookmark->deleteBookmark();
		}
		//get and update bookmark
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$tpl->set('toolbar_watch', 1);
		}
		
		//recommended
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		//set or unset bookmarks
		if (isset($_REQUEST['recommend'])) {
			$bookmark->insertBookmark();
		}
		elseif (isset($_REQUEST['unrecommend'])) {
			$bookmark->deleteBookmark();
		}
		//get and update bookmark
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$tpl->set('toolbar_recommend', 1);
		}
		
		if ($output_schedule['schedule_p_complete']<1) {
		    $output_schedule['schedule_p_complete'] = "0";
		}
	
		//get RSP items if I am looking at my schedule
		if ($output_schedule['user_id'] == $me['user_id']) {
			require_once($languageArrayPath . 'arr_rsp.lang.php');
			require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
			$rsp = new Rsp($db, $c_node['rsp']['item_type']['schedule']);
			$output_schedule['rsp'] = $rsp->selRspItem($schedule->schedule_id);
			
			$body->set('rsp_config', $c_node['rsp']); 
		}
		
		//get comments
		unset($comment->user_id);
		$output_comments = $comment->selComments($schedule->schedule_id);
	
		//get RSP items if I am looking at my schedule
		if ($output_schedule['user_id'] == $me['user_id']) {
			require_once($languageArrayPath . 'arr_rsp.lang.php');
			require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
			$rsp = new Rsp($db, $c_node['rsp']['item_type']['schedule']);
			$output_schedule['rsp'] = $rsp->selRspItem($schedule->schedule_id);
	
			$body->set('rsp_config', $c_node['rsp']);
		}
		
		
		//get tags
		unset($tag->group_id);
		$tag->item_id = $schedule->schedule_id;
		$output_my_tags = $tag->selTags();
		unset($tag->user_id);
		$output_network_tags = $tag->selTags('network');
		
		if (isset($group_id)) {
			$tag->group_id = $group_id;
			$output_group_tags = $tag->selTags();
		}
			
	}
	else { // no schedule returned from db
		header("Location: error.php?".SID);
		exit;
	}
	
}
else { // no schedule id
	if (isset($group_id)) {
	    header("Location: sch_list.php?group_id=" . $group_id ."&".SID);
	}
	else {
		header("Location: sch_list.php?".SID);
	}
	exit;
}


//move to template
if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_schedule)) {
	$body->set('schedule', $output_schedule);
	$tpl->set('schedule_id', $output_schedule['schedule_id']); //sets menus
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_schedule['schedule_title'])) {
	$template_pageLink = $lang['txt_bc_schedule'];
	$template_pageLinkNote = $output_schedule['schedule_title'];
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_group_tags)) {
	$body->set('group_tags', $output_group_tags);
}

if (!empty($output_network_tags)) {
	$body->set('network_tags', $output_network_tags);
}

$body->set('allocation_status', $c_node['schedule']['allocation_status']);
$body->set('schedule_config', $c_node['schedule']);

$body->set('languagePath', $languagePath); //for calendar lang config

//setup print options
$tpl->set('toolbar_print', 'print_item.php?schedule_id=' . $output_schedule['schedule_id']);
$tpl->set('toolbar_printc', 'print_item.php?schedule_id=' . $output_schedule['schedule_id'] . '&amp;inc_comment=1');

if (isset($_REQUEST['group_id'])) {
	$tpl->set('toolbar_bookmark_url', 'sch_item.php?group_id=' . $_REQUEST['group_id'].'&amp;schedule_id=' . $output_schedule['schedule_id']);
}
else {
	$tpl->set('toolbar_bookmark_url', 'sch_item.php?schedule_id=' . $output_schedule['schedule_id']);
}


include "inc/footer.inc.php";

?>
