<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


// SETUP BREADCRUMB -------------------------------------------------------
if (isset($template_pageLink)) {

	$breadcrumb = $_SESSION['s_breadcrumb'];

	if (count($breadcrumb) > 6) {
			array_splice($breadcrumb, 0, 1);
	}

	$url = "http://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

	if (!isset($template_pageLinkNote)) {
	    $template_pageLinkNote = "";
	}

	if (isset($breadcrumb)) {
	    $prev_breadcrumb = count($breadcrumb);

		if ($prev_breadcrumb < 1) {
		    $prev_breadcrumb = 1;
		}
		$prev_breadcrumb = $prev_breadcrumb-1;

		if (isset($breadcrumb[$prev_breadcrumb]['url'])){
			$prev_url = $breadcrumb[$prev_breadcrumb]['url'];
		}
		else {
			$prev_url = "";
		}

		$page_name_prev = explode(".",basename($prev_url));

		if ($page_name_prev[0] != $page_name[0]) {
			array_push($breadcrumb, array('breadcrumb_url'=> $url, 'breadcrumb_title'=>$template_pageLink, 'breadcrumb_note'=>$template_pageLinkNote));
			$_SESSION['s_breadcrumb'] = $breadcrumb;
		}
    }
}


// TEMPLATE OUTPUT -----------------------------------------------------------------------
// error reporting
if (!empty($GLOBALS['am_error_log'])) {
	if (isset($c_node['node']['debug_mode'])) {
	    $tpl->set('error_handling', $c_node['node']['debug_mode']);
	}
    $tpl->set('log', $GLOBALS['am_error_log']);
}



// language
$tpl->set('lang', $lang);
$body->set('lang', $lang);

// acs and user
$tpl->set('resource_ids', $c_acs['arr_acs']['resource']);
$body->set('resource_ids', $c_acs['arr_acs']['resource']);
$tpl->set('privilege_ids', $c_acs['arr_acs']['privilege']);
$body->set('privilege_ids', $c_acs['arr_acs']['privilege']);
$tpl->user_acs = $user_acs;
$body->user_acs = $user_acs;

if (isset($group_acs)) {
    $body->group_acs = $group_acs;
	$tpl->group_acs = $group_acs;
}

$tpl->set('me', $me);
$body->set('me', $me);

// date
$tpl->set('today', $date->getToday());

// general interface, url and template
$tpl->set('templatePath', $template_path);
$body->set('templatePath', $template_path);
$body->set('page_url', $_SERVER['REQUEST_URI']);
$body->set('page_name', basename($_SERVER['REQUEST_URI']));
$tpl->set('breadcrumb', $_SESSION['s_breadcrumb']);
$body->set('page_name_short', $page_name[0]);
$tpl->set('page_name_short', $page_name[0]);

if (!empty($shoutbox)) {
    $tpl->set('shoutbox', $shoutbox);
}

if (isset($template_pagetitle)) {
	$tpl->set('pageTitle', $template_pagetitle);
}

if (isset($menu_section)) {
    $tpl->set('section', $menu_section);
}

if (!empty($man)) {
    $tpl->set('man', implode(",", $man));
}

// PROCESS TEMPLATE -----------------------------------------------------------------------
$template_file = $page_name[0] . ".tpl.php";

if (isset($_REQUEST['abuse_report'])) { //if page is reported as abuse we redirect
	$_SESSION['report_abuse_url'] = $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
	$_SESSION['report_abuse_body'] = $body->fetch($template_file);
	header("Location: report_abuse.php?" . SID);
	exit;
}
else {
	$tpl->set('content', $body->fetch($template_file));
//echo $tpl->fetch($template_file);
	echo $tpl->fetch('default.tpl.php');
}


// TIDY UP -----------------------------------------------------------------------
$db->Close();

?>
