<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

?>


<form action="node_group.php" method="post">
<input type="hidden" name="data[group_id]" value="<?php echo $group['group_id'];?>" />

<table width="100%" border="0" cellspacing="0" cellpadding="0">
	<tr>
		<td width="180" valign="top">
			<?php
			include $templatePath . "node_menu.inc.tpl.php";
			?>
		</td>

		<td width="20">&nbsp;</td>

		<td width="560" valign="top">
			<?php
			if (isset($display) && $display == "view_group") {
			?>
			
			<div class="box_top">
				<?php echo $lang['section_group'];?><br />
			</div>
			
			<div class="box_mid" style="padding: 9px;">
			<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<tr>
					<td colspan="2">
						<b><?php echo $group['group_title'];?></b><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo $group['group_synopsis'];?><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
					</td>
				</tr>
				<tr>
					<td width="40%">
						<?php echo $lang['txt_election_date'];?><br />
					</td>
					<td width="60%">
						<?php echo $group['display_group_election_date'];?><br />
					</td>
				</tr>
				<?php 
				if (isset($group['group_registration_type'])) {
				?>
				<tr>
					<td>
						<?php echo $lang['txt_registration_group_type'];?><br />
					</td>
					<td>
						<?php echo $lang['arr_registration_type'][$group['group_registration_type']];?><br />
					</td>
				</tr>
				<?php }?>
				<tr>
					<td>
						<?php echo $lang['txt_status'];?><br />
					</td>
					<td>
						<?php echo $lang['arr_group_status'][$group['status_id']];?><br />
					</td>
				</tr>
				<tr>
					<td>
						<?php echo $lang['txt_language'];?><br />
					</td>
					<td>
						<?php echo $lang['arr_lang_name'][$group['language_id']];?><br />
					</td>
				</tr>
				<tr>
					<td>
						<?php echo $lang['txt_age'];?><br />
					</td>
					<td>
						<?php echo $lang['txt_age_from'];?> <?php if(isset($group['group_from_age'])) { echo $group['group_from_age']; } else {echo $lang['txt_age_any'];}?>&nbsp;
						<?php echo $lang['txt_age_to'];?> <?php if(isset($group['group_to_age'])) { echo $group['group_to_age']; } else {echo $lang['txt_age_any'];}?><br />
					</td>
				</tr>
				<?php 
				if (isset($group['genre_id'])) {
				?>
				<tr>
					<td>
						<?php echo $lang['txt_genre'];?><br />
					</td>
					<td>
						<?php echo $lang['arr_genre'][$group['genre_id']];?><br />
					</td>
			    </tr>
				<?php }?>
				<tr>
					<td>
						<?php echo $lang['txt_group_id'];?><br />
					</td>
					<td>
						<?php echo $group['group_id'];?><br />
					</td>
			    </tr>
				<tr>
					<td>
						<?php echo $lang['txt_group_create_datetime'];?><br />
					</td>
					<td>
						<?php echo $group['display_group_create_datetime'];?><br />
					</td>
			    </tr>
				<tr>
					<td>
						<?php echo $lang['txt_group_author'];?><br />
					</td>
					<td>
						<?php echo $group['user_id'];?><br />
					</td>
			    </tr>
				<?php 
				if (isset($group['cms_level_id'])) {
				?>
				<tr>
					<td>
						<?php echo $lang['txt_cms_level'];?><br />
					</td>
					<td>
						<?php echo $group['cms_level_id'];?><br />
					</td>
			    </tr>
				<?php }?>
				<tr>
					<td>
						<?php echo $lang['txt_default_image'];?><br />
					</td>
					<td>
						<?php echo $group['file_id'];?><br />
					</td>
			    </tr>
				<tr>
					<td>
						<?php echo $lang['txt_visibility'];?><br />
					</td>
					<td>
						<?php
						if ($group['group_visibility'] == 1) {
							echo $lang['arr_group_visibility'][1];
						}
						else {
							echo $lang['arr_group_visibility'][2];
						}
						
						;?><br />
					</td>
			    </tr>
				<tr>
					<td>
						<?php echo $lang['txt_file_allocation'];?><br />
					</td>
					<td>
						<?php echo round($group['group_file_allocation']/1000, 2);?>kb<br />
					</td>
			    </tr>
				<tr>
					<td colspan="2">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<b><?php echo $lang['txt_rules'];?></b><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo $group['display_group_rules'];?><br />
					</td>
			    </tr>
			</table>
			</div>
			
			<div id="box_bottom">
				<table cellpadding="0" cellspacing="0" border="0" width="100%">
					<tr>
						<td align="left">
							<img src="<?php echo $templatePath;?>img/box_bottom_left.png" width="5" height="18" alt="" border="0" /><br />
						</td>
						<td align="left">
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" border="0" /><br />
						</td>
						<td align="right">
							<img src="<?php echo $templatePath;?>img/box_bottom_right.png" width="5" height="18" alt="" border="0" /><br />
						</td>
					</tr>
				</table>
			</div>
			<?php
			}
			elseif (isset($display) && $display == "edit_group") {
			?>
			
			<div class="box_top">
				<?php echo $lang['section_group'];?><br />
			</div>
			
			<div class="box_mid" style="padding: 9px;">
			<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<tr>
					<td colspan="2">
						<b><?php echo $group['group_title'];?></b><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo $group['group_synopsis'];?><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
					</td>
				</tr>
				<tr>
					<td>
						<label for="id_date"><?php echo $lang['txt_election_date'];?></label><br />
					</td>
					<td>
						<?php echo $datedropdown;?>
					</td>
				</tr>
				<tr>
					<td>
						<label for="id_group_file_allocation"><?php echo $lang['txt_file_allocation'];?></label><br />
					</td>
					<td>
						<input id="id_group_file_allocation" type="text" name="data[group_file_allocation]" size="10" value="<?php echo round($group['group_file_allocation']/1000, 2);?>">kb<br />
					</td>
			    </tr>
				<tr>
					<td>
						<label for="id_status"><?php echo $lang['txt_status'];?></label><br />
					</td>
					<td>
						<select id="id_status" name="data[status_id]">
						<?php foreach($lang['arr_group_status'] as $key => $i): 
						?>
						<option value="<?php echo $key;?>" <? if($group['status_id'] == $key) echo "selected=\"selected\"";?>><?php echo $i;?></option>
						<?php endforeach; ?>
						</select>
						<br />
					</td>
				</tr>
				<tr>
					<td>
						<label for="id_group_visibility"><?php echo $lang['txt_visibility'];?></label><br />
					</td>
					<td>
						<input id="id_group_visibility" type="radio" name="data[group_visibility]" value="1" <?php if($group['group_visibility'] == 1) { echo "checked=\"checked\"";}?>>&nbsp;<?php echo $lang['arr_group_visibility'][1];?>&nbsp;&nbsp;
						<input id="id_group_visibility" type="radio" name="data[group_visibility]" value="0" <?php if($group['group_visibility'] != 1) { echo "checked=\"checked\"";}?>>&nbsp;<?php echo $lang['arr_group_visibility'][2];?><br />
					</td>
			    </tr>
				<tr>
					<td align="right" colspan="2">
						<input type="submit" name="update_group" value="<?php echo $lang['sub_update_group'];?>" class="button_urgent"><br />
					</td>
				</tr>
			</table>
			</div>
			
			<div id="box_bottom">
				<table cellpadding="0" cellspacing="0" border="0" width="100%">
					<tr>
						<td align="left">
							<img src="<?php echo $templatePath;?>img/box_bottom_left.png" width="5" height="18" alt="" border="0" /><br />
						</td>
						<td align="left">
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" border="0" /><br />
						</td>
						<td align="right">
							<img src="<?php echo $templatePath;?>img/box_bottom_right.png" width="5" height="18" alt="" border="0" /><br />
						</td>
					</tr>
				</table>
			</div>
			<?php
			}
			else {
			?>
			<div class="box_top">
				<?php echo $lang['menu_group_list'];?><br />
			</div>
			
			<div class="box_mid" style="padding: 9px;">
			<table border="0" cellspacing="0" cellpadding="4" width="100%">
				<tr>
					<td>
						&nbsp;<br />
					</td>
					<td valign="top">
						<b><?php echo $lang['txt_group'];?></b><br />
					</td>
					<td valign="top">
						<b><?php echo $lang['txt_type'];?></b><br />
					</td>
					<td valign="top">
						<b><?php echo $lang['txt_members'];?></b><br />
					</td>
					<td valign="top">
						<b><?php echo $lang['txt_status'];?></b><br />
					</td>
					<td valign="top">
						<b><?php echo $lang['txt_create_date'];?></b><br />
					</td>
				</tr>
				<?php
				if (isset($groups[0])) {
				foreach($groups as $key => $i):
				?>
				<tr>
					<td valign="top">
						<a href="node_group.php?group_id=<?php echo $i['group_id'];?>"><?php echo $i['group_id'];?></a><br />
					</td>
					<td valign="top">
						<?php echo $i['group_title'];?><br />
					</td>
					<td valign="top">
						<?php if (isset($i['group_registration_type'])) { echo $lang['arr_registration_type'][$i['group_registration_type']];}?><br />
					</td>
					<td valign="top">
						<?php echo $i['group_total_members'];?><br />
					</td>
					<td valign="top">
						<?php echo $lang['arr_group_status'][$i['status_id']];?><br />
					</td>
					<td nowrap valign="top">
						<?php echo $i['group_create_datetime'];?><br />
					</td>
				</tr>
				<?php
				endforeach;
				}
				else {
				?>
				<tr>
					<td colspan="6">
						<?php echo $lang['err_no_groups'];?><br />
					</td>
				</tr>
				<?php
				}
				?>
			</table>
			</div>
			
			<div id="box_bottom">
				<table cellpadding="0" cellspacing="0" border="0" width="100%">
					<tr>
						<td align="left">
							<img src="<?php echo $templatePath;?>img/box_bottom_left.png" width="5" height="18" alt="" border="0" /><br />
						</td>
						<td align="left">
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" border="0" /><br />
						</td>
						<td align="right">
							<img src="<?php echo $templatePath;?>img/box_bottom_right.png" width="5" height="18" alt="" border="0" /><br />
						</td>
					</tr>
				</table>
			</div>
			<?php }?>
		</td>
	</tr>
</table>
</form>
