<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "my";
include "inc/header.inc.php";

if (!isset($me['user_id']) || $me['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}



// Setup statistics -------------------------------------------------------
require_once('class/Statistic.class.php');
$statistic = new Statistic($db, null);
$statistic->user_status = $c_node['user']['status'];
$output_user_statistics = $statistic->getAllUserStatistics();
$statistic->user_id = $me['user_id'];
$output_statistics = $statistic->getStatistics();


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('wikilink');


// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, null);
$comment->wiki = $wiki;


// Create social network summary -------------------------------------------
require_once('class/SocialNetwork.class.php');
$sn = new Socialnetwork(null, $db);
$sn->relation_type_ids = $c_node['user']['relation_type'];
$sn->status_ids = $c_node['user']['status'];
$sn->user_id = $me['user_id'];
if (isset($me['relations'])) {
	$output_network['degree1'] = count($me['relations']);
	
	if (empty($output_network['degree1'])) {
		$output_network['degree1'] = "0";
	}
}

$lang['txt_degree1'] = str_replace('INCTOTAL_DEG', $output_network['degree1'], $lang['txt_degree1']);

if (empty($output_statistics['total_users'])) {
	$output_statistics['total_users'] = "0";
}
$lang['txt_network'] = str_replace('INCTOTAL_USERS', $output_user_statistics['total_users'], $lang['txt_network']);

if (empty($output_statistics['total_online_users'])) {
	$output_statistics['total_online_users'] = "0";
}
$lang['txt_network'] = str_replace('INCTTOTAL_ONLINE', $output_user_statistics['total_online_users'], $lang['txt_network']);


// Create blog summary -------------------------------------------
$total_blogs = "0";
if (!empty($output_statistics)) {
	foreach ($output_statistics as $key => $i):
		if ($i['statistic_type_id'] == $c_node['statistic']['user']['total_blogs']) {
			if (!empty($i['total'])) {
				$total_blogs = $i['total'];
			}
			unset($output_statistics[$key]);
			break;
		}
	endforeach;
}
$lang['txt_blog'] = str_replace('INCTOTAL_BLOG', $total_blogs, $lang['txt_blog']);


$comment->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
$comment->item_user_id = $me['user_id'];
$total_blog_comments = $comment->getCommentCount();

if (empty($total_blog_comments)) {
	$total_blog_comments = "0";
}
$lang['txt_blog_comments'] = str_replace('INCTOTAL_COMMENTS', $total_blog_comments, $lang['txt_blog_comments']);

$comment->limit = 1;
$comment->orderby = "c.comment_create_datetime desc";
$output_blog_comment = $comment->selComments();
if (!empty($output_blog_comment)) {
	$output_blog_comment = $output_blog_comment[0];
}



//MOVE TO TEMPLATE
if (!empty($output_blog_comment)) {
	$body->set('blog_comment', $output_blog_comment);
}

$template_pageLink =  $lang['txt_my_overview'];

include "inc/footer.inc.php";

?>
