<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<script language="JavaScript" src="js/imageHandling.js" type="text/javascript"></script>

<form action="lib_edit.php" method="post" name="frm" id="id_frm">
<input type="hidden" name="group_id" value="<?php if(isset($group['group_id'])) { echo $group['group_id'];} elseif (isset($library['group_id'])) { echo $library['group_id'];}?>" />

<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_library'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<table border="0" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td colspan="3">
						<b>
						<?php
						if (isset($group)) {
							echo $lang['hdr_group_library_edit'] . ": " . $group['group_title'];
						}
						else {
							echo $lang['hdr_library_edit'];
						}
						?></b><br />
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="12" alt="" /><br />
					</td>
				</tr>
				<tr>
					<td valign="top">
						<fieldset>
						<legend><?php echo $lang['txt_header_1'];?></legend>
						<p>
						<?php echo $lang['txt_overview_intro'];?><br />
						</p>

						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />

						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td valign="top" width="310">
									<p>
									<label for="id_library_title"><?php echo $lang['form_label_title'];?></label>
									<input id="id_library_title" class="input" type="text" name="library_title" size="35" value="<?php if (isset($library['library_title'])) { echo $library['library_title'];}?>" /><br />
									</p>

									<p>
									<label for="id_library_synopsis"><?php echo $lang['form_label_synopsis'];?></label>
									<textarea id="id_library_synopsis" name="library_synopsis" cols="32" rows="2"><?php if (isset($library['library_synopsis'])) { echo $library['library_synopsis'];}?></textarea><br />
									</p>
								</td>
								<td>
									<img src="<?php echo $templatePath;?>img/pixel.png" width="10" height="1" alt="" /><br />
								</td>
								<td valign="top">
									<?php
									if (count($me['language_ids']) > 1) {
									?>
									<p>
									<label for="id_languages"><?php echo $lang['form_label_language'];?></label>
									<select name="language_id">
									<?php foreach($me['language_ids'] as $key => $i): 
									if (isset($lang['arr_lang_name'][$i])) {
										?>
										<option value="<?php echo $i;?>" <?php if($me['language_id'] == $i) echo "selected=\"selected\"";?>><?php echo $lang['arr_lang_name'][$i];?></option>
										<?php 
									}
									endforeach;
									?>
									</select>
									</p>
									<?php }?>
								</td>
							</tr>
							<tr>
								<td colspan="3">
									<?php
									if (!empty($library['library_page_name'])) {
									?>
									<input type="hidden" name="library_page_name" value="<?php echo $library['library_page_name'];?>" />
									<?php echo $lang['form_label_wiki_page'] . ": " . $library['library_page_name'];?><br />
									
									<?php
									}
									else {
									?>
									<p>
									<?php echo $lang['txt_wiki_intro'];?><br />
									</p>
									<p>
									<label for="id_wiki_page"><?php echo $lang['form_label_wiki_page'];?></label>
									<input id="id_wiki_page" type="text" class="input" name="library_page_name" size="30" value="<?php if (!empty($library['library_page_name'])) { echo $library['library_page_name'];} elseif (isset($library['wiki_page'])) { echo $library['wiki_page'];}?>" /><br />
									</p>
									<?php }?>

									<?php
									if (isset($group) && $this->group_acs->checkPermission($resource_ids['group']['library'], $privilege_ids['allow_lib_default'])) { //resourece_id, Priv_id
										$allow_default_display = 1;
									}
									elseif (!isset($group) && $this->user_acs->checkPermission($resource_ids['node']['library'], $privilege_ids['allow_lib_default'])) { //resourece_id, Priv_id
										$allow_default_display = 1;
									
									}
									
									if (isset($library['library_default']) && $library['library_default'] > 0) {
									?>
									<input type="hidden" name="library_default" value="1" />
									<?php
									}
									elseif (isset($allow_default_display)) {
									?>
									<p>
									<label for="id_default"><?php echo $lang['txt_default'];?></label>
									<input type="checkbox" name="library_default" value="1" />
									</p>
									<?php }?>
								</td>
							</tr>
						</table>
						</fieldset>

						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />

						<fieldset>
						<legend><?php echo $lang['txt_header_2'];?></legend>
						<p>
						<?php echo $lang['txt_detail_intro'];?><br />
						</p>

						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />

						<table border="0" cellspacing="0" cellpadding="2">
							<tr>
								<td valign="top">
									<label for="id_library_body"><?php echo $lang['form_body'];?></label><br />
								</td>
								<td valign="middle" id="gui_wiki" align="right" nowrap="nowrap">
									<script language="JavaScript" type="text/javascript" src="js/gui_wiki.js"></script>&nbsp;<br />
								</td>
								<td width="1" valign="top">
									<select class="gui_select" onChange="javascript:insertTags('[', ' link name here]', this.value);">
										<option value="0"><?php echo $lang['txt_wikipagenames'];?></option>
										<?php
										if (isset($wikipages)) {
										foreach($wikipages as $key => $i):
										?>
										<option><?php echo $i;?></option>
										<?php
										endforeach;
										}
										?>
									</select>
									<br />
								</td>
								<td width="1">
									<script language="JavaScript" type="text/javascript">
									function fileSuffixCheck (filename) {
										
										var suffix = filename.substring(filename.length-3);
										
										if (suffix=='jpg' || suffix=='png' || suffix=='gif') {
											var wikiTag = "Image ";
											var thumb = "";
										}
										else {
											var wikiTag = "File ";
											var thumb = " thumb=1";
										}
										
										insertTags('[['+wikiTag , filename+thumb+']]', '')
									}
									</script>
									
									<select class="gui_select" onChange="javascript:fileSuffixCheck(this.value);">
										<option value="0"><?php echo $lang['txt_filenames'];?></option>
										<?php
										if (isset($filenames)) {
										foreach($filenames as $key => $i):
										?>
										<option><?php echo $i['file_name'] . "." . $i['file_suffix'];?></option>
										<?php
										endforeach;
										}
										?>
									</select>
									<br />
								</td>
							</tr>
							<tr>
								<td align="right" colspan="4">
									<textarea id="id_library_body" name="library_body" cols="75" rows="10" onchange="textChanged = true;" tabindex="1"><?php if (isset($library['library_body'])) { echo $library['library_body'];}?></textarea><br />
									<script language="JavaScript" type="text/javascript">
										var txtarea = document.frm.library_body;
									</script>
								</td>
							</tr>
							<tr>
								<td align="right" colspan="4">
									<input type="submit" class="input_submit" name="preview" value="<?php echo $lang['sub_preview'];?>" />
									
									<?php
									if (isset($allow_spellcheck)) {
									?>
									&nbsp;&nbsp;
									<input type="button" class="input_submit" value="<?php echo $lang['sub_check_spelling'];?>" onClick="openSpellChecker();" />
									<?php }?>
									<br />
								</td>
							</tr>
						</table>
						
						<?php
						if (!empty($library['library_body_preview'])) {
						?>
						
						<p>
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						</p>
						
						<p>
							<?php echo $lang['form_label_preview'];?><br />
						</p>
						
						<p>
							<?php echo $library['library_body_preview'];?><br />
						</p>
						<?php }?>
						
						</fieldset>

					</td>
					<td>
						<img src="<?php echo $templatePath;?>img/pixel.png" width="10" height="1" alt="" /><br />
					</td>
					<td valign="top" width="200">
						<fieldset>
						<legend><?php echo $lang['txt_header_3'];?></legend>
						<p>
						<?php echo $lang['txt_image_intro'];?><br />
						</p>

						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />

						<?php
						if (isset($images)) {
						?>
						<p>
						<?php echo $lang['form_label_file'];?></label><br />
						</p>

						<div>
						<p>
						<select id="id_file_id" size=4 name="file_id" onChange='javascript:setimg(this)'>
						<option value="0" selected="selected"><?php echo $lang['txt_none'];?></option>
						<?php
						$img_divs = "";
						foreach($images as $key => $i):
						$display_state = "none";
						$selected = "";
						if (isset($library['file_id']) && $library['file_id'] == $i['file_id']) {
						    $selected = "selected=\"selected\"";
							$display_state = "block";
						}
						?>
						<option value="<?php echo $i['file_id'];?>" <?php echo $selected;?>><?php echo $i['file_name'];?></option>
						<?php
						$img_divs .= "<div style=\"display:" . $display_state . ";\" id=img" . $i['file_id'] . "><img src=\"get_file.php?file=" . $i['file'] . "\" border=\"0\" class=\"picture\" /><br />" . $i['file_title'] . "</div>";
						endforeach;
						?>
						</select>
						</p>
						</div>
						<?php echo $img_divs;?>
						<?php }?>
						</fieldset>

						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" /><br />

						<fieldset>
						<legend><?php echo $lang['txt_header_4'];?></legend>
						<p>
						<?php echo $lang['txt_publishing_intro'];?><br />
						</p>

						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />

						<?php
						//find out what value rsp has

						if (isset($library['rsp'])) {
							foreach($library['rsp'] as $key => $rsp):
								if ($rsp['level_id'] == $rspconfig['rsp_level']['node']) {
									$rsp_node = 1;
									$rsp_degree = $rsp['degree_id'];
									$rsp_node_featured = $rsp['rsp_featured'];
								}
								elseif ($rsp['level_id'] == $rspconfig['rsp_level']['public']) {
									$rsp_public = 1;
									$rsp_public_featured = $rsp['rsp_featured'];
								}
								elseif ($rsp['level_id'] == $rspconfig['rsp_level']['group']['home']) {
									$rsp_group_home = 1;
								}
							endforeach;
						}
						?>
						
						<script type="text/javascript">
						function setNodeAll(id) {
							if (id.checked) {
								document.getElementById('id_node_id').checked=true;
							}
						}
						function setPub(id) {
							if (id.checked) {
								document.getElementById('id_level_id_public').checked=true;
							}
						}
						function setPublishingOff() {
							document.getElementById('id_node_featured').checked=false;

						}
						function setPubPublishingOff() {
							document.getElementById('id_public_featured').checked=false;

						}
						</script>
						
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
							<?php
							if (isset($group)) {
							if ($this->group_acs->checkPermission($resource_ids['group']['rsp'], $privilege_ids['allow_rsp_public'])) { //resource_id, Priv_id
								if ($rspconfig['public']['auto_publish'] == 1) {
									$txt_rsp_public = $lang['txt_publish_auto_public_help'];
								}
								else {
									$txt_rsp_public = $lang['txt_publish_public_help'];
								}?>
							<tr>
								<td valign="top">
									<input id="id_allow_rsp_public" type="checkbox" name="rsp_public" class="checkbox" value="1" <?php if (isset($rsp_public) && $rsp_public == 1) { echo "checked=\"checked\"";}?> />
								</td>
								<td valign="top">
									<label style="width:100%" for="id_allow_rsp_public"><?php echo $txt_rsp_public;?></label><br />
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="3" alt="" /><br />
								</td>
							<tr>
							<?php 
							}
							if ($this->group_acs->checkPermission($resource_ids['group']['rsp'], $privilege_ids['allow_rsp_node'])) { //resource_id, Priv_id
								if ($rspconfig['node']['auto_publish'] == 1) {
									$txt_rsp_node = $lang['txt_publish_auto_node_help'];
								}
								else {
									$txt_rsp_node = $lang['txt_publish_node_help'];
								}
							?>
							<tr>
								<td valign="top">
									<input id="id_allow_rsp_node" type="checkbox" name="rsp_node" class="checkbox" value="1" <?php if (isset($rsp_node) && $rsp_node == 1) { echo "checked=\"checked\"";}?> />
								</td>
								<td valign="top">
									<label style="width:100%" for="id_allow_rsp_node"><?php echo $txt_rsp_node;?></label><br />
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="3" alt="" /><br />
								</td>
							<tr>
							<?php
							}

							if ($this->group_acs->checkPermission($resource_ids['group']['rsp'], $privilege_ids['allow_rsp_group_home'])) { //resource_id, Priv_id
								if ($group['group_rsp_auto_publish'] == 1) {
									$txt_rsp_group = $lang['txt_publish_auto_group_help'];
								}
								else {
									$txt_rsp_group = $lang['txt_publish_group_help'];
								}
							?>
							<tr>
								<td valign="top">
									
									<input id="id_allow_rsp_group" type="checkbox" name="rsp_group" class="checkbox" value="1" <?php if (isset($rsp_group_home) && $rsp_group_home == 1) { echo "checked=\"checked\"";}?> /><br />
								</td>
								<td valign="top">
									<label style="width:100%" for="id_allow_rsp_group"><?php echo $txt_rsp_group;?></label><br />
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="3" alt="" /><br />
								</td>
							<tr>
							<?php } ?>
							<?php
							}
							else {
							?>
							<tr>
								<td width="1" valign="middle">
									<input type="radio" class="checkbox" name="rsp_node" value="" checked="checked" onClick="javascript:setPublishingOff();" /><br />
								</td>
								<td valign="middle">
									<?php echo $lang['form_just_me'];?><br />
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="3" alt="" /><br />
								</td>
							<tr>
							<?php
							if ($this->user_acs->checkPermission($resource_ids['node']['rsp'], $privilege_ids['allow_rsp_node'])) { //resource_id, Priv_id
							$selected="";
							if (isset($rsp_node) && empty($rsp_degree)) {
								$selected=" checked=\"checked\"";
							}
							?>
							<tr>
								<td valign="middle">
									<input id="id_node_id" type="radio" class="checkbox" name="rsp_node" value="all"<?php echo $selected;?> /><br />
								</td>
								<td valign="middle">
									<?php echo $lang['txt_publish_all'];?><br />
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="3" alt="" /><br />
								</td>
							<tr>
							<?php }?>
							
							<?php
							if ($this->user_acs->checkPermission($resource_ids['node']['rsp'], $privilege_ids['allow_rsp_public'])) { //resource_id, Priv_id
							$selected="";
							if (isset($rsp_public)) {
								$selected=" checked=\"checked\"";
							}
							?>
							<tr>
								<td valign="top">
									<input type="checkbox" id="id_level_id_public" name="rsp_public" value="1"<?php echo $selected;?> class="checkbox" onClick="javascript:setPubPublishingOff();" /><br />
								</td>
								<td>
									<?php echo $lang['form_public'];?><br />
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="3" alt="" /><br />
								</td>
							<tr>
							<?php }?>
							<?php }?>
							
							
							<?php
							// write the featured item checkboxes
							if ($this->user_acs->checkPermission($resource_ids['node']['rsp'], $privilege_ids['allow_rsp_node_featured'])) { //resource_id, Priv_id
							$selected="";
							if (!empty($rsp_node_featured)) {
								$selected=" checked=\"checked\"";
							}
							
							if ($rspconfig['node']['auto_publish'] == 1) {
								$txt_rsp_node = $lang['txt_publish_auto_node_help'];
							}
							else {
								$txt_rsp_node = $lang['txt_publish_node_help'];
							}
							?>
							<tr>
								<td valign="top">
									<input type="checkbox" id="id_node_featured" name="rsp_node_featured" value="1"<?php echo $selected;?> class="checkbox" onClick="javascript:setNodeAll(this);" /><br />
								</td>
								<td>
									<?php echo $txt_rsp_node;?><br />
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="3" alt="" /><br />
								</td>
							<tr>
							<?php
							}

							if ($this->user_acs->checkPermission($resource_ids['node']['rsp'], $privilege_ids['allow_rsp_public_featured'])) { //resource_id, Priv_id
							$selected="";
							if (!empty($rsp_public_featured)) {
								$selected=" checked=\"checked\"";
							}
							
							if ($rspconfig['public']['auto_publish'] == 1) {
								$txt_rsp_public = $lang['txt_publish_auto_public_help'];
							}
							else {
								$txt_rsp_public = $lang['txt_publish_public_help'];
							}
							?>
							<tr>
								<td valign="top">
									<input type="checkbox" id="id_public_featured" name="rsp_public_featured" value="1"<?php echo $selected;?> class="checkbox" onClick="javascript:setPub(this);" /><br />
								</td>
								<td>
									<?php echo $txt_rsp_public;?><br />
								</td>
							</tr>
							<?php }?>
						</table>
						</fieldset>

						<script type="text/javascript">
						//check php did not set either of the publishing buttons
						if (document.getElementById('id_public_featured').checked) {
							document.getElementById('id_node_id').checked=true;
						}
						if (document.getElementById('id_node_featured').checked) {
							document.getElementById('id_node_id').checked=true;
						}
						</script>

						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" /><br />
						
						<fieldset>
						<legend><?php echo $lang['txt_header_7'];?></legend>
						
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
							<tr>
								<td valign="top">
									<?php
									$selected = "";
									// if no library we are adding and we check the box
									if (isset($library['library_allow_comments']) && $library['library_allow_comments'] == 1) {
										$selected = "checked=\"checked\"";
									}
									elseif (!isset($library)) {
										$selected = "checked=\"checked\"";
									}
									?>
									<input id="id_allow_comments" type="checkbox" name="library_allow_comments" class="checkbox" value="1" <?php echo $selected;?> /><br />
								</td>
								<td valign="top">
									<label style="width:100%" for="id_allow_comments"><?php echo $lang['form_label_comments'];?></label><br />
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="3" alt="" /><br />
								</td>
							<tr>
							<tr>
								<td valign="top">
									<input id="id_track" type="checkbox" name="ins_mark" class="checkbox" value="1" <?php if (!empty($library['bookmark']['bookmark_notify'])) { echo "checked=\"checked\"";}?> /><br />
								</td>
								<td valign="top">
									<label style="width:100%" for="id_track"><?php echo $lang['form_label_track'];?></label><br />
								</td>
							</tr>
						</table>
						</fieldset>

						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" /><br />

						<fieldset>
						<legend><?php echo $lang['txt_header_5'];?></legend>
						<p>
						<?php echo $lang['txt_save_intro'];?><br />
						</p>

						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />

						<input type="submit" class="input_submit" name="save" class="button_urgent" value="<?php echo $lang['sub_save'];?>" />&nbsp;
						<input type="submit" class="input_submit" name="save_go" class="button_urgent" value="<?php echo $lang['sub_save_go'];?>" /><br />

						</fieldset>
					</td>
				</tr>
			</table>
		</div>
	</div>
</div>
	
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
</form>
