<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

//ACS check
if (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['skills'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resource_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'skl_view.lang.php');
require_once($languageArrayPath . 'arr_skill.lang.php');


// SETUP SKILLS ---------------------------------------------------------
require_once('class/Skill.class.php');
$skill = new Skill($db);

if (isset($me['user_id'])) {
	$skill->user_id = $me['user_id'];
}

//RECEIVE POST AND PROCESS ---------------------------------------------------------
if (!empty($frmdata)) {
	$frmdata['skill_name'] = htmlspecialchars($frmdata['skill_name']);
	$frmdata['skill_experience'] = htmlspecialchars($frmdata['skill_experience']);
	
	if (isset($frmdata['insert_skill'])) {
		$skill->insertSkill($frmdata);
	}
	elseif (isset($frmdata['update_skill'])) {
		$skill->updateSkill($frmdata);
	}
	elseif (isset($frmdata['delete_skill'])) {
		$del_arr = array($frmdata['skill_id']);
		$skill->deleteSkills($del_arr);
	}
}
	
if (!empty($_REQUEST['skill_id'])) {
	$skill->skill_id = $_REQUEST['skill_id'];
	$output_skill = $skill->selSkill();
}

$output_skills = $skill->selSkills(null, 1);


//move to template
if (!empty($output_skill)) {
	$body->set('skill', $output_skill);
}

if (!empty($output_skills)) {
	$body->set('skills', $output_skills);
}

include "inc/footer.inc.php";

?>
