<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "config/config_aroundme.inc.php";
include "config/config_acs.inc.php";
include "inc/functions.inc.php";


//SETUP RSS FEED
include('class/FeedCreator.class.php');
$rss = new UniversalFeedCreator();
$rss->useCached();
$rss->link = $_SERVER['HTTP_HOST'];
$rss->syndicationURL = $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];

//url
$url = "http://" . $_SERVER['HTTP_HOST'];
$url .= dirname ($_SERVER['PHP_SELF']);


//SETUP DATE -----------------------------------------------------------------------
require_once('class/Date.class.php');
$date = new Date();

	
// SETUP DATABASE -----------------------------------------------------------------------
require_once('class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($c_node['db']['driver']);
if ($db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db'])) {
	$db->prefix = $c_node['db']['prefix'];
	
	
	
	//SETUP BLOG -----------------------------------------------------
	require_once('class/Blog.class.php');
	$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], null);
	$blog->rsp_level_id = $c_node['rsp']['rsp_level']['public'];
	$blog->rsp_status_id = $c_node['rsp']['status']['live'];
	$blog->limit = 10;
	
	
	//get library items -----------------------------------------------------
	require_once('class/Library.class.php');
	$library = new Library($db, $c_node['rsp']['item_type']['library'], null);
	$library->rsp_level_id = $c_node['rsp']['rsp_level']['public'];
	$library->rsp_status_id = $c_node['rsp']['status']['live'];
	$library->limit = 10;
	
	
	//get polls  -----------------------------------------------------
	require_once('class/Poll.class.php');
	$poll = new Poll($db, $c_node['rsp']['item_type']['poll'], $date);
	$poll->order_by = "p.poll_start_datetime desc";
	$poll->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$poll->rsp_status_id = $c_node['rsp']['status']['live'];
	$poll->limit = 10;
	
	
	//get quizzes  -----------------------------------------------------
	require_once('class/Quiz.class.php');
	$quiz = new Quiz($db, $c_node['rsp']['item_type']['quiz']);
	$quiz->order_by = "q.quiz_start_datetime desc";
	$quiz->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$quiz->rsp_status_id = $c_node['rsp']['status']['live'];
	$quiz->limit = 10;
	
	
	//get subjects  -----------------------------------------------------
	require_once('class/Forum.class.php');
	$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], null);
	$forum->rsp_level_id = $c_node['rsp']['rsp_level']['public'];
	$forum->rsp_status_id = $c_node['rsp']['status']['live'];
	$forum->limit = 10;
	
	$feedurl = "";
	
	// we either got a password in which case we display their group items 
	// plus public or we just get public items.
	
	if (isset($_REQUEST['feed'])) {
		//pull vars out of feed string
		$feed_user_pass = $_REQUEST['feed'];
		$user_id = substr($feed_user_pass,6);
		$feedpass = substr($feed_user_pass,0,6);
		
		//we check that this person is who they say they are
		$query = "
			SELECT user_id, language_id 
			FROM " . $db->prefix . "_user
			WHERE 
			user_id=" . $user_id . " AND 
			user_feed_password=" . $db->qstr($feedpass, get_magic_quotes_gpc())
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields['user_id'])) {//I am the correct user for this feed
			
			//get languages file
			$page_name_full = basename($_SERVER['REQUEST_URI']);
			$page_name = explode(".",$page_name_full);
			$languagePath = "language/" . $result->fields['language_id'] . "/" . $c_node['node']['template_default_name'] . "/";
			require_once($languagePath . $page_name[0] .'.lang.php');
			
			//SETUP RSS FEED
			$rss->title = $lang['txt_title'];
			$rss->description = $lang['txt_description'];
			
			$blog->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
			$library->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
			$poll->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
			$forum->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
			$quiz->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
			
			$feedurl = "feed=" . $feed_user_pass . "&";
		}
	}
	
	
	if (!isset($lang)) {
		//get languages file
		$page_name_full = basename($_SERVER['REQUEST_URI']);
		$page_name = explode(".",$page_name_full);
		$languagePath = "language/" . $c_node['node']['language']['default'] . "/" . $c_node['node']['template_default_name'] . "/";
		require_once($languagePath . $page_name[0] .'.lang.php');
		
		//SETUP RSS FEED
		$rss->title = $lang['txt_title'];
		$rss->description = $lang['txt_description_public'];
	}
	
	$output_blogs = $blog->selBlogs();
	$output_library_items = $library->selLibraryItems();
	$output_polls = $poll->selPolls();
	$output_subjects = $forum->selSubjects();
	$output_quizzes = $quiz->selQuizzes();
	
	//OUTPUT RSS
	if (isset($output_subjects)) {
		$frm_url = $url . "/frm_view.php?" . $feedurl . "subject_id=";
		
		foreach($output_subjects as $key => $i):
			$item = new FeedItem();
			$item->title = $i['subject_title'];
			$item->link = $frm_url . $i['subject_id'];
			$item->description = $i['subject_synopsis'];
			$item->date = $db->UnixDate($i['subject_create_datetime']);
			$item->source = $_SERVER['HTTP_HOST']."/";
			$item->author = "";
			
			$rss->addItem($item);
		endforeach;
	}
	
	if (isset($output_blogs)) {
		$blog_url = $url . "/blg_view.php?" . $feedurl . "blog_id=";
		
		foreach($output_blogs as $key => $i):
			$item = new FeedItem();
			$item->title = $i['blog_title'];
			$item->link = $blog_url . $i['blog_id'];
			$item->description = $i['blog_synopsis'];
			$item->date = $db->UnixDate($i['blog_create_datetime']);
			$item->source = $_SERVER['HTTP_HOST']."/";
			$item->author = "";
			
			$rss->addItem($item);
		endforeach;
	}
	
	if (isset($output_polls)) {
		$poll_url = $url . "/pol_view.php?" . $feedurl . "poll_id=";
		
		foreach($output_polls as $key => $i):
			$item = new FeedItem();
			$item->title = $i['poll_question'];
			$item->link = $poll_url . $i['poll_id'];
			$item->description = $i['poll_question'];
			$item->date = $db->UnixDate($i['poll_create_datetime']);
			$item->source = $_SERVER['HTTP_HOST']."/";
			$item->author = "";
			
			$rss->addItem($item);
		endforeach;
	}
	
	if (isset($output_quizzes)) {
		$poll_url = $url . "/quz_view.php?" . $feedurl . "quiz_id=";
		
		foreach($output_quizzes as $key => $i):
			$item = new FeedItem();
			$item->title = $i['quiz_title'];
			$item->link = $poll_url . $i['quiz_id'];
			$item->description = $i['quiz_synopsis'];
			$item->date = $db->UnixDate($i['quiz_create_datetime']);
			$item->source = $_SERVER['HTTP_HOST']."/";
			$item->author = "";
			
			$rss->addItem($item);
		endforeach;
	}
	
	if (isset($output_library_items)) {
		$library_url = $url . "/lib_view.php?" . $feedurl . "library_id=";
		
		foreach($output_library_items as $key => $i):
			$item = new FeedItem();
			$item->title = $i['library_title'];
			$item->link = $library_url . $i['library_id'];
			$item->description = $i['library_synopsis'];
			$item->date = $db->UnixDate($i['library_create_datetime']);
			$item->source = $_SERVER['HTTP_HOST']."/";
			$item->author = "";
			
			$rss->addItem($item);
		endforeach;
	}
	
	//TIDY UP
	$db->Close();
	
	$rss->saveFeed($c_node['rss']['output'], "cache/feed.xml"); 

}
else {
	//SETUP RSS FEED WHERE PASSWORD WAS NOT RECEIVED
	$rss->title = "Error";
	$rss->description = "Your password is incorrect. Please change your membership password to rectify this.";
	$rss->saveFeed($c_node['rss']['output'], "cache/feed/feed_tmp.xml"); 
}

?>