<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

if (!empty($_POST['group_id'])) { // page under group section
    //setup group
	$group_id = $_REQUEST['group_id'];
	include "inc/header_group.inc.php";
	require_once($languagePath . 'grp_common.lang.php');
}

// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languageArrayPath . 'arr_rsp.lang.php');
require_once($languagePath . 'sn_common.lang.php');

// setup images
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


if (!isset($_REQUEST['view'])) {
	$_REQUEST['view'] = "content";
}


if (isset($_REQUEST['search_show']) && $_REQUEST['search_show'] != "any") {
	// todays date minus value = search from date
	$search_date  = mktime(0, 0, 0, date("m"), date("d")-$_REQUEST['search_show'], date("Y"));
}


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('wikilink');


// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, null);
$comment->wiki = $wiki;

if (isset($group_id) {
	$comment->group_id = $group_id;
}


// SETUP TAGS -----------------------------------------------------------
require_once('class/Tag.class.php');
$tag = new Tag($db, null);
$tag->order_by = "t.tag_body desc";

if (isset($group_id) {
	$tag->group_id = $group_id;
}


// SETUP GROUPS -----------------------------------------------------------
require_once($languageArrayPath . 'arr_group.lang.php');
require_once('class/Group.class.php');
$group = new Group($db, $file);
$group->registration_types = $c_node['group']['registration_type'];
$group->group_visibility = 1;


// SETUP BLOGS -----------------------------------------------------------
require_once('class/Blog.class.php');
$blog = new Blog($db, null, $file);
$blog->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
$blog->rsp_status_id = $c_node['rsp']['status']['live'];
$blog->item_types = $c_node['rsp']['item_type'];
$blog->me = $me;

if (isset($group_id) {
	$blog->group_id = $group_id;
}


// SETUP LIBRARY ITEMS ------------------------------------------------
require_once('class/Library.class.php');
$library = new Library($db, null, $file);
$library->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
$library->rsp_status_id = $c_node['rsp']['status']['live'];
$library->item_types = $c_node['rsp']['item_type'];
$library->me = $me;

if (isset($group_id) {
	$library->group_id = $group_id;
}


// SETUP POLLS ---------------------------------------------------------
require_once('class/Poll.class.php');
$poll = new Poll($db, null);
$poll->order_by = "p.poll_start_datetime desc";
$poll->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
$poll->rsp_status_id = $c_node['rsp']['status']['live'];
$poll->item_types = $c_node['rsp']['item_type'];
$poll->me = $me;

if (isset($group_id) {
	$poll->group_id = $group_id;
}


// SETUP QUIZZES -------------------------------------------------------
require_once('class/Quiz.class.php');
$quiz = new Quiz($db, null, $file);
$quiz->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
$quiz->rsp_status_id = $c_node['rsp']['status']['live'];
$quiz->item_types = $c_node['rsp']['item_type'];
$quiz->me = $me;

if (isset($group_id) {
	$quiz->group_id = $group_id;
}


// SETUP FORUM -------------------------------------------------------
require_once('class/Forum.class.php');
$forum = new Forum($db, null, $file);
$forum->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
$forum->rsp_status_id = $c_node['rsp']['status']['live'];
$forum->item_types = $c_node['rsp']['item_type'];
$forum->me = $me;

if (isset($group_id) {
	$forum->group_id = $group_id;
}


// SETUP SCHEDULE ----------------------------------------------------
require_once('class/Schedule.class.php');
require_once($languageArrayPath . 'arr_schedule.lang.php');
$schedule = new Schedule($db, $c_node['rsp']['item_type']['schedule'], $date, $file);
$schedule->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
$schedule->rsp_status_id = $c_node['rsp']['status']['live'];
$schedule->item_types = $c_node['rsp']['item_type'];
$schedule->me = $me;
$schedule->schedule_config = $c_node['schedule'];

if (isset($group_id) {
	$schedule->group_id = $group_id;
}


if ($_REQUEST['view'] == "tags") {
	if (!empty($_REQUEST['tag'])) { // search for a tag
		$tag->ignore_level_id = 1;
		$output_tags = $tag->selTags(null, null, $_REQUEST['tag']);
		
		// GET GROUPS --------------------------------------------
		if (!empty($output_tags)) {
			foreach ($output_tags as $key => $i):
				if ($i['rsp_item_type_id'] == $c_node['rsp']['item_type']['group']) {
					$output_tags[$key]['item_id'] = $i['group_id'];
					$group->group_ids[] = $i['group_id'];
				}
			endforeach;
		}
		
		if (!empty($group->group_ids)) {
			$output_groups = $group->getGroups();
		}
		
		
		// GET BLOGS --------------------------------------------
		if (!empty($output_tags)) {
			foreach ($output_tags as $key => $i):
				if ($i['rsp_item_type_id'] == $c_node['rsp']['item_type']['blog']) {
					$blog->blog_ids[] = $i['item_id'];
				}
			endforeach;
		}
		
		if (!empty($blog->blog_ids)) {
			$blog->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
			$output_blogs = $blog->selBlogs();
		}
		
		
		// GET LIBRARY ITEMS ------------------------------------
		if (!empty($output_tags)) {
			foreach ($output_tags as $key => $i):
				if ($i['rsp_item_type_id'] == $c_node['rsp']['item_type']['library']) {
					$library->library_ids[] = $i['item_id'];
				}
			endforeach;
		}
		
		if (!empty($library->library_ids)) {
			$library->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
			$output_library_items = $library->selLibraryItems();
		}
		
		
		// GET POLLS -------------------------------------------
		if (!empty($output_tags)) {
			foreach ($output_tags as $key => $i):
				if ($i['rsp_item_type_id'] == $c_node['rsp']['item_type']['poll']) {
					$poll->poll_ids[] = $i['item_id'];
				}
			endforeach;
		}
		
		if (!empty($poll->poll_ids)) {
			$poll->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
			$output_polls = $poll->selPolls();
		}
		
		
		// GET QUIZZES -------------------------------------------
		if (!empty($output_tags)) {
			foreach ($output_tags as $key => $i):
				if ($i['rsp_item_type_id'] == $c_node['rsp']['item_type']['quiz']) {
					$quiz->quiz_ids[] = $i['item_id'];
				}
			endforeach;
		}
		
		if (!empty($quiz->quiz_ids)) {
			$quiz->rsp_item_type_id = $c_node['rsp']['item_type']['quiz'];
			$output_quizzes = $quiz->selQuizzes();
		}
		
		
		// GET SUBJECTS -------------------------------------------
		if (!empty($output_tags)) {
			foreach ($output_tags as $key => $i):
				if ($i['rsp_item_type_id'] == $c_node['rsp']['item_type']['forum']) {
					$forum->subject_ids[] = $i['item_id'];
				}
			endforeach;
		}
		
		if (!empty($forum->subject_ids)) {
			$forum->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
			$output_subjects = $forum->selSubjects();
		}
		
		
		// GET SCHEDULE -------------------------------------------
		if (!empty($output_tags)) {
			foreach ($output_tags as $key => $i):
				if ($i['rsp_item_type_id'] == $c_node['rsp']['item_type']['schedule']) {
					$schedule->schedule_ids[] = $i['item_id'];
				}
			endforeach;
		}
		
		if (!empty($schedule->schedule_ids)) {
			$schedule->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
			$output_schedule_items = $schedule->selScheduleItems();
		}
		
		
		// GET USERS -------------------------------------------
		if (!empty($output_tags)) {
			foreach ($output_tags as $key => $i):
				if ($i['rsp_item_type_id'] == $c_node['rsp']['item_type']['network'] && $i['user_id'] == $me['user_id']) {
					$user->user_ids[] = $i['item_id'];
				}
			endforeach;
		}
		
		if (!empty($user->user_ids)) {
			$user->file = $file;
			$user->user_id = $me['user_id'];
			$user->item_types = $c_node['rsp']['item_type'];
			$output_users = $schedule->selUsers();
		}
	}
	else {
		// get the tag cloud
		unset($tag->order_by);
		if (isset($group_id)) {
			$tag->group_id = $group_id;
			$output_group_tags = $tag->selTags();
		}
		elseif (isset($me['user_id'])) {
			$tag->user_id = $me['user_id'];
			$tag->rsp_item_type_id = $c_node['rsp']['item_type']['network'];
			$output_item_tags = $tag->selTags(1, 1);
		}
	}
	
	$display = "tags";
}
elseif ($_REQUEST['view'] == "comments") {
	
	if (!empty($frmdata['search_text'])) {
		$search_text = trim($frmdata['search_text']);
	}
	
	if (isset($search_date)) {
		$comment->search_from_date = $search_date;
	}
	
	
	$comment->wikiformat = "Plain";
	
	// we select the comments
	if (isset($_REQUEST['search_type'])) {
		if ($_REQUEST['search_type'] == "received" && isset($me['user_id'])) {
			// we get the comments that I have received against my work
			$comment->no_user_id = $me['user_id'];
			$comment->item_user_id = $me['user_id'];
			$comment->order_by = "c.comment_create_datetime desc";
		}
		elseif (isset($_REQUEST['search_type']) && $_REQUEST['search_type'] == "my" && isset($me['user_id'])) {
			// we get the comments that I have left
			$comment->user_id = $me['user_id'];
			$comment->order_by = "c.comment_create_datetime desc";
			
		}
		else {
			// all comments
			$comment->order_by = "c.comment_create_datetime desc";
		}
		
		if (!empty($search_text)) {
			$output_comments = $comment->selComments(null, $search_text);
		}
		else {
			$output_comments = $comment->selComments();
		}
	}
	
	$display = "comments";
}
elseif ($_REQUEST['view'] == "directory") {
	// search the directory for people or skills
	if (isset($frmdata['search_text'])) {
		if (strlen(trim($frmdata['search_text'])) >= 3) {
			$search_text = trim($frmdata['search_text']);
			
			$user->order_by = "p.profile_nic";
			$user->file = $file;
			$output_users = $user->selUsers(null, $c_node['user']['preference']['show_in_directory'], $search_text);
			
		}
		else {
			$GLOBALS['am_error_log'][] = array(41, null, null);
		}
	}
	$display = "directory";
}
else { // content search
	if (isset($frmdata['search_text'])) {
		if (strlen(trim($frmdata['search_text'])) >= 3) {
			$search_text = trim($frmdata['search_text']);
			
			// we select the comments
			if (isset($_REQUEST['search_type']) && $_REQUEST['search_type'] == "blog") {
				$blog->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
				$output_blogs = $blog->selBlogs($search_text);
				
				if (!empty($output_blogs)) {
					unset ($lang['err_search']);
				}
			}
			elseif (isset($_REQUEST['search_type']) && $_REQUEST['search_type'] == "subjects") {
				$forum->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
				$output_subjects = $forum->selSubjects($search_text);
				
				if (!empty($output_subjects)) {
					unset ($lang['err_search']);
				}
			}
			elseif (isset($_REQUEST['search_type']) && $_REQUEST['search_type'] == "schedule_items") {
				$schedule->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
				$output_schedule_items = $schedule->selScheduleItems($search_text);
				
				if (!empty($output_schedule_items)) {
					unset ($lang['err_search']);
				}
			}
			elseif (isset($_REQUEST['search_type']) && $_REQUEST['search_type'] == "polls") {
				$poll->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
				$output_polls = $poll->selPolls($search_text);
				
				if (!empty($output_polls)) {
					unset ($lang['err_search']);
				}
			}
			elseif (isset($_REQUEST['search_type']) && $_REQUEST['search_type'] == "groups") {
				$output_groups = $group->getGroups($search_text);
				
				if (!empty($output_groups)) {
					unset ($lang['err_search']);
				}
			}
			elseif (isset($_REQUEST['search_type']) && $_REQUEST['search_type'] == "library") {
				$library->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
				$output_library_items = $library->selLibraryItems($search_text);
				
				if (!empty($output_library_items)) {
					unset ($lang['err_search']);
				}
			}
			elseif (isset($_REQUEST['search_type']) && $_REQUEST['search_type'] == "quizzes") {
				$quiz->rsp_item_type_id = $c_node['rsp']['item_type']['quiz'];
				$output_quizzes = $quiz->selQuizzes($search_text);
				
				if (!empty($output_quizzes)) {
					unset ($lang['err_search']);
				}
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array(41, null, null);
		}
	}
	
	$display = "content";
}








/*
if (!empty($_REQUEST['tag'])) {
	
}
elseif (isset($_REQUEST['search_type'])) {
	if ((isset($frmdata['search_text']) && strlen(trim($frmdata['search_text'])) >= 3)) {
		
		if (isset($_REQUEST['search_show']) && $_REQUEST['search_show'] != "any") {
			// todays date minus value = search from date
			$search_date  = mktime(0, 0, 0, date("m"), date("d")-$_REQUEST['search_show'], date("Y"));
			$search_date = $db->DBDate($search_date);
		}
		
		
		
		
		
		// USERS --------------------------------------------------------------
		if (!empty($_REQUEST['tag'])) {
			//setup file
			$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
			$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
			$user->file = $file;
			
			$tag->user_id = $me['user_id'];
			$tag->rsp_item_type_id = $c_node['rsp']['item_type']['network'];
			$output_item_tags = $tag->selTags(null, 1);
	
			$user->user_id = $me['user_id'];
			$user->item_types = $c_node['rsp']['item_type'];
			$output_users = $user->selUsers($_REQUEST['tag']);
		}

*/







// FIND RELATIONS ---------------------------------------------------------
if (!empty($output_users)) {
	
	require_once($languageArrayPath . 'arr_user.lang.php');
	require_once($languagePath . 'sn_list.lang.php');
	//setup social network
	require_once('class/SocialNetwork.class.php');
	$sn = new Socialnetwork($me['user_id'], $db);
	$sn->relation_type_ids = $c_node['user']['relation_type'];
	$sn->status_ids = $c_node['user']['status'];
	
	$output_relation_of_users = $sn->selRelations($me['user_id'], 1);
	$first_degree_network_total = 0;

	if (isset($me['relations'])) {
		$temp = $me['relations'];
	}
	
	
	$output_blocked = $sn->getBlockedUsers();
	
	foreach($output_users as $key => $i):
		//I AM A RELATION TO USER
		$total_friends = array();
		if (!empty($output_relation_of_users)) {
			foreach($output_relation_of_users as $keyr => $r):
				if ($i['user_id'] == $r['user_id']) {
					$output_users[$key]['am_relation_to_them'] = $r;
					unset ($output_relation_of_users[$keyr]);
					
					// can we show network?
					if (!empty($r['relation_show_network'])) {
						$total_friends = $sn->selRelations($i['user_id']);
					}
				}
			endforeach;
		}
		$output_users[$key]['sn_total'] = count($total_friends);
		
		
		// RELATIONS TO ME
		if (!empty($temp)) {
			foreach($temp as $keyr => $r):
				if ($i['user_id'] == $r['user_id_relation']) {
					$output_users[$key]['relation_to'] = $r;
					unset ($temp[$keyr]);
				}
			endforeach;
		}
		
		
		// BLOCKED BY ME
		if (!empty($output_blocked)) {
			foreach($output_blocked as $keyb => $b):
				if ($i['user_id'] == $b['user_id_blocked']) {
					$output_users[$key]['blocked'] = 1;
					unset ($temp[$keyb]);
				}
			endforeach;
		}
		
		
		$tag->item_id = $i['user_id'];
		$output_users[$key]['tags'] = $tag->selTags();
		
	endforeach;
}



//move to template
if (!empty($display)) {
    $tpl->set('display', $display);
    $body->set('display', $display);
}

if (!empty($_REQUEST['tag'])) {
	$body->set('tag', $_REQUEST['tag']);
	$lang['txt_tag_results'] = str_replace("SYS_KEYWORD_SEARCHTXT", $_REQUEST['tag'], $lang['txt_tag_results']);

}
elseif (!empty($search_text)) {
	$body->set('tag', $search_text);
}

if (!empty($output_tags)) {
	$body->set('tags', $output_tags);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_item_tags)) {
	$body->set('item_tags', $output_item_tags);
}

if (!empty($output_schedule_items)) {
	$body->set('schedule_items', $output_schedule_items);
}

if (!empty($output_subjects)) {
    $body->set('subjects', $output_subjects);
}

if (!empty($output_groups)) {
    $body->set('groups', $output_groups);
}

if (!empty($output_blogs)) {
    $body->set('blogs', $output_blogs);
}

if (!empty($output_library_items)) {
    $body->set('library_items', $output_library_items);
}

if (!empty($output_polls)) {
    $body->set('polls', $output_polls);
}

if (!empty($output_quizzes)) {
    $body->set('quizzes', $output_quizzes);
}

if (!empty($output_users)) {
    $body->set('users', $output_users);
}

if (!empty($output_comments)) {
    $body->set('comments', $output_comments);
}

if (!empty($search_text)) {
    $body->set('search', $frmdata);
	$lang['txt_search_results'] = str_replace("SYS_KEYWORD_SEARCHTXT", $search_text, $lang['txt_search_results']);
}

$body->set('rsp_item_type_ids', $c_node['rsp']['item_type']);

include "inc/footer.inc.php";

?>
