<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form action="search.php" method="post" name="frm_view" id="id_frm_view">

<?php
if (isset($display) && $display == "tags") {
?>
<input type="hidden" name="view" value="tags" /><br />

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php
			if (isset($tag)) {
				echo $lang['hdr_search_results'];
			}
			else {
				echo $lang['hdr_tagcloud'];
			}
			?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($tag)) {
				?>
				<p>
					<?php echo $lang['txt_tag_results'];?></br />
				</p>
				<?php }?>
				
				<?php
				if (isset($tags)) {
				// we loop through the tags and list each item
				?>
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
				<?php
				$display_items = trimArray($tags);
				foreach($display_items as $key => $i):
				?>
				<?php
					if ($i['rsp_item_type_id'] == $rsp_item_type_ids['blog']) {
					// we get the blog
					if (isset($blogs)) {
					foreach($blogs as $key => $r):
					if ($i['item_id'] == $r['blog_id']) {
						$item = $r;
						break;
					}
					endforeach;
						
					?>
					<tr>
						<td width="1" rowspan="2">
							<a href="blg_view.php?blog_id=<?php echo $item['blog_id'];?>"><img src="get_file.php?file=<?php echo $item['image']['file'];?>" border="0" alt="<?php echo $item['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top">
							<a href="blg_view.php?blog_id=<?php echo $item['blog_id'];?>"><?php echo $this->date->formatDate($item['blog_create_datetime'], 1);?></a><br />
							<b><?php echo $item['blog_title'];?></b><br />
							<?php echo dots(200, $item['blog_synopsis']);?><br />
						</td>
						<td valign="top" align="right">
							<?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?><br />
						</td>
					</tr>
					<tr>
						<td colspan="2" align="right">
							<?php echo $lang['txt_tag_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['profile_nic'];?></a>, 
							<?php echo $lang['txt_item_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $r['user_id'];?>"><?php echo $r['profile_nic'];?></a><br />
						</td>
					</tr>
					<?php
					}}
					elseif ($i['rsp_item_type_id'] == $rsp_item_type_ids['forum']) {
					// we get the subject
					if (isset($subjects)) {
					foreach($subjects as $key => $r):
					if ($i['item_id'] == $r['subject_id']) {
						$item = $r;
						break;
					}
					endforeach;
						
					?>
					<tr>
						<td width="1" rowspan="2">
							<a href="frm_view.php?subject_id=<?php echo $item['subject_id'];?>"><img src="get_file.php?file=<?php echo $item['image']['file'];?>" border="0" alt="<?php echo $item['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top">
							<a href="frm_view.php?subject_id=<?php echo $item['subject_id'];?>"><?php echo $this->date->formatDate($item['subject_create_datetime'], 1);?></a><br />
							<b><?php echo $item['subject_title'];?></b><br />
							<?php echo dots(200, $item['subject_synopsis']);?><br />
						</td>
						<td valign="top" align="right">
							<?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?><br />
						</td>
					</tr>
					<tr>
						<td colspan="2" align="right">
							<?php echo $lang['txt_tag_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['profile_nic'];?></a>, 
							<?php echo $lang['txt_item_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $r['user_id'];?>"><?php echo $r['profile_nic'];?></a><br />
						</td>
					</tr>
					<?php
					}}
					elseif ($i['rsp_item_type_id'] == $rsp_item_type_ids['group']) {
					// we get the group
					if (isset($groups)) {
					foreach($groups as $key => $r):
					if ($i['item_id'] == $r['group_id']) {
						$item = $r;
						break;
					}
					endforeach;
						
					?>
					<tr>
						<td width="1" rowspan="2">
							<a href="grp_view.php?group_id=<?php echo $item['group_id'];?>"><img src="get_file.php?file=<?php echo $item['image']['file'];?>" border="0" alt="<?php echo $item['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top">
							<a href="grp_view.php?group_id=<?php echo $item['group_id'];?>"><?php echo $this->date->formatDate($item['group_create_datetime'], 1);?></a><br />
							<b><?php echo $item['group_title'];?></b><br />
							<?php echo dots(200, $item['group_synopsis']);?><br />
						</td>
						<td valign="top" align="right">
							<?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?><br />
						</td>
					</tr>
					<tr>
						<td colspan="2" align="right">
							<?php echo $lang['txt_tag_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['profile_nic'];?></a><br />
						</td>
					</tr>
					<?php
					}}
					elseif ($i['rsp_item_type_id'] == $rsp_item_type_ids['library']) {
					// we get the library item
					if (isset($library_items)) {
					foreach($library_items as $key => $r):
					if ($i['item_id'] == $r['library_id']) {
						$item = $r;
						break;
					}
					endforeach;
						
					?>
					<tr>
						<td width="1" rowspan="2">
							<a href="lib_view.php?library_id=<?php echo $item['library_id'];?>"><img src="get_file.php?file=<?php echo $item['image']['file'];?>" border="0" alt="<?php echo $item['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top">
							<a href="lib_view.php?library_id=<?php echo $item['library_id'];?>"><?php echo $this->date->formatDate($item['library_create_datetime'], 1);?></a><br />
							<b><?php echo $item['library_title'];?></b><br />
							<?php echo dots(200, $item['library_synopsis']);?><br />
						</td>
						<td valign="top" align="right">
							<?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?><br />
						</td>
					</tr>
					<tr>
						<td colspan="2" align="right">
							<?php echo $lang['txt_tag_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['profile_nic'];?></a>, 
							<?php echo $lang['txt_item_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $r['user_id'];?>"><?php echo $r['profile_nic'];?></a><br />
						</td>
					</tr>
					<?php
					}}
					elseif ($i['rsp_item_type_id'] == $rsp_item_type_ids['poll']) {
					// we get the library item
					if (isset($polls)) {
					foreach($polls as $key => $r):
					if ($i['item_id'] == $r['poll_id']) {
						$item = $r;
						break;
					}
					endforeach;
						
					?>
					<tr>
						<td width="1" rowspan="2">
							<a href="pol_view.php?poll_id=<?php echo $item['poll_id'];?>"><img src="get_file.php?file=<?php echo $item['image']['file'];?>" border="0" alt="<?php echo $item['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top">
							<a href="pol_view.php?poll_id=<?php echo $item['poll_id'];?>"><?php echo $this->date->formatDate($item['poll_create_datetime'], 1);?></a><br />
							<b><?php echo $item['poll_question'];?></b><br />
						</td>
						<td valign="top" align="right">
							<?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?><br />
						</td>
					</tr>
					<tr>
						<td colspan="2" align="right">
							<?php echo $lang['txt_tag_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['profile_nic'];?></a>, 
							<?php echo $lang['txt_item_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $r['user_id'];?>"><?php echo $r['profile_nic'];?></a><br />
						</td>
					</tr>
					<?php
					}}
					elseif ($i['rsp_item_type_id'] == $rsp_item_type_ids['quiz']) {
					// we get the quiz
					if (isset($quizzes)) {
					foreach($quizzes as $key => $r):
					if ($i['item_id'] == $r['quiz_id']) {
						$item = $r;
						break;
					}
					endforeach;
						
					?>
					<tr>
						<td width="1" rowspan="2">
							<a href="quz_view.php?quiz_id=<?php echo $item['quiz_id'];?>"><img src="get_file.php?file=<?php echo $item['image']['file'];?>" border="0" alt="<?php echo $item['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top">
							<a href="quz_view.php?quiz_id=<?php echo $item['quiz_id'];?>"><?php echo $this->date->formatDate($item['quiz_create_datetime'], 1);?></a><br />
							<b><?php echo $item['poll_title'];?></b><br />
							<?php echo $item['poll_synopsis'];?><br />
						</td>
						<td valign="top" align="right">
							<?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?><br />
						</td>
					</tr>
					<tr>
						<td colspan="2" align="right">
							<?php echo $lang['txt_tag_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['profile_nic'];?></a>, 
							<?php echo $lang['txt_item_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $r['user_id'];?>"><?php echo $r['profile_nic'];?></a><br />
						</td>
					</tr>
					<?php
					}}
					elseif ($i['rsp_item_type_id'] == $rsp_item_type_ids['network']) {
					// we get the user
					if (isset($users)) {
					foreach($users as $key => $r):
					if ($i['item_id'] == $r['user_id']) {
						$item = $r;
						break;
					}
					endforeach;
						
					?>
					<tr>
						<td width="1">
							<a href="sn_profile.php?user_id=<?php echo $item['user_id'];?>"><img src="get_file.php?file=<?php echo $item['image']['file'];?>" border="0" alt="<?php echo $item['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top">
							<a href="sn_profile.php?user_id=<?php echo $item['user_id'];?>"><?php echo $this->date->formatDate($item['user_create_datetime'], 1);?></a><br />
							<?php echo $item['user_nic'];?><br />
						</td>
						<td valign="top" align="right">
							<?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?><br />
						</td>
					</tr>
					<?php
					}}
					elseif ($i['rsp_item_type_id'] == $rsp_item_type_ids['schedule']) {
					// we get the schedule item
					if (isset($schedule_items)) {
					foreach($schedule_items as $key => $r):
					if ($i['item_id'] == $r['schedule_id']) {
						$item = $r;
						break;
					}
					endforeach;
						
					?>
					<tr>
						<td width="1" rospan="2">
							<a href="sch_view.php?schedule_id=<?php echo $item['schedule_id'];?>"><img src="get_file.php?file=<?php echo $item['image']['file'];?>" border="0" alt="<?php echo $item['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top">
							<a href="sch_view.php?schedule_id=<?php echo $item['schedule_id'];?>"><?php echo $this->date->formatDate($item['schedule_create_datetime'], 1);?></a><br />
							<b><?php echo $item['schedule_title'];?></b><br />
							<?php echo $item['schedule_synopsis'];?><br />
						</td>
						<td valign="top" align="right">
							<?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?><br />
						</td>
					</tr>
					<tr>
						<td colspan="2" align="right">
							<?php echo $lang['txt_tag_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['profile_nic'];?></a>, 
							<?php echo $lang['txt_item_author'];?>:&nbsp;<a href="sn_profile.php?user_id=<?php echo $r['user_id'];?>"><?php echo $r['profile_nic'];?></a><br />
						</td>
					</tr>
					<?php
					}}
					?>
					<tr>
						<td colspan="3">
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						</td>
					</tr>
				<?php
				endforeach;
				?>
				</table>
				<?php
				echo createArrayList($tags);
				}
				elseif (isset($tag)) {
				?>
				<p>
					<?php echo $lang['err_search'];?><br />
				</p>
				<?php
				}
				else {
				?>
				
				<p>
					<?php echo $lang['txt_tagcloud_intro'];?><br />
				</p>
				<?php }?>
				
				<?php
				$cloud = "";
				
				if (isset($item_tags)) {
					foreach ($item_tags as $key => $i):
						$cloud .= "<a href='search.php?view=tags&amp;tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
						
						if (isset($i['user_id']) && $i['user_id'] == $me['user_id']) {
							$cloud .= "*";
						}
						
						if (count($item_tags) > $key+1) {
							$cloud .= ", ";
						}
					endforeach;
				}
				
				echo $cloud;
				?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_search'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_search_tag_intro'];?><br />
				</p>
				
				<p>
					<label for="id_search_text"><b><?php echo $lang['form_search'];?></b></label><br />
				</p>
				
				<p>
					<input type="text" name="tag" id="id_search_text" class="input" size="20" value="<?php if (isset($tag)) { echo $tag;};?>" /><br />
				</p>
				
				<p>
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
				
				<?php
				if (isset($tag)) {
				?>
				<a href="search.php?view=tags"><?php echo $lang['href_tagcloud'];?></a><br />
				<?php }?>
				
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<?php
}
elseif (isset($display) && $display == "comments") {
?>
<input type="hidden" name="view" value="comments" /><br />

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comment_search'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($comments)) {
				$display_items = trimArray($comments);
				foreach($display_items as $key => $i):
				
				?>
				<p>
					<?php echo $this->date->formatDate($i['comment_create_datetime'], 1);?>: <a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['profile_nic'];?></a>:&nbsp;
					<?php
					if ($rsp_item_type_ids['blog'] == $i['rsp_item_type_id']) {
					?>
					<a href="blg_view.php?blog_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
					<?php
					}
					elseif ($rsp_item_type_ids['library'] == $i['rsp_item_type_id']) {
					?>
					<a href="lib_view.php?library_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
					<?php
					}
					elseif ($rsp_item_type_ids['poll'] == $i['rsp_item_type_id']) {
					?>
					<a href="pol_view.php?poll_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
					<?php
					}
					elseif ($rsp_item_type_ids['forum'] == $i['rsp_item_type_id']) {
					?>
					<a href="frm_view.php?subject_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
					<?php
					}
					elseif ($rsp_item_type_ids['quiz'] == $i['rsp_item_type_id']) {
					?>
					<a href="quz_view.php?quiz_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
					<?php }?>
					<br />
				</p>
				
				<p>
					<?php echo dots(400, $i['comment_body']);?><br />
				</p>
				
				<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="4" alt="" /><br />
				
				<?php
				endforeach;
				echo createArrayList($comments);
				}
				?>
				
				<p>
					<?php echo $lang['txt_comment_intro'];?><br />
				<p>
				
				<?php
				if (isset($frmdata) && !isset($comments)) {
				?>
				<p>
					<?php echo $lang['err_no_comments'];?><br />
				<p>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_search'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_search_comment_intro'];?><br />
				</p>
				
				<p>
					<label for="id_search_text"><b><?php echo $lang['form_search'];?></b></label><br />
				</p>
				
				<p>
					<input type="text" name="search_text" id="id_search_text" class="input" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" /><br />
				</p>
				
				<p>
					<label for="id_search_type"><b><?php echo $lang['form_search_on'];?></b></label><br />
				</p>
				
				<p>
					<select name="search_type" id="id_search_type" style="width:140px;">
						<?php
						foreach($lang['search_comments'] as $key => $i):
						$selected = "";

						if ((isset($search['search_type']) && $search['search_type'] == $key) || $key == "received_comments") {
							$selected = " selected=\"selected\"";
						}
						?>
						<option value="<?php echo $key;?>"<?php echo $selected;?>><?php echo $i;?></option>
						<?php endforeach; ?>
					</select>
				</p>
				
				<p>
					<label for="id_search_show"><b><?php echo $lang['form_search_date'];?></b></label><br />
				</p>
				
				<p>
					<select id="id_search_show" name="search_show" style="width:140px;">
						<?php
						foreach($lang['search_show'] as $key => $i):
						$selected = "";

						if ((isset($search['search_show']) && $search['search_show'] == $key) || $key == "30") {
							$selected = " selected=\"selected\"";
						}
						?>
						<option value="<?php echo $key;?>"<?php echo $selected;?>><?php echo $i;?></option>
						<?php endforeach; ?>
					</select>
				</p>
				
				<p>
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
<?php
}
elseif (isset($display) && $display == "directory") {
?>
<input type="hidden" name="view" value="directory" /><br />

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_directory_search'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_directory_intro'];?><br />
				</p>
				
				<?php
				if (isset($users)) {
				?>
				<table border="0" width="100%" cellspacing="0" cellpadding="4">
					<?php
					foreach($users as $key => $i):
					?>
					<tr>
						<td valign="top" width="32" rowspan="2">
							<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
							
						<td valign="middle">
							<?php
							if (!empty($i['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['user_firstname']. " " . $i['user_surname'];?></a></b>,
								
								
								<?php echo $i['user_create_datetime'];?>,
								<?php echo $i['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><b><?php echo $i['profile_nic'];?></b></a>,
								
								
								<?php echo $i['user_create_datetime'];?>,
								<?php echo $i['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($i['online_status'] == 1) {
								echo "<span class='txt_breadcrumb_on'><b>" . $lang['arr_user_online_status'][1] . "</b></span><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$i['online_status']] . "<br />";
							}
							?>
						</td>
						
						<td valign="top" width="80">
							<?php
							if (isset($i['relation_to'])) {
								echo "<img src='" . $templatePath . "img/sn_connected_to_them.png' width='16' height='16' title='" .  $lang['txt_help_icon_conn'] . "' alt='" .  $lang['txt_help_icon_conn'] . "' />&nbsp;";
								
								if (!empty($i['relation_to']['relation_show_network'])) {
									echo "<img src='" . $templatePath . "img/sn_they_see_my_nw.png' width='16' height='16' title='" . $lang['txt_help_icon_net'] . "' alt='" . $lang['txt_help_icon_net'] . "' />&nbsp;";
								}
								
								if (!empty($i['relation_to']['relation_show_true_self'])) {
									echo "<img src='" . $templatePath . "img/sn_true_self_revealed_to_them.png' width='16' height='16' title='" . $lang['txt_help_icon_ts'] . "' alt='" . $lang['txt_help_icon_ts'] . "' />&nbsp;";
								}
							}
							?><br />
						</td>
						<td align="right" rowspan="2">
							<?php
							if (isset($i['profile_allow_msg']) && $i['profile_allow_msg'] == 1) {
							?>
							<a href="msg_compose.php?to_user_id=<?php echo $i['user_id'];?>"><img src="<?php echo $templatePath;?>img/unopenned_mail.png" title="<?php echo $lang['ttl_send_message'];?>" border="0" alt="" /></a>&nbsp;&nbsp;<br />
							<?php }?>
						</td>
					</tr>
					<tr>
						<td>
							<p>
								<?php echo $lang['txt_tag'];?>: 
		
								<?php
								$tags = "";
								if (isset($i['tags'])) {
									foreach ($i['tags'] as $keyt => $t):
										$tags .= $t['tag_body'];
										
										if (count($i['tags']) > $keyt+1) {
											$tags .= ", ";
										}
									endforeach;
									echo $tags;
								}
								?>
							</p>
						</td>
						<td>
							<?php
							if (!empty($i['blocked'])) {
								echo $lang['txt_blocked'] . "<br />";
							}
							?>
							<?php
							if (!empty($i['am_relation_to_them']['relation_show_network'])) {
									echo "relations: " . $i['sn_total'];
								}
							?>
							<br />
						</td>
					</tr>
					<tr>
						<td colspan="4">
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="4" alt="" /><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_search'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_search_basic_intro'];?><br />
				</p>
				
				<p>
					<label for="id_search_text"><b><?php echo $lang['form_search'];?></b></label><br />
				</p>
				
				<p>
					<input type="text" name="search_text" id="id_search_text" class="input" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" /><br />
				</p>
				
				<p>
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<?php
}
else { // content search screen
?>
<input type="hidden" name="view" value="content" /><br />

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_content_search'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($frmdata)) {
				?>
				<p>
					<?php echo $lang['txt_search_results'];?><br />
				<p>
				<?php
				}
				else {
				?>
				<p>
					<?php echo $lang['txt_content_intro'];?><br />
				</p>
				<?php }?>
				
				<?php
				if (isset($groups)) {
				?>
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					foreach($groups as $key => $i):
					?>
					<tr>
						<td>
							<table width="100%" cellpadding="2" cellspacing="0" border="0">
								<tr>
									<td width="3" valign="top">
										<img src="<?php echo $templatePath;?>img/green_dot.png" width="3" height="9" alt="" /><br />
									</td>
									<td>
										<a href="grp_view.php?group_id=<?php echo $i['group_id'];?>"><?php echo $i['group_title'];?></a><br />
										<span class="txt_footer">
										<?php echo $i['group_synopsis'];?><br />
										</span>
									</td>
									<td  align="right">
										<?php echo $lang['txt_recommended_age'];?>:
										<?
										if ($i['group_from_age'] && $i['group_to_age']) {
											echo $i['group_from_age'] . "/" . $i['group_to_age'];
										}
										else if ($i['group_from_age'] && !$i['group_to_age']) {
											echo $lang['txt_age_from'] . " " . $i['group_from_age'];
										}
										else if (!$i['group_from_age'] && $i['group_to_age']) {
											echo $lang['txt_age_upto'] . " " . $i['group_to_age'];
										}
										else {
											echo $lang['txt_age_all'];
										}
										?><br />
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php }?>
				
				
				<?php
				if (isset($blogs)) {
				?>
				<table width="100%" cellpadding="2" cellspacing="0" border="0">
					<?php
					foreach($blogs as $key => $i):
					?>
					<tr>
						<td width="1" rospan="2">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td>
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><?php echo $this->date->formatDate($i['blog_create_datetime']);?></a><br />
							<b><?php echo $i['blog_title'];?></b><br />
							<?php echo dots(200, $i['blog_synopsis']);?><br />
						</td>
					</tr>
					<tr>
						<td>
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="2" alt="" /><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php }?>
				
				<?php
				if (isset($subjects)) {
				?>
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					foreach($subjects as $key => $i):
					?>
					<tr>
						<td width="1" rospan="2">
							<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td>
							<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><?php echo $this->date->formatDate($i['subject_create_datetime']);?></a><br />
							<b><?php echo $i['subject_title'];?></b><br />
							<?php echo $i['subject_synopsis'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="2" alt="" /><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php }?>
				
				<?php
				if (isset($polls)) {
				?>
				<table border="0" cellspacing="4" cellpadding="0" width="100%">
					<?php
					foreach($polls as $key => $i):
					?>
					<tr>
						<td valign="top">
							<?php
							$poll_url = "pol_view.php?poll_id=" . $i['poll_id'];
							
							$poll = $i;
							include $templatePath . "poll.inc.tpl.php";
							?>
						</td>
					</tr>
					<tr>
						<td>
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="2" alt="" /><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php }?>
				
				
				<?php
				if (isset($quizzes)) {
				?>
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					foreach($quizzes as $key => $i):
					?>
					<tr>
						<td width="1" rospan="2">
							<a href="quz_view.php?quiz_id=<?php echo $i['quiz_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td>
							<a href="quz_view.php?quiz_id=<?php echo $i['quiz_id'];?>"><?php echo $this->date->formatDate($i['quiz_create_datetime']);?></a><br />
							<b><?php echo $i['quiz_title'];?></b><br />
							<?php echo dots(200, $i['quiz_synopsis']);?><br />
						</td>
					</tr>
					<tr>
						<td>
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="2" alt="" /><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php }?>
				
				<?php
				if (isset($library_items)) {
				?>
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					foreach($library_items as $key => $i):
					?>
					<tr>
						<td width="1" rospan="2">
							<a href="lib_view.php?library_id=<?php echo $i['library_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td>
							<a href="lib_view.php?library_id=<?php echo $i['library_id'];?>"><?php echo $this->date->formatDate($i['library_create_datetime']);?></a><br />
							<b><?php echo $i['library_title'];?></b><br />
							<?php echo $i['library_synopsis'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="2" alt="" /><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php }?>
				
				<?php
				if (isset($schedule_items)) {
				?>
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					foreach($schedule_items as $key => $i):
					?>
					 <tr>
						<td width="1" rospan="2">
							<a href="sch_view.php?schedule_id=<?php echo $i['schedule_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top">
							<a href="sch_view.php?schedule_id=<?php echo $i['schedule_id'];?>"><?php echo $i['schedule_title'];?></a><br />
							<?php echo $i['schedule_synopsis'];?><br />
						</td>
						<td align="right" valign="top">
							<?php echo $i['display_schedule_start_datetime'];?><br />
							<?php echo $i['schedule_allocation'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="2" alt="" /><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php }?>
				
				<?php
				if (isset($frmdata) && isset($lang['err_search'])) {
				?>
				<p>
					<?php echo $lang['err_search'];?><br />
				</p>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_search'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_search_basic_intro'];?><br />
				</p>
				
				<p>
					<label for="id_search_text"><b><?php echo $lang['form_search'];?></b></label><br />
				</p>
				
				<p>
					<input type="text" name="search_text" id="id_search_text" class="input" size="20" value="<?php if (isset($search['search_text'])) { echo $search['search_text'];};?>" /><br />
				</p>
				
				<p>
					<label for="id_search_type"><b><?php echo $lang['form_search_in'];?></b></label><br />
				</p>
				
				<p>
					<select name="search_type" id="id_search_type" style="width:140px;">
						<?php
						foreach($lang['search_type'] as $key => $i):
						$selected = "";

						if ((isset($search['search_type']) && $search['search_type'] == $key) || $key == "blog") {
							$selected = " selected=\"selected\"";
						}
						?>
						<option value="<?php echo $key;?>"<?php echo $selected;?>><?php echo $i;?></option>
						<?php endforeach; ?>
					</select>
				</p>
				
				<p>
					<label for="id_search_show"><b><?php echo $lang['form_search_date'];?></b></label><br />
				</p>
				
				<p>
					<select id="id_search_show" name="search_show" style="width:140px;">
						<?php
						foreach($lang['search_show'] as $key => $i):
						$selected = "";

						if ((isset($search['search_show']) && $search['search_show'] == $key) || $key == "any") {
							$selected = " selected=\"selected\"";
						}
						?>
						<option value="<?php echo $key;?>"<?php echo $selected;?>><?php echo $i;?></option>
						<?php endforeach; ?>
					</select>
				</p>
				
				<p>
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
<?php }?>
</form>
