<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";


if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}


require_once ("class/Tie.class.php");
$tie = new Tie($db, $core_config);


if (isset($_POST['set_portable'])) {
	$tie->deletePortable($_POST['identity_id']);
	
	foreach ($_POST['identity_id_portable'] as $key => $up):
		foreach ($up as $modkey => $m):
			$tie->module_id = $modkey;
			
			foreach ($m as $itemkey => $i):
				$tie->item_id = $itemkey;
			
				$tie->setPortable($_POST['identity_id'], $i);
			endforeach;
		endforeach;
	endforeach;
}


// get my identities
$output_identities = $user->selUserIdentities($_SESSION['user_id']);

if (!empty($output_identities)) {
	require_once('components/core/class/Participation.class.php');
	$participation = new Participation($db, $core_config);
	
	foreach ($output_identities as $key => $i):
		$participation->identity_ids[] = $i['identity_id'];
	endforeach;
	
	$output_ties = $participation->selRelations();
	
	$participation->relation_portable = 1;
	
	$output_portable_ties = $participation->selRelations();
}


require_once ("class/File.class.php");
$file = new File($db, $core_config['file']);
$file->core_config_module = $core_config['module'];
$file->user_id = $_SESSION['user_id'];
$file->module_id = 0; // core
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumbs = $core_config['file']['image']['thumb'];
$user->file = $file;
$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];

if (!empty($output_ties)) {
	// get their identities
	foreach ($output_ties as $key => $i):
		$user->identity_ids[] = $i['identity_id_relation'];
		
		// is the relationship mutual?
		$tie->module_id = $i['module_id'];
		$tie->item_id = $i['item_id'];
		
		if ($tie->isMutual($i['identity_id_relation'], $i['identity_id'])) {
			$output_ties[$key]['mutual'] = 1;
		}
	endforeach;
	
	$user->identity_ids = array_unique($user->identity_ids);
	
	if (!empty($user->identity_ids)) {
		$output_identities = $user->selUserIdentities();
		
		// we place the identities against the ties
		if (!empty($output_identities)) {
			foreach ($output_ties as $keyp => $p):
				foreach ($output_identities as $keyi => $i):
					if ($p['identity_id_relation'] == $i['identity_id']) {
						$output_ties[$keyp]['identity'] = $i;
						break;
					}
				endforeach;
			endforeach;
		}
		
		$body->set('ties', $output_ties);
	}
}


// GET PORTABLE RELATIONS ------------------------------
$user->file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
$user->file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];


if (!empty($output_portable_ties)) {
	// get their identities
	unset($user->identity_ids);
	
	foreach ($output_portable_ties as $key => $i):
		$user->identity_ids[] = $i['identity_id_relation'];
		
		// is the relationship mutual?
		$tie->module_id = $i['module_id'];
		$tie->item_id = $i['item_id'];
		
		if ($tie->isMutual($i['identity_id_relation'], $i['identity_id'])) {
			$output_ties[$key]['mutual'] = 1;
		}
	endforeach;
	
	$user->identity_ids = array_unique($user->identity_ids);
	
	if (!empty($user->identity_ids)) {
		$output_identities = $user->selUserIdentities();
		
		// we place the identities against the ties
		if (!empty($output_identities)) {
			foreach ($output_portable_ties as $keyp => $p):
				foreach ($output_identities as $keyi => $i):
					if ($p['identity_id_relation'] == $i['identity_id']) {
					
						$output_portable_ties[$keyp]['common_ties'] = $tie->selCommonTies($p['identity_id'], $i['identity_id']);
						$output_portable_ties[$keyp]['identity'] = $i;
						break;
					}
				endforeach;
			endforeach;
		}
		
		
		$body->set('portable_ties', $output_portable_ties);
	}
}


?>