<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";


$output_maintainers = selMaintainers();
$body->set('maintainers', $output_maintainers);


//process requests
if (isset($_POST['send_contact_report'])) {
	$report_id = insertReport($_POST);
	
	if (!empty($report_id)) {
		$body->set('display', "report_sent");
		
		// we email maintainers if it is an abuse report
		if ($_POST['contact_report_type'] == 1) {
			//setup email
			require_once('class/Mail/class.phpmailer.php');
			$mail = new PHPMailer($core_config['mail']);
			$mail->AddReplyTo	($core_config['mail']['no_reply_address'], $lang['subject_noreply']);
			$mail->Subject = 	$lang['subject_abuse_report'];
			$mail->Priority = 	1;
			
			// create URL
			$url = "http://" . $_SERVER['HTTP_HOST'];
			$url .= dirname ($_SERVER['PHP_SELF']);
			// sometimes the server adds \ as the last characture - we need to check.
	
			if (substr($url, -1, 1) != "/") {
				$url .= "/";
			}
			$url .= "index.php?amn=core_maint_contact_view&contact_id=" . $report_id;
			
			// create mail content
			$body_mail_txt = readTxtFile($language_path . "texts/mail_abuse_reported.txt.php");
			foreach($output_maintainers as $key => $i):
				$body_mail_txt_out = str_replace("SYS_KEYWORD_NAME", $i['identity_nic'], $body_mail_txt);
				$body_mail_txt_out = str_replace("SYS_KEYWORD_URL", $url, $body_mail_txt_out);
				$body_mail_txt_out = stripslashes($body_mail_txt_out);
				$body_mail_txt_out = nl2br($body_mail_txt_out);
				
				// HTML-version of the mail
				$html  = "<HTML><HEAD><TITLE></TITLE></HEAD>";
				$html .= "<BODY>";
				$html .= utf8_decode($body_mail_txt_out);
				$html .= "</BODY></HTML>";
				
				$mail->Body = $html;
				// non - HTML-version of the email
				$mail->AltBody   = utf8_decode($body_mail_txt_out);
				
				$mail->ClearAddresses();
				$mail->AddAddress($i['user_email'], '');
				
				if($mail->Send()) {
					// sent
				}
			endforeach;
		}
	}
}



/*
* selMaintainers
* Tom Calthrop 29th September 2006
*/
function selMaintainers() {
	
	global $db, $core_config, $user;
	
	require_once('class/User.class.php');
	$user = new User($db, $core_config['user']);
		
	$query = "
		SELECT user_id, user_core_permission 
		FROM " . $db->prefix . "_user 
		WHERE
		user_core_permission>0"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		
		unset ($user->user_ids);
		while (!$result->EOF) {
			if($result->fields['user_core_permission'] & $core_config['resource']['user']['mng_contacts']) {
				$user->user_ids[] = $result->fields['user_id'];
			}
			
			$result->MoveNext();
		}
	}
	
	// GET IDENTITIES FOR EACH MAINTAINER
	if (!empty($user->user_ids)) {	
		require_once ("class/File.class.php");
		$file = new File($db, $core_config['file']);
		$file->module_id = 0; // core
		$file->directory = "core";
		
		$user->file = $file;
		$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
		$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
		
		if (isset($_SESSION['md5'])) { // logged in
			$user->identity_type = $core_config['user']['identity']['type']['registered'];
		}
		else {
			$user->identity_type = $core_config['user']['identity']['type']['public'];
		}
		
		$user->order_by = "i.identity_type desc";
		
		return $user->selUserIdentities();
	}
}


/*
* insertReport
* Tom Calthrop 29th September 2006
*/
function insertReport($data) {
	
	global $db;
	
	if (isset($_SESSION['report_abuse_body'])) {
		$data['contact_source'] = $_SESSION['report_abuse_body'];
		unset($_SESSION['report_abuse_body']);
	}
	else {
		$data['contact_source'] = "null";
	}
	
	if (!isset($data['reportee_email'])) {
		$data['reportee_email'] = "null";
	}
	
	if (isset($_SESSION['user_id'])) {
		$data['user_id'] = $_SESSION['user_id'];
	}
	else {
		$data['user_id'] = "null";
	}
	
	$rec = array();
	$rec['contact_url'] = $data['contact_url'];
	$rec['contact_source'] = $data['contact_source'];
	$rec['reportee_user_id'] = $data['user_id'];
	$rec['reportee_language_id'] = $_SESSION['language_id'];
	$rec['report_datetime'] = time();
	$rec['contact_report_type'] = $data['contact_report_type'];
	$rec['contact_message'] = $data['contact_message'];
	$rec['reportee_email'] = $data['reportee_email'];

	$table = $db->prefix . "_contact";
		
	$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
	$result = $db->Execute($query);
	
	if (!empty($result)) {
		return $db->Insert_ID();
	}
	else {
		return false;
	}
}//EO insert();

?>