<?php

class Participation {


	function Participation($db, $core_config) {
		$this->db = $db;
		$this->core_config = $core_config;
	}

	
	
	
	// countParticipants --------------------------------------------------------------------
	// returns a single group record
	// tom calthrop - 24th October 2006
	//
	function countParticipants($status_id = null, $role_id = null) {
		$query = "
			SELECT count(user_id) as total 
			FROM " . $this->db->prefix . "_participation 
			WHERE 
			item_id=" . $this->item_id . " AND 
			module_id=" . $this->module_id . " AND "
		;
		
		if (isset($status_id)) {
			$query .= "status_id=" . $status_id . " AND ";
		}
		
		if (isset($role_id)) {
			$query .= "role_id=" . $role_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			return $result->fields['total'];
		}
		else {
			$error_info = "method=countParticipants class=Participant.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	} //EO countParticipants
	
	
	
	// insertParticipant --------------------------------------------------------------------
	// inserts a single group participant record
	// tom calthrop - 24th October 2006
	//
	function insertParticipant($data) {
		
		$rec = array();
		$rec['module_id'] = $this->module_id;
		$rec['item_id'] = $this->item_id;
		
		if (!empty($data['role_id'])) {
			$rec['role_id'] = $data['role_id'];
		}
		
		if (!empty($data['invitee_user_id'])) {
			$rec['invitee_user_id'] = $data['invitee_user_id'];
		}
		
		if (!empty($data['participation_permission'])) {
			$rec['participation_permission'] = $data['participation_permission'];
		}
		
		if (!empty($data['user_id'])) {
			$rec['user_id'] = $data['user_id'];
		}
		else {
			$rec['user_id'] = $this->user_id;
		}
		
		$rec['status_id'] = $data['status_id'];
		$rec['identity_id'] = $data['identity_id'];
		$rec['participation_create_datetime'] = time();
		
		$table = $this->db->prefix . "_participation";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
	
	} //EO insertParticipant
	
	
	
	// updateParticipant --------------------------------------------------------------------
	// updates a participant record
	// tom calthrop - 24th October 2006
	//
	function updateParticipant($data) {
		$query = "
			SELECT user_id, identity_id, role_id, status_id, 
			participation_permission 
			FROM " . $this->db->prefix . "_participation 
			WHERE 
			item_id=" . $this->item_id . " AND 
			module_id=" . $this->module_id . " AND 
			user_id=" . $this->user_id
		;
		
		$result = $this->db->Execute($query);
			
		if (isset($result->fields)) {
			$rec = array();
			
			if (!empty($data['role_id'])) {
				$rec['role_id'] = $data['role_id'];
			}
			elseif (isset($data['role_id'])) {
				$rec['role_id'] = "null";
			}
			
			if (!empty($data['participation_permission'])) {
				$rec['participation_permission'] = $data['participation_permission'];
			}
			
			if (!empty($data['status_id'])) {
				$rec['status_id'] = $data['status_id'];
			}
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
		}
	} //EO updateParticipant
	
	
	
	// deleteParticipant --------------------------------------------------------------------
	// deletes a participant record
	// tom calthrop - 24th October 2006
	//
	function deleteParticipant($user_id) {
		$query = "
			SELECT user_id, identity_id 
			FROM " . $this->db->prefix . "_participation 
			WHERE 
			item_id=" . $this->item_id . " AND 
			module_id=" . $this->module_id . " AND 
			user_id=" . $user_id
		;
		
		$result = $this->db->Execute($query);
			
		if (isset($result->fields)) {
			// we need to delete all relationship to and from me
			$query = "
				DELETE FROM " . $this->db->prefix . "_relation  
				WHERE 
				module_id=" . $this->module_id . " AND 
				item_id=" . $this->item_id . " AND 
				identity_id=" . $result->fields['identity_id'] . " OR 
				identity_id_relation=" . $result->fields['identity_id']
			;
			
			$result = $this->db->Execute($query);
			
			// delete the participation
			$query = "
				DELETE FROM " . $this->db->prefix . "_participation 
				WHERE 
				item_id=" . $this->item_id . " AND 
				module_id=" . $this->module_id . " AND 
				user_id=" . $user_id
			;
			
			$result = $this->db->Execute($query);
		}
	} //EO updateParticipant
	
	
	
	// selParticipation --------------------------------------------------------------------
	// selects a single participant record
	// tom calthrop - 24th October 2006
	//
	function selParticipation($user_id = null, $identity_id = null) {
		$query = "
			SELECT module_id, item_id, user_id, status_id, identity_id, 
			participation_permission, participation_create_datetime, role_id, 
			invitee_user_id 
			FROM " . $this->db->prefix . "_participation 
			WHERE 
			module_id=" . $this->module_id . " AND "
		;
		
		if (isset($user_id)) {
			$query .= "user_id=" . $user_id . " AND ";
		}
		else {
			$query .= "identity_id=" . $identity_id . " AND ";
		}
		
		if (isset($this->status_id)) {
			$query .= "status_id=" . $this->status_id . " AND ";
		}
		
		if (isset($this->item_id)) {
			$query .= "item_id=" . $this->item_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			
			return $result->fields;
		}
		else {
			$error_info = "method=selParticipation class=Participation.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	} //EO selParticipation
	
	
	
	// selParticipants --------------------------------------------------------------------
	// selects a single participant record
	// tom calthrop - 24th October 2006
	//
	function selParticipants($status_id = null, $role_id = null, $user_id = null) {
		$query = "
			SELECT user_id, status_id, identity_id, participation_permission, 
			participation_create_datetime, role_id, item_id  
			FROM " . $this->db->prefix . "_participation 
			WHERE 
			module_id=" . $this->module_id . " AND "
		;
		
		if (isset($this->idem_ids)) {
			$item_ids = "";
			foreach($this->item_ids as $key => $i):
				$item_ids .= $i;
				if (count($this->item_ids) > $key+1) {
				    $item_ids .=",";
				}
			endforeach;
			$query .="item_id in (" . $item_ids . ") AND ";
		}
		elseif (isset($this->item_id)) {
			$query .= "item_id=" . $this->item_id . " AND ";
		}
		
		if (isset($user_id)) {
			$query .= "user_id=" . $user_id . " AND ";
		}
		
		if (isset($status_id)) {
			$query .= "status_id=" . $status_id . " AND ";
		}
		
		if (isset($role_id)) {
			$query .= "role_id=" . $role_id . " AND ";
		}
		
		$query .= "1=1";

		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				array_push($temp, $temp1);
				
				$result->MoveNext();
			}
			
			$result->Close();
			
			return $temp;
		}
		else {
			$error_info = "function=selParticipants class=Participation.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	} //EO selParticipants
	
	
	
	// countRelations --------------------------------------------------------------------
	// returns a single group record
	// tom calthrop - 30th October 2006
	//
	function countRelations($identity_id = null) {
		$query = "
			SELECT DISTINCT count(identity_id) as total 
			FROM " . $this->db->prefix . "_relation 
			WHERE 
			identity_id=" . $identity_id . " AND 
			item_id=" . $this->item_id . " AND 
			module_id=" . $this->module_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			return $result->fields['total'];
		}
		else {
			$error_info = "method=countRelations class=Participation.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	} //EO countRelations
	
	
	// selRelations --------------------------------------------------------------------
	// selects a single participant record
	// tom calthrop - 24th October 2006
	//
	function selRelations($identity_id = null, $user_id = null) {
		$query = "
			SELECT r.module_id, r.item_id, r.identity_id, r.identity_id_relation, 
			r.relation_create_datetime, r.item_id, r.relation_portable 
			FROM " . $this->db->prefix . "_relation r 
			WHERE "
		;
		
		if (isset($this->module_id)) {
			$query .= "r.module_id=" . $this->module_id . " AND ";
		}
		
		if (isset($this->item_id)) {
			$query .= "r.item_id=" . $this->item_id . " AND ";
		}
		
		if (isset($identity_id)) {
			$query .= "r.identity_id=" . $identity_id . " AND ";
		}
		elseif (isset($this->identity_ids)) {
			$identity_ids = "";
			foreach($this->identity_ids as $key => $i):
				$identity_ids .= $i;
				if (count($this->identity_ids) > $key+1) {
				    $identity_ids .=",";
				}
			endforeach;
			$query .="r.identity_id in (" . $identity_ids . ") AND ";
		}
		
		if (isset($user_id)) {
			$query .= "r.user_id=" . $user_id . " AND ";
		}
		
		if (isset($this->not_identity_id)) {
			$query .= "r.identity_id_relation!=" . $this->not_identity_id . " AND ";
		}
		
		if (isset($this->relation_portable)) { // added 061114 by sebastian
			$query .= "r.relation_portable=" . $this->relation_portable . " AND ";
		}
		
		$query .= "1=1";
		
		if (isset($this->order_by)) {
		    $query .= " order by " . $this->order_by;
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				array_push($temp, $temp1);
				
				$result->MoveNext();
			}
			
			$result->Close();
			
			return $temp;
		}
		else {
			$error_info = "method=selRelations class=Participation.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	} //EO selRelations
	
	
	// setUserStatus --------------------------------------------------------------------
	// change the status_id on multiple user ids
	// tom calthrop - 30th October 2006
	//
	function setUserStatus ($identity_ids, $status_id) {
		
		if (!empty($identity_ids)) {
			$rownums = count($identity_ids);
	
			for ($i=0; $i < $rownums; $i++) {
			    $query = "
					UPDATE " . $this->db->prefix . "_participation 
					SET 
					status_id=" . $status_id . " 
					WHERE
					identity_id=" . $identity_ids[$i]
				;
	
				$result = $this->db->Execute($query);
	
				if (empty($result)) {
					$error_info = "method=setUserStatus class=Participation.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['am_error_log'][] = array('db_error', $error_info);
				}
			}
		}
	} // EO setUserStatus
	
	
	// deleteRelations --------------------------------------------------------------------
	// change the status_id on multiple user ids
	// tom calthrop - 30th October 2006
	//
	function deleteRelations ($identity_ids, $identity_id) {
		
		if (!empty($identity_ids)) {
			$rownums = count($identity_ids);
	
			for ($i=0; $i < $rownums; $i++) {
			    $query = "
					DELETE FROM " . $this->db->prefix . "_relation 
					WHERE
					identity_id_relation=" . $identity_ids[$i] . " AND 
					identity_id=" . $identity_id
				;
	
				$result = $this->db->Execute($query);
	
				if (empty($result)) {
					$error_info = "method=deleteRelations class=Participation.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['am_error_log'][] = array('db_error', $error_info);
				}
			}
		}
	} // EO deleteRelations
	
	
	// checkSetMembershipTypeAccess --------------------------------------------------
	// returns true if the item has a membership type of given
	// tom calthrop - 30th November 2006
	//
	function checkSetMembershipTypeAccess($membership_type_id) {
		 $query = "
			SELECT item_id 
			FROM " . $this->db->prefix . "_mem_type_access  
			WHERE 
			module_id =" . $this->module_id  . " AND 
			item_id =" . $this->item_id  . " AND 
			membership_type_id=" . $membership_type_id
		;
		
		$result = $this->db->SelectLimit($query, 1);

		if (isset($result->fields['item_id'])) {
			return true;
		}
		else {
			return false;
		}
	} // EO checkSetMembershipTypeAccess
}
?>