<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


	function am_register($arr) {
		
		GLOBAL $lang;
		if (!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,6}$/', $arr['register_email'])) {
			echo $lang['error_fail_emailvalidation'];
			return false;
		}

		include "../../aroundme/components/core/class/Mail/class.phpmailer.php";
		include "../../aroundme/components/core/class/Adodb/adodb.inc.php";
		
		$db = NewADOConnection($_SESSION['database_driver']);
		
		if(!$db->Connect($_SESSION['database_host'], $_SESSION['database_user'], $_SESSION['database_password'], $_SESSION['database_database'])) {
			echo $lang['error_fail_connect_database'];
			return false;
		}
		
		$mail = new PHPMailer(array('host' => $_SESSION['email_host'],
									'port' => $_SESSION['email_port'],
									'mailer' => $_SESSION['email_mailer'],
									'default_address' => $_SESSION['email_default_address'],
									'from_name' => $_SESSION['email_from_name'],
									'wordwrap' => $_SESSION['email_wordwrap']));
									
		$totallength = 8;
		$salt = "abcdefghijklmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789";
		srand((double)microtime()*1000000);
		$password = "";
		for ($i = 0; $i < $totallength; $i++) {
			$password .= substr ($salt, rand() % strlen($salt), 1);
		}

		include "../../aroundme/components/core/config/aroundme_core.config.php";
		
		$rec = array();
		$rec['user_email']              = $arr['register_email'];
		$rec['user_firstname']          = $arr['register_fname'];
		$rec['user_password']           = md5($password);
		$rec['user_create_datetime']    = time();
		$rec['template_id']             = $core_config['template']['default_id'];
		$rec['user_file_allocation']    = $core_config['file']['default_max_user_space'];
		$rec['user_message_allocation'] = $core_config['messaging']['box']['max_size'];
		$rec['user_homepage']           = $core_config['node']['page_default'];
		$rec['status_id']               = $core_config['user']['status']['pending'];
		$rec['role_id']                 = $core_config['role']['invite_default'];
		$rec['language_id']             = $core_config['language']['default_id'];
				
		$table = $core_config['db']['prefix'] . "_user";

		$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $db->Execute($query);
		$user_id = 1; // change this to last-insert-id
		
		$url = "http://" . $_SERVER['HTTP_HOST'];
		$url .= dirname(dirname(dirname($_SERVER['PHP_SELF'])."..")."..");
		
		if (substr($url, -1, 1) != "/") {
		    $url .= "/";
		}
		
		$url .= "aroundme/index.php?amn=core_setup&em=" . $rec['user_email'] . "&language_id=" . $rec['language_id'];

		$mail->Subject = "register";
		$mail->Body = "password= ".$password. "  and enter link: ".$url;
		$mail->AddAddress($arr['register_email']); 

		if (!$mail->Send()) {
			echo "error";
			return false;
		}

		$new_id = rand(1000, 10000);
		
		$query = "
			SELECT * 
			FROM " . $table . "
			WHERE 
			user_id=" . $user_id
		;
		
		$result = $db->Execute($query);
		
		unset($rec);
		$rec = array();
		$rec['user_id'] = $new_id;
		$rec['user_core_permission'] = 63;
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);

		unset($rec);
		$rec = array();
		$rec['template_title'] = "barnraiser_01";

		$table = $core_config['db']['prefix'] .	"_template";
		
		$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $db->Execute($query);
		
		$db->Close();
		
// 		$dir = DIR_NAME . "aroundme/components/core/config/";
		
		if (isset($_SESSION['ftp_server'])) {
			$conn = @ftp_connect($_SESSION['ftp_server']);
		}
		else {
			echo $lang['error_fail_connect_server'];
			return false;
		}
		
		if ($conn && isset($_SESSION['ftp_username']) && isset($_SESSION['ftp_password'])) {
			$result = @ftp_login($conn, $_SESSION['ftp_username'], $_SESSION['ftp_password']);
		}
		else {
			echo $lang['error_fail_login_server'];
			return false;
		}
		
		$list = ftp_nlist($conn, '.');
    	
    	$dir = "/" . $list[0] . "/" . DIR_NAME; 
		
// 		// cleanup

		$dirs = array();
		$dirs[] = $dir . "aroundme/components/core/language/1/barnraiser_01/common.lang.php";
		$dirs[] = $dir . "aroundme/components/core/config/aroundme_core.config.php";
		
		if (function_exists('ftp_chmod')) {
			foreach($dirs as $d) {
				if (!ftp_chmod($conn, 0664, $d)) {
					echo $lang['error_fail_permission'] . $d;
					ftp_close($conn);
					return false;
				}
			}
		}
		else {
			foreach($dirs as $d) {
				if (!ftp_site($conn, 'CHMOD 0664 ' . $d)) {
					echo $lang['error_fail_permission'] . $d;
					ftp_close($conn);
					return false;
				}
			}
		}

		// Do some more cleanup here...?
		ftp_close($conn);
		return true;
	}

?>

	<form method="post" action="install.php">
	<input type="hidden" name="step" value="8" />

	<p><?php echo $lang['txt_step_8']; ?></p>
	<?php if (isset($_POST['frm_send'])) { ?>
	
		<div class="message">
			<?php if (am_register($_POST)) { header("location: install.php?step=9"); exit; } ?>
		</div>
		
	<?php } ?>
	<table width="100%">
		<tr>
			<td><?php echo $lang['txt_step_8_register_email']; ?></td>
			<td><input type="text" name="register_email" value="<?php echo isset($_POST['register_email']) ? $_POST['register_email'] : ''; ?>" /></td>
		</tr>
		<tr>
			<td><?php echo $lang['txt_step_8_register_firstname']; ?></td>
			<td><input type="text" name="register_fname" value="<?php echo isset($_POST['register_fname']) ? $_POST['register_fname'] : ''; ?>"/></td>
		</tr>
		<tr>
			<td></td>
			<td></td>
			<td><input type="submit" name="frm_send" value="register" /></td>
		</tr>
	</table>	
	</form>