<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<style type="text/css">
<!--
@import url(<?php echo $template_path;?>css/aroundme_form.css);
-->
</style>


<form action="index.php?amn=core_maint_user_view" method="post" name="frm" id="id_frm">
<input type="hidden" name="user_id" value="<?php echo $user['user_id'];?>" />

<div class="col_left1">
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_user'];?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<tr>
						<td colspan="2">
							<a href="index.php?amn=core_profile.php&amp;identity_id=<?php echo $identity['identity_id'];?>"><b><?php echo $user['user_firstname'] . " " . $user['user_surname'];?></b></a><br />
						</td>
					</tr>
					<tr>
						<td width="40%">
							<?php echo $lang['txt_user_id'];?><br />
						</td>
						<td width="60%">
							<?php echo $user['user_id'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_user_email'];?><br />
						</td>
						<td>
							<a href="mailto:<?php echo $user['user_email'];?>"><?php echo $user['user_email'];?></a><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_location'];?><br />
						</td>
						<td>
							<?php echo $user['location_name'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_dob'];?><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($user['user_dob'], 1);?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_user_create_datetime'];?><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($user['user_create_datetime'], 1);?><br />
						</td>
					</tr>
				</table>
				
				<p>
					<b><?php echo $lang['txt_update_info'];?></b><br />
				</p>
				
				<p>
					<label for="id_language"><?php echo $lang['txt_language'];?></label>
					<select id="id_language" name="language_id" size="1">
						<?php 
						foreach($lang['arr_lang_name'] as $key => $i): 
						?>
						<option value="<?php echo $key;?>" <? if($user['language_id'] == $key) echo "selected=\"selected\"";?>><?php echo ucfirst($i);?></option>
						<?php
						endforeach;
						?>
					</select>
					<br />
				</p>
				
				<p>
					<label for="id_status"><?php echo $lang['txt_status'];?></label>
					<select id="id_status" name="status_id" size="1">
						<?php
						foreach($lang['user_reg_status'] as $key => $i): 
						?>
						<option value="<?php echo $key;?>" <? if($user['status_id'] == $key) echo "selected=\"selected\"";?>><?php echo $i;?></option>
						<?php 
						endforeach;
						?>
					</select>
					<br />
				</p>
				
				
				<p>
					<label for="id_role"><?php echo $lang['txt_role'];?></label>
					<select id="id_role" name="role_id" size="1">
						<option value="" selected="selected"><?php echo $lang['txt_none'];?></option>
						<?php 
						foreach($lang['role'] as $key => $i): 
						?>
						<option value="<?php echo $key;?>" <? if($user['role_id'] == $key) echo "selected=\"selected\"";?>><?php echo $i;?></option>
						<?php
						endforeach;
						?>
					</select>
					<br />
				</p>
				
				<?php
				if (isset($lang['membership_type'])) {
				?>
				<p>
					<label for="id_membership_type"><?php echo $lang['txt_membership_type'];?></label>
					<select id="id_membership_type" name="membership_type_id" size="1">
						<?php 
						foreach($lang['membership_type'] as $key => $i): 
						?>
						<option value="<?php echo $key;?>" <? if($user['membership_type_id'] == $key) echo "selected=\"selected\"";?>><?php echo $i;?></option>
						<?php
						endforeach;
						?>
					</select>
					<br />
				</p>
				<?php }?>
				
				<p>
					<label for="id_user_file_allocation"><?php echo $lang['txt_file_allocation'];?></label>
					<input id="id_user_file_allocation" type="text" name="user_file_allocation" class="input1" size="10" value="<?php echo round($user['user_file_allocation']/1000, 2);?>">&nbsp;kb<br />
				</p>
				
				<p>
					<label for="id_user_message_allocation"><?php echo $lang['txt_message_allocation'];?></label>
					<input id="id_user_message_allocation" type="text" name="user_message_allocation" class="input1" size="10" value="<?php echo round($user['user_message_allocation']/1000, 2);?>">&nbsp;kb<br />
				</p>
				
				<hr />
				
				<p align="right">
					<input type="submit" name="update_user" value="<?php echo $lang['sub_update_user'];?>" class="input_submit"><br />
				</p>
			</div>
		</div>
	</div>
</div>

<div class="col_right1">
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_identity'];?></h1>
			</div>
		</div>

		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($identity)) {
					$id_card = $identity;
					include("inc/identity.inc.php");
				}
				?>
			</div>
		</div>
	</div>
	
	<?php
	if ($_SESSION['user_core_permission'] & $resource['user']['permissions']) {
	?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_permissions'];?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($user_resources)) {
				?>
				
				<p>
					<b><?php echo $lang['txt_core_intro'];?></b><br />
				</p>
				
				<table cellspacing="0" cellpadding="2" border="0" width="100%">
					<?php
					foreach($user_resources as $rekey => $re):
					?>
					<tr>
						<?php
						$checked = "";
						if ($user['user_core_permission'] & $user_resources[$rekey]) {
							$checked = "checked=\"checked\"";
						}
						?>
						<td valign="top">
							<?php echo $lang['resource']['user'][$re];?><br />
						</td>
						<td valign="top" width="1" align="right">
							<input type="checkbox" name="permission[user][<?php echo $re;?>]" value="<?php echo $re;?>" <?php echo $checked;?> />&nbsp;
						</td>
					</tr>
					<?php
					endforeach;
					}
					?>
				</table>
				
				<?php
				if (isset($module_resources)) {
				?>
				<p>
					<b><?php echo $lang['txt_module_intro'];?></b><br />
				</p>
				
				<table cellspacing="0" cellpadding="2" border="0" width="100%">
					<?php
					foreach($module_resources as $modrekey => $modre):
					foreach($modre as $mdkey => $re):
					$checked = "";
					if ($user['user_mod_permission'] & $module_resources[$modrekey][$mdkey]) {
						$checked = "checked=\"checked\"";
					}
					?>
					<tr>
						<td valign="top">
							<?php echo $lang['resource']['module'][$re];?><br />
						</td>
						<td valign="top" width="1" align="right">
							<input type="checkbox" name="permission[mod][<?php echo $re;?>]" value="<?php echo $re;?>" <?php echo $checked;?> />&nbsp;
						</td>
					</tr>
					<?php
					endforeach;
					endforeach;
				?>
				</table>
				<?php }?>
					
				<hr />
					
				<p align="right">
					<input name="update_permissions" type="submit" class="input_submit" value="<?php echo $lang['sub_update_permissions'];?>" /><br />
				</p>
				
			</div>
		</div>
	</div>
	<?php }?>
</div>
</form>