<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


class Testimonial {

	var $min_length = 10;
	var $max_length = 260;


	// the constructor -------------------------------------------------------------
	// Sebastian Oblom, 4th October 2006
	//
	function Testimonial($db) {
		$this->db = $db;
	}//EO Testimonial
	
	
	
	// setTestimonial --------------------------------------------------------------
	// sets the testimonial
	// Sebastian Oblom, 4th October 2006
	//
	function setTestimonial($testimonial) {
		$this->testimonial = $testimonial;
	}//EO setTestimonial

	
	
	// selTestimonials ------------------------------------------------------------
	// selects one or more, randomly or not, testimonials from the database
	// Sebastian Oblom, 4th October 2006
	//
	function selTestimonials($my_testimonials = true, $nr = null, $random = false) {

		$query = "
			SELECT t.testimonial_id, t.testifier_identity_id, t.identity_id, 
			t.testimonial_body, t.testimonial_create_datetime, i.identity_nic,
			i2.identity_nic AS identity_nic_reciever
			FROM " . $this->db->prefix . "_user_testimonial t 
			INNER JOIN " . $this->db->prefix . "_user_identity i
			ON t.testifier_identity_id=i.identity_id 
			INNER JOIN " . $this->db->prefix . "_user_identity i2
			ON t.identity_id=i2.identity_id "
		;
		
		if ($my_testimonials) {
			$query .= "WHERE t.identity_id=" . $this->identity_id . " AND ";
		}
		else {
			$query .= "WHERE t.testifier_identity_id=" . $this->identity_id . " AND ";
		}
		
		$query .= "1=1";
		
		$query .= " ORDER BY t.testimonial_create_datetime DESC";

		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}

		
		$temp = array();
		
		if (isset($result->fields)) {
			$counter = 0;
			while(!$result->EOF) {
				
				array_push($temp, $result->fields);
				$result->moveNext();
				if (isset($nr) && !$random) {
					$counter++;
					if ($counter >= $nr) {
						break;
					}
				}
			}
			$result->Close();
		}
		
		if ($random) {

			$temp1 = array();
			$counter = 0;			
			while($temp && $counter <= $nr) {
				$x = rand(0, count($temp) - 1);
				$temp1[] = $temp[$x];
				unset($temp[$x]);
				$temp = array_values($temp);
				$counter++;
			}
			$temp = $temp1;
		}
		return $temp;
	}//EO selTestimonials
	
	
	
	// insertTestimonial ---------------------------------------------------------------
	// inserts a record in the database
	// Sebastian Oblom, 4th October 2006
	//
	function insertTestimonial() {
		
		$rec = array();
		
		$rec['testifier_identity_id'] = $this->testifier_identity_id;
		$rec['identity_id'] = $this->identity_id;
		$rec['testimonial_body'] = $this->testimonial;
		$rec['testimonial_create_datetime'] = time();
		
		$table = $this->db->prefix . "_user_testimonial";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		if (!isset($result->fields)) {
			$error_info = "function=insertRecord class=Testimonial.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO insertTestimonial
	
	
	
	// deleteTestimonial ------------------------------------------------------------------
	// deletes a record from the database
	// Sebastian Oblom, 4th October 2006
	//
	function deleteTestimonial($testimonial_id) {
		
		$query = "
			DELETE from " . $this->db->prefix . "_user_testimonial
			WHERE testimonial_id=" . $testimonial_id
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=deleteRecord class=Testimonial.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO deleteTestimonial

	

	// isOk -------------------------------------------------------------------------
	// checks if there was some errors with the testimonial
	// Sebastian Oblom 4th October 2006
	//
	function isOk() {
		
		if (strlen($this->testimonial) < $this->min_length) {
			$GLOBALS['am_error_log'][] = array('testimonial_short');
		}
		elseif (strlen($this->testimonial) > $this->max_length) {
			$GLOBALS['am_error_log'][] = array('testimonial_long');
		}
		return empty($GLOBALS['am_error_log']);
	}//EO isOk
	
	

	

	// countTestimonials -------------------------------------------------------------------------
	// counts testimonials
	// Tom Calthrop 6th December 2006
	//
	function countTestimonials() {
		
		$query = "
			SELECT count(testimonial_id) as total 
			FROM " . $this->db->prefix . "_user_testimonial 
			WHERE 
			identity_id=" . $this->identity_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			return $result->fields['total'];
			$result->Close();
		}
	}//EO countTestimonials

}

?>