<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// if we receive a module_id and an item_id we display the profile based upon that item
// otherwise if we are logged in we see the registered profile, else the public profile

if (!isset($_SESSION['md5'])) {
	header("Location: index.php?http_referer=" . urlencode($_SERVER['REQUEST_URI']) . "&" . strip_tags(SID));
	exit;
}

$menu_section= "me";

// FILE -----------------------------------
require_once ("class/File.class.php");
$file = new File($db, $core_config['file']);

if (isset($core_config['module'])) {
	$file->core_config_module = $core_config['module'];
}

$file->module_id = 0; // core

$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
$user->file = $file;



// GET VIEWED IDENTITIY ----------------------------------------------
$output_identity_relation = $user->selUserIdentity(null, $_REQUEST['identity_id'], 1);

if (empty($output_identity_relation)) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}


// GET MY IDENTITIY ----------------------------------------------
if (!empty($output_participation)) {
	$output_identity = $user->selUserIdentity(null, $output_participation['identity_id'], 1);
}
else { // we are not participating in this item/module hence we get my registered card
	$user->identity_type = $core_config['user']['identity']['type']['registered'];
	$output_identity = $user->selUserIdentity($_SESSION['user_id'], null, 1);
}


if (empty($output_identity)) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}


if (isset($_REQUEST['respect']) && $_REQUEST['respect'] == 1 ) {
	
	if (isset($_REQUEST['module_id'])) {
		$data['module_id'] = $_REQUEST['module_id'];
	}
	else {
		$data['module_id'] = 0;
	}
	
	if (isset($_REQUEST['item_id'])) {
		$data['item_id'] = $_REQUEST['item_id'];
	}
	else {
		$data['item_id'] = 0;
	}
	
	$data['identity_id'] = $output_identity['identity_id'];
	$data['identity_id_relation'] = $output_identity_relation['identity_id'];
	$data['relation_create_datetime'] = time();
	$data['user_id'] = $_SESSION['user_id'];

	include_once('class/Network.class.php');
	$network = new Network($db, $core_config, $output_identity['identity_id'], $output_identity_relation['identity_id']);
	$network->im = $im;
	
	$network->insertRespect($data);
	
	include_once($language_path_core . 'inc/network_common.inc.php');
	if ($network->isMutual()) {
	
		$message_body = readTxtFile($language_path_core . "texts/im_mutual_respect.txt.php");
		$message_body = str_replace("SYS_KEYWORD_NAME", $output_identity['identity_nic'], $message_body);
 		
 		if ($data['module_id'] != 0) {
	
			if (!empty($core_config['module'])) {
  				foreach($core_config['module'] as $key => $i):
  					$suffix = $core_config['module'][$key]['prefix'];
					if(is_file("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php")) {
						include_once("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php");
					}
				endforeach;
			}

			$suffix = $core_config['module'][$data['module_id']]['prefix'];
			$function_name = "selItemModule_" . $suffix;
		
			if (function_exists($function_name)) {
				$respected_item = $function_name($data['item_id']);
				$message_body = str_replace("SYS_KEYWORD_ITEM", $respected_item['item_title'], $message_body);
				$message_body = str_replace("SYS_KEYWORD_URL", $respected_item['item_url'], $message_body);
			}
		}
		else { // core-respect
			$core_identity_url = "index.php?amn=core_profile&identity_id=" . $data['identity_id'];
			$core_identity_name = $lang['txt_core_profile']; // Move to common.lang.php ?
			$message_body = str_replace("SYS_KEYWORD_ITEM", $core_identity_name, $message_body);
			$message_body = str_replace("SYS_KEYWORD_URL", $core_identity_url, $message_body);
		}
	
		$network->message_body = $message_body;
		$network->message_subject = $lang['txt_subject_mutual'];
		$network->insertRespectMessage($output_identity_relation['identity_id'], $output_identity['user_id'], $output_identity['identity_id']);
	}
	elseif ($core_config['node']['network_mode'] == 1) {
	
		$core_identity_url = "index.php?amn=core_profile&identity_id=" . $data['identity_id'];
		$core_identity_name = $output_identity['identity_nic'];
		$message_body = readTxtFile($language_path_core . "texts/im_respect.txt.php");
		$message_body = str_replace("SYS_KEYWORD_NAME", $core_identity_name, $message_body);
		$message_body = str_replace("SYS_KEYWORD_URL", $core_identity_url, $message_body);
		
		$network->message_body = $message_body;
		$network->message_subject = $lang['txt_subject_respect'];
		$network->insertRespectMessage($output_identity_relation['identity_id'], $output_identity['user_id']);
	}
	
	unset($network);
}



// MODULE HEADER INCLUSION -----------------------------------------------
// We include any header files for the modules
if (empty($suffix)) {
	$suffix = "core";
}

if (is_file("components/" . $suffix . "/inc/" . $suffix . "_profile.header.php")) {
	include_once("components/" . $suffix . "/inc/" . $suffix . "_profile.header.php");
}


$file->module_id = 0; // core

// GET THEIR RESPECTED NETWORK ---------------------------------------
$participation->not_user_id = $_SESSION['user_id'];


$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];


require_once ("components/core/class/Testimonial.class.php");
$testimonial = new Testimonial($db);
$testimonial->identity_id = $output_identity_relation['identity_id'];
$testimonial->testifier_identity_id = $output_identity['identity_id'];

$output_testimonials = $testimonial->selTestimonials(true, 2, true);

if (isset($output_testimonials)) {
	$body->set('testimonials', $output_testimonials);
}

// count testimonials
$output_identity_relation['testimonial_count'] = $testimonial->countTestimonials();



// GET THE INVITEE
if (!empty($output_identity_relation['invitee_user_id'])) {
	
	$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
	$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
	
	$output_invitee_identity = $user->selUserIdentity($output_identity_relation['invitee_user_id']);
	
	// get the invitee testimonial
	if (!empty($output_invitee_identity)) {
		$testimonial->user_id = $output_invitee_identity['user_id'];
		$output_testimonial = $testimonial->selTestimonials(false, 1);
		
		if (!empty($output_testimonial[0])) {
			$output_invitee_identity['testimonial'] = $output_testimonial[0];
		}
		
		$body->set('invitee_identity', $output_invitee_identity);
	}
}



// get metadata
$query = "
	SELECT identity_metadata 
	FROM " . $db->prefix . "_user_identity 
	WHERE 
	identity_id=" . $output_identity_relation['identity_id'] . " AND 
	identity_search=1"
;
			
$result = $db->Execute($query);
			
if (isset($result->fields)) {
	if (!empty($result->fields['identity_metadata'])) {
		$identity_metadata = explode(',', $result->fields['identity_metadata']);
		sort($identity_metadata);
		$body->set('identity_metadata', $identity_metadata);
	}
}


// blocked ---------------------------------------
$user->user_id = $_SESSION['user_id'];

if ($user->checkBlockStatus($output_identity_relation['user_id'])) {
	$output_identity_relation['blocking'] = 1;
}


// GET AND SET TAGS ---------------------------------------------
require_once('components/core/class/Tag.class.php');
$tag = new Tag($db, null, $core_config['tag']['core']['network']);
$tag->user_id = $_SESSION['user_id'];
$tag->item_id = $output_identity_relation['user_id'];

if (isset($_POST['insert_tag'])) {
	if (empty($_POST['tag_id'])) { // we insert
		$tag->insertTag($_POST['tag_body']);
	}
	elseif (!empty($_POST['tag_id']) && empty($_POST['tag_body'])) { // we delete
		$tag->deleteTag($_POST['tag_id']);
	}
	else { // we update tag
		$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
	}
}
elseif (isset($_POST['delete_tag'])) {
	$tag->deleteTag($_POST['tag_id']);
}
elseif (isset($_REQUEST['edit_tag'])) {
	$output_tag = $tag->selTag($_REQUEST['edit_tag']);

	if (!empty($output_tag)) {
		$body->set('tag', $output_tag);
	}
}

$output_tags = $tag->selTags();

if (!empty($output_tags)) {
	$body->set('tags', $output_tags);
}



if (is_file($language_path . "/inc/profile.lang.inc.php")) {
	include_once ($language_path . "/inc/profile.lang.inc.php");
}


$body->set('identity', $output_identity_relation);


// SETUP NETWORK -------------------------------------------------------
include_once('class/Network.class.php');
$network = new Network($db, $core_config, $output_identity['identity_id'], $output_identity_relation['identity_id']);
$output_matrix = $network->selMatrix($output_identity['identity_id'], $output_identity_relation['identity_id']);




// we need my identities.
$query = "
	SELECT i.identity_id
	FROM " . $db->prefix . "_user_identity i
	WHERE i.user_id=" . $_SESSION['user_id']
;

$result = $db->Execute($query);

if (isset($result->fields)) {
	$temp_identity_ids = array();
	while(!$result->EOF) {
		array_push($temp_identity_ids, $result->fields['identity_id']);
		$result->moveNext();
	}
	$result->Close();
}
else {
	$error_info = "script=profile.php -- " . $query . " -- " . $db->ErrorMsg();
	$GLOBALS['am_error_log'][] = array('db_error', $error_info);
}

if (!empty($output_matrix) && !in_array($output_identity_relation['identity_id'], $temp_identity_ids)) {
	$body->set('matrix', $output_matrix);
}

$query = "
	SELECT r.identity_id_relation
	FROM " . $db->prefix . "_relation r
	WHERE r.identity_id=" . $output_identity_relation['identity_id'] . " AND r.identity_id_relation
	NOT IN (" . implode(',', $temp_identity_ids) . ")"
;

$result = $db->Execute($query);
$temp_identity_ids = array();
$output_network = array();

if (isset($result->fields)) {
	while(!$result->EOF) {
		array_push($temp_identity_ids, $result->fields['identity_id_relation']);
		$result->moveNext();
	}
	$result->Close();
}
else {
	$error_info = "script=profile.php -- " . $query . " -- " . $db->ErrorMsg();
	$GLOBALS['am_error_log'][] = array('db_error', $error_info);
}

$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
unset($user->identity_type);

foreach($temp_identity_ids as $i):
	$output_network_me[] = $network->selMatrix($output_identity['identity_id'], $i);
	$output_network_you[] = $network->selMatrix($output_identity_relation['identity_id'], $i);
	$output_network[] = $user->selUserIdentity(null, $i); 
endforeach; 
$output_network['identity'] = $user->selUserIdentity(null, $output_identity_relation['identity_id']);


if (isset($output_network_you)) {
	$body->set('network_me', $output_network_me);
	$body->set('network_you', $output_network_you);
	$body->set('network', $output_network);
}

$lang['txt_respected_network_intro'] = str_replace('SYS_KEYWORD_NAME', $output_identity_relation['identity_nic'], $lang['txt_respected_network_intro']);


// get user ledger ------------------------------------------------------
if (isset($output_identity['user_id']) && $core_config['user']['include_ledger'] == 1) {
	include_once('components/core/class/UserLedger.class.php');
	$ledger = new UserLedger($db, $core_config);
	
	$output_ledger = $ledger->selUserLedger($output_identity_relation['user_id']);
	
	if (!empty($output_ledger)) {
		$body->set('ledger', $output_ledger);
	}

	include_once ($language_path_core . "/inc/user_ledger.inc.php");
}

	
// MODULE FOOTER INCLUSION -----------------------------------------------
// We include any footer files for the modules
if(is_file("components/" . $suffix . "/inc/" . $suffix . "_profile.footer.php")) {
	include_once("components/" . $suffix . "/inc/" . $suffix . "_profile.footer.php");
}

?>