<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

if(isset($_SESSION['connection_permission']) && checkPermission('core', 'edit_webpages', $_SESSION['connection_permission'])) {

	require_once($language_path . 'admin_webpage.lang.php');
	require_once($language_path . 'html_edit.lang.php');
	
	
	if (isset($_POST['update_webpage'])) {
		if (empty($_POST['webpage_title'])) {
			$GLOBALS['am_error_log'][] = array('title_empty');
		}
		
		// we look for incorrectly formatted interlinks
		$pattern = "/<interlink name=\"(.*?)\">(.*?)<\/interlink>/";

		$webpage_body = stripslashes($_POST['webpage_body']);
		
		if(preg_match_all($pattern, $webpage_body, $interlinks, PREG_PATTERN_ORDER)) {

			if (!empty($interlinks[1])) {
				foreach ($interlinks[1] as $key => $i):
					// strip off any anchors
					$anchor_position = strrpos($i, "#");

					if ($anchor_position > 0 ) {
						$i = substr($i, 0, $anchor_position);
					}
					
					$pattern = "/^[a-zA-Z0-9]*$/";
					
					if (!preg_match($pattern, $i)) {
						$GLOBALS['am_error_log'][] = array('interlink_bad_chars', $i);
					}
					
					
					if (strlen($i) > 30) { // link too long
						$GLOBALS['am_error_log'][] = array('interlink_too_long', $i);
					}

					$anchor_position = strrpos($i, "#");
				endforeach;
			}
		}

		if (empty($GLOBALS['am_error_log'])) {

			// Apply xhtml &
			$_POST['webpage_body'] = str_replace("&amp;", "&", $_POST['webpage_body']);
			$_POST['webpage_body'] = str_replace("&", "&amp;", $_POST['webpage_body']);

			
			if (!empty($_POST['webpage_name'])) { // we insert a new page
		
				$rec = array();
				$rec['webpage_title'] = $_POST['webpage_title'];
				$rec['webpage_body'] = $_POST['webpage_body'];
				$rec['webpage_name'] = $_POST['webpage_name'];
				$rec['webspace_id'] = $_SESSION['webspace_id'];
				$rec['webpage_create_datetime'] = time();
		
				$table = $db->prefix . "_webpage";
				
				$db->insertDb($rec, $table);
		
				$_REQUEST['wp'] = $db->insertID();
			}
			elseif (!empty($_POST['webpage_id'])) { // we update the page
			
				$_POST['webpage_title'] = strip_tags($_POST['webpage_title']);
				
				$query = "
					UPDATE " . $db->prefix . "_webpage
					SET
					webpage_title=" . $db->qstr($_POST['webpage_title']) . ",  
					webpage_body=" . $db->qstr($_POST['webpage_body']) . " 
					WHERE
					webpage_id=" . $_POST['webpage_id']
				;
				
				$result = $db->Execute($query);
		
				$_REQUEST['wp'] = $_POST['webpage_id'];
				
			}

			$_SESSION['am_message_log'][] = array($lang['message']['webpage_saved']);
		}
		else {
			if (!empty($_POST['webpage_name'])) {
				$body->set('webpage_name', $_POST['webpage_name']);
			}
			
			$_POST['webpage_body'] = stripslashes($_POST['webpage_body']);

			$output_webpage = $_POST;

			$body->set('webpage', $output_webpage);

			
		}
	}
	
	if (!empty($_REQUEST['wpn']) && empty($output_webpage)) {
		// we should only get a page name when we are adding a page, but we check it first
		
		$query = "
			SELECT *
			FROM " . $db->prefix . "_webpage
			WHERE webpage_name=" . $db->qstr($_REQUEST['wpn']) ." AND
			webspace_id=" . $_SESSION['webspace_id']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result[0])) {
			$output_webpage = $result[0];
		
			$body->set('webpage', $output_webpage);
		}
		else {
			$output_webpage_name = trim($_REQUEST['wpn']);
	
			unset ($body->vars['webspace']['webpage_id']);
			$body->set('webpage_name', $output_webpage_name);
		}
	}
	elseif (!empty($_REQUEST['wp']) && empty($output_webpage)) { // we are editing a page
		$query = "
			SELECT *
			FROM " . $db->prefix . "_webpage
			WHERE webpage_id=" . $_REQUEST['wp']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result[0])) {
			$output_webpage = $result[0];

			// remove xhtml &
			$output_webpage['webpage_body'] = str_replace("&amp;", "&", $output_webpage['webpage_body']);
		
			$body->set('webpage', $output_webpage);
		}
	}
	
	if (!isset($output_webpage_name) && !isset($output_webpage)) {
		header("Location: index.php?ws=" . $output_webspace['webspace_id'] . "&t=admin_webpages&" . strip_tags(SID));
		exit;
	}
	
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_file
		WHERE webspace_id=" . $_SESSION['webspace_id'] . " AND
		file_type LIKE 'image/%'"
	;
	
	$output_images = $db->Execute($query);
	if (!empty($output_images)) {
		$body->set('images', $output_images);
	}
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_file
		WHERE webspace_id=" . $_SESSION['webspace_id'] . " AND
		file_type NOT LIKE 'image/%'"
	;
	
	$output_files = $db->Execute($query);
	if (!empty($output_files)) {
		$body->set('files', $output_files);
	}
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_webpage
		WHERE webspace_id=" . $_REQUEST['ws']
	;
	
	$output_pages = $db->Execute($query);
	if (!empty($output_pages)) {
		$body->set('pages', $output_pages);
	}
}
else { // no permission to be here
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}
?>