<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

	<?php
	if (isset($webspace['language_code'])) {
	?>
	<meta http-equiv="Content-Language" content="<?php echo $webspace['language_code'];?>" />
	<?php }?>
	<?php
	if (isset($webspace['webspace_keywords'])) {
	?>
	<meta name="keywords" content="<?php echo $webspace['webspace_keywords'];?>" />
	<?php }?>
	<?php
	if (isset($webspace['webspace_description'])) {
	?>
	<meta name="Description" content="<?php echo $webspace['webspace_description'];?>" />
	<?php }?>

	<?php
	if (isset($webspace['webspace_title'])) {
	?>
	<title><?php echo $webspace['webspace_title'];?></title>
	<?php
	}
	else {
	?>
	<title><?php echo $lang['txt_page_title'];?></title>
	<?php }?>
	
	
	<style type="text/css">
	<!--
	@import url(<?php echo $template_path_core;?>css/aroundme.css);
	-->
	</style>
	
	<!--[if IE]>
	<style type="text/css">
	@import url(<?php echo $template_path_core;?>css/aroundme-IE.css);
	</style>
	<![endif]-->

	<style type="text/css">
	<!--
	<?php
	if (isset($webspace['webspace_css'])) {
		echo $webspace['webspace_css'];
	}
	?>
	-->
	</style>
	

	<?php
	//we reload an image in this template just before the session times out to
	//make sure that the session does not time out
	$session_maxlifetime = ini_get('session.gc_maxlifetime'); // in seconds
	
	// we need to warn 2 minutes before
	$session_warning_time = 120; // seconds
	if ($session_maxlifetime > $session_warning_time) {
		$session_maxlifetime = $session_maxlifetime-$session_warning_time;
	}
	$session_maxlifetime_ms = $session_maxlifetime*1000; // in milliseconds
	?>

	<script type="text/javascript" src="<?php echo $template_path_core;?>js/functions.js"></script>

	<script type="text/javascript">
	//<![CDATA[
		var session_maxlifetime_ms = <?php echo $session_maxlifetime_ms;?>;

		function ShowTimeoutWarning () {
			// we append the time to the string to avoid caching
			var urldate = new Date()
			var urltime = urldate.getTime()
			document.session_reload_image.src = 'components/core/relay/get_file.php?file=session-reload-image.png_image/png&reloadsession=start&now=' + urltime;
			setTimeout( 'ShowTimeoutWarning();', session_maxlifetime_ms );
		}
	//]]>
	</script>
</head>

<body onload="setTimeout( 'ShowTimeoutWarning();', session_maxlifetime_ms );">

<div id="header_container">
	<div class="menu" style="float:right">
		
		<?php
		if (isset($webspace['webspace_id']) && empty($webspace['webspace_locked'])) {
		?>
			<a href="feed/rss.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['webpage_id'];?>" class="rss"><img src="<?php echo $template_path_core;?>img/rss.png" width="16" height="16" border="0" alt="RSS" /></a>
		<?php }?>
		<br />

	</div>

	<div class="logo" style="float:left;">
		<a href="about.php"><img src="<?php echo $template_path_core;?>img/flower.png" width="30" height="30" border="0" alt="<?php echo $lang['alt_flower_logo'];?>" /></a><br />
	</div>
	
	<div class="menu">
		<?php
		if (isset($webspace['webspace_id'])) {
		?>
			<?php
			$link_css = "";
			if (!isset($script_name) && $webspace['default_webpage_id'] == $webspace['webpage_id']) {
				$link_css = " class=\"highlight\"";
			}
			?>
			<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['default_webpage_id'];?>"<?php echo $link_css;?>><?php echo $lang['href_home'];?></a>
			
			&nbsp;&#124;&nbsp;
	
			
			<?php
			$link_css = "";
			if (isset($script_name) && $script_name == "connect") {
				$link_css = " class=\"highlight\"";
			}
	
			if (isset($_SESSION['connection_id'])) {
				$lang['href_connect'] = $lang['href_connected'];
			}
			?>
			<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;t=connect"<?php echo $link_css;?>><?php echo $lang['href_connect'];?></a>
			
			&nbsp;&#124;&nbsp;

			<?php
			$link_css = "";
			if (isset($script_name) && $script_name == "search") {
				$link_css = " class=\"highlight\"";
			}
			?>
			<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;t=search"<?php echo $link_css;?>><?php echo $lang['href_find'];?></a>
			

			<?php
			if(!isset($script_name) && isset($_SESSION['connection_permission']) && checkPermission('core', 'edit_webpages', $_SESSION['connection_permission'])) {
			?>
			&nbsp;&#124;&nbsp;
			
			<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;t=admin_webpage"><?php echo $lang['href_edit_this_webpage'];?></a>
			<?php }?>

			<?php
			if(!isset($script_name) && isset($_SESSION['connection_permission']) && checkPermission('core', 'edit_stylesheet', $_SESSION['connection_permission'])) {
			?>
			&nbsp;&#124;&nbsp;
	
			<a href="#" onclick="javascript:launchPopupWindow('components/core/popup_stylesheet.php?ws=<?php echo $webspace['webspace_id'];?>', 'stylesheet editor');"><?php echo $lang['href_style_this_webspace'];?></a>
	
			<?php }?>
		<?php }?>
	</div>
</div>

<?php
if (!empty($GLOBALS['am_error_log'])) {
?>
<div id="error_log_container">
	<div class="content">
		<?php
		foreach($GLOBALS['am_error_log'] as $key => $i):
		?>
			<?php
			if (isset($lang['error'][$i[0]])) {
				echo $lang['error'][$i[0]];
			}
			else {
				echo $i[0];
			}
	
			if (!empty($i[1])) {
				echo ": " . $i[1];
			}?>
			<br />
		<?php
		endforeach;
		?>
	</div>
</div>
<?php }?>


<div id="message_log_container" style="display:none;">
	<?php
	if (!empty($_SESSION['am_message_log'])) {
	?>

	<script type="text/javascript">
	//<![CDATA[
		document.getElementById('message_log_container').style.display = 'block';
	//]]>
	</script>
	<div class="content">
		<?php
		foreach($_SESSION['am_message_log'] as $key => $i):
		?>
			<?php
			if (isset($lang['message'][$i[0]])) {
				echo $lang['message'][$i[0]];
			}
			else {
				echo $i[0];
			}
	
			if (!empty($i[1])) {
				echo ": " . $i[1];
			}?>
			<br />
		<?php
		endforeach;
		unset($_SESSION['am_message_log']);
		?>
	</div>
	<?php }?>
	<script type="text/javascript">
	//<![CDATA[
	hide_timer_ms = 3*1000; // in milliseconds

	function HideLog () {
		document.getElementById('message_log_container').style.display = 'none';
	}

	setTimeout( 'HideLog();', hide_timer_ms );
	//]]>
	</script>
</div>

<div id="body_container">
	<?php echo $content;?>
</div>

<div id="footer_container">
	<div class="footer_menu">
		<?php
		if ($core_config['am']['mode'] < 1) {
			$link_css = "";
			if (isset($script_name) && $script_name == "overview") {
				$link_css = " class=\"highlight\"";
			}
			?>
			<a href="<?php echo $core_config['am']['overview_url'];?>"<?php echo $link_css;?>><?php echo $lang['href_list'];?></a>
	
			&nbsp;&#124;&nbsp;
		<?php }?>
		
		<?php
		if ($core_config['am']['webspace_creation_type'] === 1 || $core_config['am']['webspace_creation_type'] === 2) {
		?>
			<?php
			$link_css = "";
			if (isset($script_name) && $script_name == "create_webspace") {
				$link_css = " class=\"highlight\"";
			}
			?>
			<a href="create_webspace.php"<?php echo $link_css;?>><?php echo $lang['href_create'];?></a>

			&nbsp;&#124;&nbsp;
		<?php }?>

		<?php
		$link_css = "";
		if (isset($script_name) && $script_name == "about" && isset($_REQUEST['v']) && $_REQUEST['v'] == "policy") {
			$link_css = " class=\"highlight\"";
		}
		?>
		<a href="about.php?v=policy"<?php echo $link_css;?>><?php echo $lang['href_policy'];?></a>

		&nbsp;&#124;&nbsp;

		<?php
		$link_css = "";
		if (isset($script_name) && $script_name == "about" && !isset($_REQUEST['v'])) {
			$link_css = " class=\"highlight\"";
		}
		?>
		<a href="about.php"<?php echo $link_css;?>><?php echo $lang['href_about'];?></a>

		&nbsp;&#124;&nbsp;

		<?php
		if (isset($webspace['webspace_id']) && empty($webspace['webspace_locked'])) {
		?>
			<a href="feed/rss.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['webpage_id'];?>" class="rss"><?php echo $lang['href_rss'];?></a>

			&nbsp;&#124;&nbsp;
		<?php }?>

		<?php echo $lang['txt_strap'];?><br />
	</div>
</div>

<img name="session_reload_image" src="components/core/relay/get_file.php?file=session-reload-image.png_image/png" alt="" />
</body>
</html>