<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// MAIN INCLUDES ---------------------------------------------------------
include ("../components/core/config/core.config.php");

// SETUP DATABASE ------------------------------------------------------
require_once('../components/core/class/Db.class.php');
$db = new Database($core_config['db']);


// SETUP WEBSPACE ------------------------------------------------------
$query = "
	SELECT webspace_locked, language_code, webspace_description,
	webspace_title, webspace_unix_name, webspace_id 
	FROM " . $db->prefix . "_webspace
	WHERE
	webspace_id=" . $_REQUEST['ws']
;

$result = $db->Execute($query, 1);

if (isset($result[0])) {
	$output_webspace = $result[0];
}


if (!empty($output_webspace)) {
	if (empty($output_webspace['webspace_locked'])) {
		// GATHER ITEMS --------------------------------------------------------
		if ($handle = opendir('../components')) {
		while (false !== ($file = readdir($handle))) {
			if ($file != "." && $file != ".." && $file != "core") {
				$output_plugins[] = $file;
			}
		}
		closedir($handle);
		}
		
		// //create URL
		$url = "http://" . $_SERVER['HTTP_HOST'];
		$url .= dirname ($_SERVER['PHP_SELF']);
		//sometimes the server adds / as the last character - we need to check.
		if (substr($url, -1, 1) != "/") {
			$url .= "/";
		}
	
		$url .= "../";
		
		$items = array();
		
		if (!empty($output_plugins)) {
			foreach($output_plugins as $key => $p):
				if (is_file("../components/" . $p . "/inc/plugin_rss.inc.php")) {
					include_once ("../components/" . $p . "/inc/plugin_rss.inc.php");
				
					$function_name = "am_plugin_" . $p . "_getItemsArray";
					
					if (function_exists($function_name)) {
						$rss_results = $function_name();
		
						if (!empty($rss_results)) {
							foreach ($rss_results as $item_key => $i):
								array_push($items, $i);
							endforeach;
						}
					}
				}
			endforeach;
		}
	
		if (empty($output_webspace['language_code'])) {
			$output_webspace['language_code'] = "en";
		}

		// build the source url
		if (!empty($core_config['am']['mode']) && $core_config['am']['mode'] > 0) { // single webspace configuration
			$domain_url = "http://" . $_SERVER['HTTP_HOST'];
		}
		else {
			$domain_parts = explode('.', $_SERVER['HTTP_HOST'], 2);
			$domain = $domain_parts[1];
		
			$domain_url = "http://" . $output_webspace['webspace_unix_name'] . "." . $domain;
		}
		
		header("Content-Type: application/xml; charset=ISO-8859-1");
		
		echo "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n";
		echo "<?xml-stylesheet title=\"XSL_formatting\" type=\"text/xsl\" href=\"nolsol.xsl\"?>\n";
		echo "<rss version=\"2.0\">\n";
		echo "<channel>\n";
		echo "<title>" . utf8_decode($output_webspace['webspace_title']) . "</title>\n";
		echo "<link>" . $domain_url . "</link>\n";
		echo "<description>" . utf8_decode($output_webspace['webspace_description']) . "</description>\n";
		echo "<language>" . $output_webspace['language_code'] . "</language>\n";
		echo "<lastBuildDate>" . date("r") . "</lastBuildDate>\n";
		
		if (!empty($items)) {
			foreach ($items as $key => $i):
				echo "<item>\n";
				echo "<title>" . utf8_decode($i['title']) . "</title>\n";
				echo "<description>" . utf8_decode($i['description']) . "</description>\n";
				echo "<link>" . $i['link'] . "</link>\n";
				echo "<pubDate>" . $i['datetime'] . "</pubDate>\n";
				echo "</item>";
			endforeach;
		}
		
		echo "</channel>\n";
		echo "</rss>";
	}
}
?>