<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

if(isset($_SESSION['connection_permission']) && checkPermission('core', 'maintain_connections', $_SESSION['connection_permission'])) {


	require_once($language_path . 'admin_network.lang.php');
	
	if (!empty($_POST['update_connection'])) {
	
		if (!empty($_POST['status_id'])) {
			$status_id = $core_config['connection']['status']['barred'];
		}
		else {
			$status_id = $core_config['connection']['status']['active'];
		}
	
		// update permissions
		$permission_value = 0;
	
		if (!empty($_POST['bitwise_operators'])) {
			foreach ($_POST['bitwise_operators'] as $key => $i):
				$permission_value = $permission_value+$i;
			endforeach;
		}
		
		$query = "
			UPDATE " . $db->prefix . "_connection
			SET
			status_id=" . $status_id . ",
			connection_permission=" . $permission_value . " 
			WHERE 
			connection_id=" . $_POST['connection_id']
		;
		
		$result = $db->Execute($query);

		if ($_POST['connection_id'] == $_SESSION['connection_id']) {
			$_SESSION['connection_permission'] = $permission_value;
		}
		
		$_REQUEST['connection_id'] = $_POST['connection_id'];
	}
	elseif (!empty($_POST['connection_ids'])) {
	
		if (isset($_POST['unblock_connections'])) {
			$status_id = $core_config['connection']['status']['active'];
		}
		elseif (isset($_POST['block_connections'])) {
			$status_id = $core_config['connection']['status']['barred'];
		}
	
		$query = "
			UPDATE " . $db->prefix . "_connection
			SET
			status_id=" . $status_id . " 
			WHERE 
			connection_id in (" . implode(",", $_POST['connection_ids']) . ")"
		;
	
		$result = $db->Execute($query);
	}
	elseif (isset($_POST['update_default_permission'])) {
	
		$default_permission = 0;

		if (!empty($_POST['bitwise_operators'])) {
			foreach($_POST['bitwise_operators'] as $p):
				$default_permission += $p;
			endforeach;
		}
	
		$query = "
			UPDATE
			" . $db->prefix . "_webspace
			SET default_permission=" . $default_permission . "
			WHERE webspace_id=" . $_SESSION['webspace_id'] . ""
		;
		
		$db->Execute($query);
	}
	
	if (isset($_REQUEST['default_permissions'])) {
		// get permissions
		$query = "
			SELECT *
			FROM " . $db->prefix . "_permission
			ORDER BY plugin_name"
		;
	
		$result = $db->Execute($query);
	
		if (isset($result)) {
			$output_permissions = $result;
		}
		
		$query = "
			SELECT default_permission
			FROM " . $db->prefix . "_webspace
			WHERE webspace_id=" . $_SESSION['webspace_id']
		;
		
		$result = $db->Execute($query);
		
		$body->set('default_permission', $result[0]['default_permission']);
	}
	elseif (isset($_REQUEST['connection_id'])) {
		$query = "
			SELECT connection_id, connection_openid, connection_nickname, connection_email,
			connection_fullname, connection_country, connection_language,
			UNIX_TIMESTAMP(connection_create_datetime) as connection_create_datetime,
			UNIX_TIMESTAMP(connection_last_datetime) as connection_last_datetime,
			status_id, connection_permission, invitee_connection_id 
			FROM " . $db->prefix . "_connection 
			WHERE
			webspace_id=" . $_SESSION['webspace_id'] . " AND 
			connection_id=" . $_REQUEST['connection_id']
		;
		
		$result = $db->Execute($query);
	
		if (isset($result[0])) {
			
			$body->set('connection', $result[0]);
		}
	
		// get permissions
		$query = "
			SELECT *
			FROM " . $db->prefix . "_permission
			ORDER BY plugin_name"
		;
	
		$result = $db->Execute($query);
	
		if (isset($result)) {
			$output_permissions = $result;
		}
	}
	
	
	
	$query = "
		SELECT connection_id, connection_openid, connection_nickname, connection_email,
		connection_fullname, connection_country, connection_language,
		UNIX_TIMESTAMP(connection_create_datetime) as connection_create_datetime,
		UNIX_TIMESTAMP(connection_last_datetime) as connection_last_datetime,
		status_id, connection_permission, invitee_connection_id 
		FROM " . $db->prefix . "_connection 
		WHERE webspace_id=" . $_SESSION['webspace_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		$output_connections = $result;
	
		if (!empty($output_connections)) {
			$body->set('connections', $output_connections);
		}
	}
	
	if (!empty($output_permissions)) {
		$body->set('permissions', $output_permissions);
		
		// build the language pack for permissions labels
		foreach ($output_permissions as $key => $i):
	
			if (is_file("components/" . $i['plugin_name'] . "/language/" . $_SESSION['language_code'] . "/common.lang.php")) {
				include_once("components/" . $i['plugin_name'] . "/language/" . $_SESSION['language_code'] . "/common.lang.php");
			}
		endforeach;
	}
}
else { // no permission to be here
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}
?>