<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


// PLUGIN: Barnraiser Guestbook

function plugin_guestbook ($attributes=null) {

	global $db, $ws, $output_webspace, $body, $core_config;

	if (!isset($attributes['block'])) {
		$attributes['block'] = "list";
	}

	if ($attributes['block'] == "list") { // select multiple guestbooks
	
		// paging...
		$query = "
			SELECT COUNT(gb.guestbook_id) AS total
			FROM " . $db->prefix . "_plugin_guestbook gb
			WHERE webspace_id=" . $output_webspace['webspace_id']
		;
		$result = $db->Execute($query);
		if (isset($result[0]['total'])) {
			$total = $result[0]['total'];
			$body->set('total_nr_of_rows', $total);
		}
		$from = isset($_GET['_frmg']) ? (int) $_GET['_frmg'] : 0;
		// eo paging... 

		$query = "
			SELECT UNIX_TIMESTAMP(gb.guestbook_create_datetime) as guestbook_create_datetime,
			gb.guestbook_body, c.connection_nickname, c.connection_openid
			FROM " . $db->prefix . "_plugin_guestbook gb, " . $db->prefix . "_connection c
			WHERE
			gb.connection_id=c.connection_id AND
			gb.webspace_id=" . $output_webspace['webspace_id'] . "
			ORDER BY gb.guestbook_create_datetime"
		;
		
		if (!isset($attributes['order'])) {
			$query .= " desc";
		}
		
		if (isset($attributes['limit'])) {
			$result = $db->Execute($query, (int) $attributes['limit']);
		}
		else {
			$result = $db->Execute($query, $core_config['display']['max_list_rows'], $from);
		}
		
		if (isset($result)) {
			$body->set('guestbook_list', $result);
		}
	}
}
?>