<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

if(isset($_SESSION['connection_permission']) && checkPermission('poll', 'add_poll', $_SESSION['connection_permission'])) {

	include_once($language_path . 'common.lang.php');

	
	
	
	if (isset($_POST['update_poll'])) {
		if (empty($_POST['poll_question'])) {
			$GLOBALS['am_error_log'][] = array('question_empty');
		}
		
		if (empty($_POST['poll_options'][0]['body']) && empty($_POST['poll_options'][1]['body'])) {
			$GLOBALS['am_error_log'][] = array('options_under_min');
		}

		if (empty($GLOBALS['am_error_log'])) {
			// save poll
			$rec = array();
			$rec['poll_question'] = strip_tags($_POST['poll_question']);
			
			if (!empty($_POST['poll_id'])) { // we update
				
				$poll_id = $_POST['poll_id'];
				
				$query = "
					UPDATE " . $db->prefix . "_plugin_poll
					SET poll_question=" . $db->qstr($rec['poll_question']) . "
					WHERE poll_id=" . $_POST['poll_id']
				;
		
				$db->Execute($query);
	
				$_SESSION['am_message_log'][] = array($lang['message']['poll_saved']);
			}
			else { // we insert
				$rec['poll_create_datetime'] = time();
				$rec['connection_id'] = $_SESSION['connection_id'];
				$rec['webspace_id'] = $_SESSION['webspace_id'];
				
				$table = $db->prefix . "_plugin_poll";
				
				$db->insertDB($rec, $table);
				$poll_id = $db->InsertID();
	
				$_SESSION['am_message_log'][] = array($lang['message']['poll_saved']);
			}
		}
		else {
			// we add 3 empty options for display
			if (!isset($_POST['options'][0])) {
				$_POST['options'][] = "";
			}

			if (!isset($_POST['options'][1])) {
				$_POST['options'][] = "";
			}

			if (!isset($_POST['options'][2])) {
				$_POST['options'][] = "";
			}
		
			$body->set('poll', $_POST);
			unset($_REQUEST['poll_id']);
		}

		
		if (isset($poll_id)) {
			// we delete and insert options
			$query = "
				DELETE FROM " . $db->prefix . "_plugin_poll_option
				WHERE 
				poll_id=" . $poll_id
			;
			
			$result = $db->Execute($query);
			
			// insert options
			if (!empty($_POST['poll_options'])) {
					
				$table = $db->prefix . "_plugin_poll_option";
				
				foreach($_POST['poll_options'] as $key => $i):
					if (!is_numeric($i['order'])) {
						$i['order'] = 0;
					}
					
					$rec = array();
					$rec['poll_id']	= $poll_id;
					$rec['option_body']	= strip_tags($i['body']);
					$rec['option_order']	= $i['order'];
					
					if (!empty($rec['option_body'])) {
						$db->insertDB($rec, $table);
					}
				endforeach;
			}
		
			header("Location: index.php?ws=" . $_REQUEST['ws'] . "&t=admin&c=poll&poll_id=" . $poll_id . "&" . strip_tags(SID));
			exit;
		}
	}
	
	if (!empty($_REQUEST['poll_id'])) {
		$query = "
			SELECT * 
			FROM " . $db->prefix . "_plugin_poll
			WHERE
			webspace_id=" . $_SESSION['webspace_id'] . " AND 
			poll_id=" . $_REQUEST['poll_id']
		;
	
		$result = $db->Execute($query);
		
		if (isset($result[0])) {
	
			$output_poll = $result[0];
	
			// get the options
			$query = "
				SELECT option_id, option_body, option_order
				FROM " . $db->prefix . "_plugin_poll_option
				WHERE
				poll_id=" . $output_poll['poll_id'] . "
				ORDER BY option_order"
			;
	
			$result = $db->Execute($query);
	
			if (isset($result[0])) {
				$output_poll['options'] = $result;
			}
			
			// we add one record to the options
			$output_poll['options'][] = "";
	
			
			$body->set('poll', $output_poll);
		}
	}
	elseif (isset($_REQUEST['add'])) {
		// we add 3 empty options for display
		$output_poll['options'][] = "";
		$output_poll['options'][] = "";
		$output_poll['options'][] = "";
	
		$body->set('poll', $output_poll);
	}
	
	
		
	
	
	// LIST POLLS ----------------------------------------------------
	$query = "
		SELECT poll_id, poll_question, poll_create_datetime
		FROM " . $db->prefix . "_plugin_poll
		WHERE
		connection_id=" . $_SESSION['connection_id'] . "
		ORDER BY poll_question"
	;
	
	$result = $db->Execute($query);
		
	if (isset($result[0])) {
		$output_polls = $result;
	}
	
	
	if (!empty($output_polls)) {
		$body->set('polls', $output_polls);
	}
}
else { // no permission to be here
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}

?>