<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------
?>

<form action="#" name="frm">

<script type="text/javascript">
//<![CDATA[
function getPoll(poll_id, voted) {
	
	var str = "poll_id="+poll_id+"&webspace_id="+<?php echo $webspace['webspace_id'];?>
	
	if (voted) {
		
		poll = document.frm.option_id;

		for (i=0;i<poll.length;i++) {
		
			if (poll[i].checked) {
				
				var vote = poll[i].value;
			}
		}
		
		if (vote) {
			str += "&answer_id="+vote;
			
			makeRequest('components/poll/relay/poll.php', str, receivePoll);
		}
		else {
			alert('please select an option to vote.');
		}
	
	}
	else {
		makeRequest('components/poll/relay/poll.php', str, receivePoll);
	}
}

function receivePoll() {
	if (http_request.readyState == 4) {
		if (http_request.status == 200) {
			xmlDoc = http_request.responseXML;

			poll = xmlDoc.getElementsByTagName("poll")[0];
			document.getElementById('poll').innerHTML = '';

			var frag = document.createDocumentFragment();

			poll_id = poll.getElementsByTagName("poll_id")[0].childNodes[0].nodeValue;
			poll_div = document.createElement('div');
			poll_div.setAttribute('id','poll'+poll_id);
			frag.appendChild(poll_div);
			
			poll_question = document.createElement('span');
			poll_question.setAttribute('class','poll_question');
			poll_question.innerHTML = poll.getElementsByTagName("poll_question")[0].childNodes[0].nodeValue;
			frag.appendChild(poll_question);

			var options = xmlDoc.getElementsByTagName("option");

			options_table = document.createElement("table");
			options_table.setAttribute("width", "100%");

			options_table_body = document.createElement("tbody");
			
			if (poll.getElementsByTagName("my_answer")[0]) { /* display poll */
				
				if (options.length > 0) {
 				
					for (j=0;j<options.length;j=j+1) {
 						// write option TD
 						row = document.createElement("tr");
						
						option_body = options[j].getElementsByTagName("option_body")[0].childNodes[0].nodeValue;
						
						cell = document.createElement("td");
						cell.setAttribute("width", "40%");
						cellText = document.createTextNode(option_body);
						cell.appendChild(cellText);
						row.appendChild(cell);

						option_percent = options[j].getElementsByTagName("option_percent")[0].childNodes[0].nodeValue;
						
						cell = document.createElement("td");
						cell.setAttribute("width", "50%");

						value_table = document.createElement("table");
						value_table.setAttribute("width", "100%");
						value_table_body = document.createElement("tbody");

						value_row = document.createElement("tr");
			
						value_cell = document.createElement("td");
						value_cell.setAttribute("width", option_percent+"%");
						value_cell.setAttribute("height", "7");
						value_cell.setAttribute("class", "bg1");
						value_row.appendChild(value_cell);
			
						value_cell = document.createElement("td");
						value_cell.setAttribute("width", 100-option_percent+"%");
						value_cell.setAttribute("height", "7");
						value_cell.setAttribute("class", "bg2");
						value_row.appendChild(value_cell);

						value_table_body.appendChild(value_row);
						value_table.appendChild(value_table_body);
						

						row.appendChild(value_table);
						
						
						cell = document.createElement("td");
						cell.setAttribute("width", "10%");
						cell.setAttribute("align", "right");
						cellText = document.createTextNode(option_percent+"%");
						cell.appendChild(cellText);
						row.appendChild(cell);
						
 						// add the row to the end of the table body
 						options_table_body.appendChild(row);
 					}
 				}
			}
			else { /* display vote and hide poll*/
				if (options.length > 0) {
 				
					for (j=0;j<options.length;j=j+1) {
 						// write option TD
 						
 						row = document.createElement("tr");
						

						option_body = options[j].getElementsByTagName("option_body")[0].childNodes[0].nodeValue;
						option_value = options[j].getElementsByTagName("option_id")[0].childNodes[0].nodeValue;

						cell = document.createElement("td");
						cellText = document.createTextNode(option_body);
						cell.appendChild(cellText);
						row.appendChild(cell);

						
						input_radio = document.createElement("input");
						input_radio.setAttribute("type", "radio");
						input_radio.setAttribute("name", "option_id");
						input_radio.setAttribute("value", option_value);

						// write radio TD
						cell = document.createElement("td");
						cell.setAttribute("align", "right");
						cell.appendChild(input_radio);
						row.appendChild(cell);
 						// add the row to the end of the table body
 						options_table_body.appendChild(row);
 					}
 				}

			}

			// put the <tbody> in the <table>
 			options_table.appendChild(options_table_body);
			frag.appendChild(options_table);

			if (poll.getElementsByTagName("my_answer")[0]) { /* display poll */

				votes = poll.getElementsByTagName("total_votes")[0].childNodes[0].nodeValue;
				
				para = document.createElement("p");
				para.setAttribute("align", "right");
				cellText = document.createTextNode(votes+" votes");
				para.appendChild(cellText);
				frag.appendChild(para);
			}
			else {
				para = document.createElement("p");
				para.setAttribute("align", "right");

				input_submit = document.createElement("input");
				input_submit.setAttribute("type", "button");
				input_submit.setAttribute("onclick", "javascript:getPoll("+poll_id+",1);");
				input_submit.setAttribute("value", "vote");
				input_submit.setAttribute("class", "input_submit");
				para.appendChild(input_submit);

				frag.appendChild(para);
			}
			
			document.getElementById('poll').appendChild(frag);
		} else {
			alert('<?php echo $lang['txt_ajax_get_poll_error'];?>');
		}
	}
}
//]]>
</script>


<div id="poll" class="plugin_poll">
	<?php echo $lang['txt_connect_for_polls'];?><br />
</div>


<?php
if (isset($_SESSION['connection_id'])) {
?>
<script type="text/javascript">
//<![CDATA[
getPoll(<?php if (isset($poll_id)) { echo $poll_id;}?>);
//]]>
</script>
<?php }?>
</form>