<?php

// -----------------------------------------------------------------------
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
//
// Author: Tom Calthrop - info@barnraiser.org
// Date: 7th March 2006
// Version: 0.1
//
// CONFIGURE -----------------------------------------------------------------
//
$file_password = ""; // insert a password that is secure
//
// -----------------------------------------------------------------------


session_start();

$output = "<h2>Barnraiser language file editor</h2>";

if (isset($_SESSION['session_password']) && $_SESSION['session_password'] == $file_password && $file_password != "") {
	// setup and change directory
	$dir = getcwd() . "/";
	
	if (isset($_REQUEST['langdir']) && $_REQUEST['langdir'] != "..") { // change directory
		$dir = $dir . $_REQUEST['langdir'] . "/";
		chdir($_REQUEST['langdir']);
	}
	
	if (isset($_POST['update'])) {
		$filename = $_POST['form_file'];
		
		$content = stripslashes($_POST['form_body']);
		$content = trim($content);
		
		// Write to file.
		if (is_writable($filename)) {

		   // In our example we're opening $filename in append mode.
		   // The file pointer is at the bottom of the file hence
		   // that's where $somecontent will go when we fwrite() it.
		   if (!$handle = fopen($filename, 'w')) {
				 echo "Cannot open file ($filename)";
				 exit;
		   }
	
		   // Write $somecontent to our opened file.
		   if (fwrite($handle, $content) === FALSE) {
			   echo "Cannot write to file ($filename)";
			   exit;
		   }
		  
		   fclose($handle);

		} else {
		   echo "The file $filename is not writable";
		}
		
		header("Location: language_pack_editor.php?langfile=" . $filename . "&" . strip_tags(SID));
		exit;
	
	}
	elseif (isset($_REQUEST['langfile'])) {
		$langfile = $_REQUEST['langfile'];
		$file_output = "";
		
		$handle = fopen($langfile, "rb");
		
		do {
		   $data = fread($handle, 8192);
		   if (strlen($data) == 0) {
			   break;
		   }
		   $file_output .= $data;
		} while (true);
	
		fclose($handle);
	
		$filename = substr(strrchr($langfile, "/"), 1 );
$output .= <<<eof
	<p>Edit your file -> $filename<br /><p>
	<p><b>backup your language directory BEFORE pressing 'update file'. You can never have too many backups.</b></p>
	
	<form action='language_pack_editor.php' method='post'>
	<input type='hidden' name='form_file' value='$langfile'>
	<textarea name='form_body' cols='83' rows='20' wrap='off'>$file_output</textarea><br />
	<p>
	You are not allowed to alter any copyright notice you see.
	</p>
	<p>
	You may see some UPPERCASE words. These may be special words that the 
	software replaces. If in doubt do not replace those words.
	</p>
	<input type='submit' name='update' value='update file'>
	</form>
eof;

	

	
	}
	else { // list the directory
		if (is_dir($dir)) {
		   if ($dh = opendir($dir)) {
			   $lang_files ="";
			   $lang_directories ="";
			   
			   // we may need to attach a local path to the file
			   $file_dir = dirname(__FILE__) . "/";
			   $working_dir = getcwd();
			   
			   $local_path = str_replace($file_dir, "", $working_dir);
				   
			   if (!empty($local_path)) {
				   $local_path .= "/";
			   }
			   
			   while (($file = readdir($dh)) !== false) {
				   if (filetype($dir . $file) == "file") {
					   $lang_files .= "<a href='language_pack_editor.php?langfile=" . $local_path . $file  . "'>" . $file . "</a><br />";
				   }
				   elseif (filetype($dir . $file) == "dir") {
					   $lang_directories .= "<a href='language_pack_editor.php?langdir=" . $local_path . $file  . "'>" . $file . "</a><br />";
				   }
			   }
			   closedir($dh);
			   $output .= "<p>Select a file to edit.</p>";
			   $output .= "<table border='0' cellpadding='10'>";
			   $output .= "<tr>";
			   $output .= "<td valign='top' width='100'>" . $lang_directories . "</td>";
			   $output .= "<td valign='top'>" . $lang_files . "</td>";
			   $output .= "</tr></table>";
		   }
		}
	}
}
elseif (isset($_REQUEST['login'])) {
	if (isset($_REQUEST['form_password']) && !empty($_REQUEST['form_password']) && $_REQUEST['form_password'] == $file_password) {
		$_SESSION['session_password'] = $file_password;
	}
	
	header("Location: language_pack_editor.php?" . strip_tags(SID));
	exit;
}
else { // not logged in
	$output .= <<<eof
	<p>Please enter your file password to continue.<br /><p>
	<form action='language_pack_editor.php' method='post'>
	<input type='password' name='form_password' value=''><br />
	<input type='submit' name='login' value='enter'>
	</form>
eof;
}


$html = <<<eof
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<title>Barnraiser software language pack editor</title>
<style type="text/css">
body	{
	font-family:Verdana,Arial,Helvetica,Geneva,sans-serif;
		font-size: 70%; 
		color: #666666; 
		padding:10px;
		width:700px;
	background-color:#FFF;
}

h2 {
		font-size: 1.5em; 
		font-weight: bold;
	}
	
	a {
		color: #666666; 
	}
	
	a:hover {
		color: #44BBCC
; 
	}
</style>
</head>
<body>
$output
</body>
</html>
eof;

echo $html;
?>
