<?php

// -----------------------------------------------------------------------
// This file is part of beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//

// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Comment {
	// CLASS FUNCTIONS
	// Comment
	// getCommentCount
	// selComments
	// insertComment
	
	
	
	// Comment ---------------------------------------------------------------
	// the constuctor
	// tom calthrop - 23rd December 2004
	//
	function Comment($db, $date) {
		$this->db = $db;
		$this->date = $date;
	}//EO Comment

	
	
	// getCommentCount --------------------------------------------------------------------
	// returns a count if a particular item
	// tom calthrop - 31st May 2005
	//
	function getCommentCount() {
		
		$query = "
			SELECT count(comment_id) as total 
			FROM " . $this->db->prefix . "_comment 
			WHERE "
		;
		
		if (isset($this->item_id)) {
			$query .= "item_id=" . $this->item_id . " and ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields['total'])) {
			
			return $result->fields['total'];
		}
		else {
			$error_info = "function=getCommentCount class=Comment.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	}//EO getCommentCount

	
	
	// selComments --------------------------------------------------------------------
	// select comments (either for a wikipage name or an item_id
	// tom calthrop - 31st May 2005
	//
	function selComments($item_id = null, $wikipage=null) {
		
		if (isset($wikipage)) {
			// we need to get the item IDs associated with this wiki page
			$query = "
				SELECT i.item_id 
				FROM " . $this->db->prefix . "_wiki w, " . $this->db->prefix . "_item i 
				WHERE 
				w.wiki_id=i.wiki_id AND 
				w.wiki_page=" . $this->db->qstr($wikipage, get_magic_quotes_gpc())
			;
			
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				$item_ids = array();
				
				while (!$result->EOF) {
					array_push($item_ids, $result->fields['item_id']);
					$result->MoveNext();
				}
			}
		}
		elseif (!isset($item_id) && isset($this->item_id)) {
		    $item_id = $this->item_id;
		}
		
		
		
		$query = "
			SELECT c.comment_id, c.comment_parent_id, c.comment_body, c.user_id, c.item_id, 
			c.comment_create_datetime, u.user_id, u.user_name, u.user_email, u.show_email 
			FROM " . $this->db->prefix . "_comment c, " . $this->db->prefix . "_user u 
			WHERE
			c.user_id=u.user_id AND "
		;
		
		if (isset($this->user_id)) {
		    $query .= "c.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($item_ids)) {
			$sel_item_ids = "";
			foreach($item_ids as $key => $i):
				$sel_item_ids .= $i;
				if (count($item_ids) > $key+1) {
					$sel_item_ids .=",";
				}
			endforeach;
			$query .= "c.item_id in (" . $sel_item_ids . ") AND ";
		}
		elseif (isset($item_id)) {
			$query .= "c.item_id=" . $item_id . " and ";
		}
		
		$query .= "1=1 ";
		
		if (isset($this->orderby)) {
			$query .= "order by " . $this->orderby;
		}
		else {
			$query .= "order by c.comment_create_datetime";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				$temp1['comment_create_datetime'] = $this->date->formatDate($temp1['comment_create_datetime'], 1);
				$temp1['comment_body'] = nl2br($temp1['comment_body']);
				$temp1['user_email'] = formatEmail($temp1['user_email']);
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
			
		}
		else {
			$error_info = "function=selComments class=Comment.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	}//EO selComments
	
	
	
	// insertComment --------------------------------------------------------------------
	// inserts a comment
	// tom calthrop - 31st May 2005
	//
	function insertComment($data) {
		if (empty($data['comment_body'])) {
		    $GLOBALS['beacon_error_log'][] = array(12, null, null);
		}
		
		if (empty($GLOBALS['beacon_error_log'])) {
			$data['comment_body'] = htmlspecialchars($data['comment_body']);
		
			$rec = array();
			$rec['item_id'] = $data['item_id'];
			$rec['comment_body'] = $data['comment_body'];
			$rec['comment_create_datetime'] = time();
			$rec['user_id'] = $this->user_id;
			
			$table = $this->db->prefix . "_comment";
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			
			$result = $this->db->Execute($query);
	
			if (empty($result)) {
				$error_info = "function=insertComment class=Comment.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['beacon_error_log'][] = array(1, $error_info);
			}
		}
	}//EO insertComment
}
?>
