<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

require_once($languagePath . 'common.lang.php');


// HEADERS
$lang['hdr_welcome'] = 						"welcome";
$lang['hdr_membership'] = 					"your account";
$lang['hdr_help'] = 						"get help";
$lang['hdr_about_beacon'] = 				"about Beacon";
$lang['hdr_login'] = 						"login";
$lang['hdr_password'] = 					"forgotten password?";
$lang['hdr_credits'] = 						"credits";
$lang['hdr_man'] = 							"guide for this software";
$lang['hdr_register'] = 					"register";


// FIELDSETS
$lang['fld_preferences'] = 					"preferences";
$lang['fld_details'] = 						"account";
$lang['fld_register'] = 					"register";


// SUBMIT
$lang['sub_register'] = 					"register";


//A HREF TAGS (links)
$lang['href_help'] = 						"view the manual";
$lang['href_membership'] = 					"update your account";


// TEXTS
$lang['txt_introduction'] = 				"<h3>Welcome to Beacon; the SIMPLE free wiki and tag based publishing system!</h3><p>Beacon allows non technical people easy page editing and categorization of web pages making Beacon idea for groups of people wishing to collaborate around a documentation or composition project.</p>";
$lang['txt_help_introduction'] = 			"Help is always available to you through your help wiki pages.";
$lang['txt_membership_introduction'] = 		"Update your account information. Remember this information is only accessible by system administrators and is used to maintain your account.";
$lang['txt_public_introduction'] = 			"<h3>Welcome to Beacon; the SIMPLE free wiki and tag based publishing system!</h3><p>Beacon allows non technical people easy page editing and categorization of web pages making Beacon idea for groups of people wishing to collaborate around a documentation or composition project.</p><p>This is a demo for you to look at. You can log in using the email address <b>demo@barnraiser.org</b> and the password <b>demo4me</b>.</p>";
$lang['txt_about_beacon'] = 				"Barnraiser is an organisation dedicated to giving people the tools they need to share knowledge and advance society through social software.<br /><p>As part of their mission they maintain 'Beacon', the software platform that you are using now.<br /></p><p>Visit Barnraiser at <a href=\"http://www.barnraiser.org/\" target=\"_new\">www.barnraiser.org</a> to find out more about their work.<br /></p>";
$lang['txt_login_note'] = 					"You will remain logged in until you press 'logoff' or exit the browser.";
$lang['txt_new_password'] = 				"If you have forgotten your password you can <a href =\"splash.php?new_password=1\">get a new password here</a>.";
$lang['txt_credits'] = 						"Beacon was conceived by Tom Calthrop, founder of Barnraiser and Beacon project maintainer. Many thanks to the developers who have given time, energy and expertise to the Beacon project!";
$lang['txt_allow_correspondence'] = 		"We may wish to contact you with an occasional newsletter. Is it ok for us to send that to you?";
$lang['txt_show_email'] = 					"Are you ok for us to show that so that other people can contact you?";
$lang['txt_preferences_intro'] = 			"Please check the preference checkboxes if you would like the following.";
$lang['txt_register_intro'] = 				" Please type the characters that you see below then press 'register'. You will be sent an email. Once you get it press the link to complete registration.";
$lang['txt_captcha_intro'] = 				"If you are visually impaired or cannot otherwise read the characters please contact us. You can find contact details in our '<a href='structure.php'>structure</a>' section.";


// MAIL
$lang['txt_mail_subject_new_pass'] = 		"You've requested a new password";
$lang['txt_mail_subject_register'] = 		"Complete your registration";

?>
