<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_Watchdog
{
  /**
  * Singleton logic.
  */
  private static $instance;
  private $db;
  private function __construct () {
    $this->db = Database_SQLite::connect ("watchdog");
  }
  public static function getInstance()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_Watchdog();
    }
    return self::$instance;
  }


  public function create ()
  {
$sql = <<<'EOD'
CREATE TABLE IF NOT EXISTS watchdog (
  timestamp int
);
EOD;
    Database_SQLite::exec ($this->db, $sql);
  }


  public function optimize () {
    Database_SQLite::exec ($this->db, "REINDEX watchdog;");
    Database_SQLite::exec ($this->db, "VACUUM watchdog;");
  }


  public function kick ()
  {
    $timestamp = time ();
    $query = "DELETE FROM watchdog;";
    Database_SQLite::exec ($this->db, $query);
    $query = "INSERT INTO watchdog (timestamp) VALUES ($timestamp);";
    Database_SQLite::exec ($this->db, $query);
  }
  
  
  public function alive ()
  {
    $query = "SELECT timestamp FROM watchdog;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return ($row ['timestamp'] > (time () - 5));
    }
    return false;
  }


}



?>
